/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.grouping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.sql.SQLGroupingAttribute;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.StringContentProposalProvider;
import org.jkiss.dbeaver.ui.controls.StringEditorTable;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingResultsContainer;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

class GroupingConfigDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.GroupingConfigDialog";
    private final GroupingResultsContainer resultsContainer;
    private Table columnsTable;
    private Table functionsTable;

    public GroupingConfigDialog(Shell parentShell, GroupingResultsContainer resultsContainer) {
        super(parentShell, "Grouping configuration", null);
        this.resultsContainer = resultsContainer;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        ArrayList<String> proposals = new ArrayList<String>();
        DBDAttributeBinding[] dBDAttributeBindingArray = this.resultsContainer.getOwnerPresentation().getController().getModel().getAttributes();
        int n = dBDAttributeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
            proposals.add(attr.getName());
            ++n2;
        }
        StringContentProposalProvider proposalProvider = new StringContentProposalProvider(new String[0]);
        proposalProvider.setProposals(proposals.toArray(new String[0]));
        this.columnsTable = StringEditorTable.createCustomEditableList((Composite)composite, (String)"Columns", this.resultsContainer.getGroupAttributes(), (StringEditorTable.TableValuesManager)new GroupingAttributeValueManager(), (IContentProposalProvider)proposalProvider, (boolean)true);
        Collections.addAll(proposals, "COUNT", "AVG", "MAX", "MIN", "SUM");
        proposalProvider.setProposals(proposals.toArray(new String[0]));
        this.functionsTable = StringEditorTable.createEditableList((Composite)composite, (String)"Functions", this.resultsContainer.getGroupFunctions(), (DBPImage)DBIcon.TREE_FUNCTION, (IContentProposalProvider)proposalProvider);
        return composite;
    }

    protected void okPressed() {
        List attributes = StringEditorTable.collectCustomValues((Table)this.columnsTable);
        List functions = StringEditorTable.collectStringValues((Table)this.functionsTable);
        this.resultsContainer.setGrouping(attributes, functions);
        super.okPressed();
    }

    private class GroupingAttributeValueManager
    implements StringEditorTable.TableValuesManager<SQLGroupingAttribute> {
        private GroupingAttributeValueManager() {
        }

        @NotNull
        public DBPImage getIcon(@Nullable SQLGroupingAttribute value) {
            if (value instanceof SQLGroupingAttribute.BoundAttribute) {
                SQLGroupingAttribute.BoundAttribute bound = (SQLGroupingAttribute.BoundAttribute)value;
                DBSDataType type = bound.getBinding().getDataType();
                return type == null ? DBIcon.TYPE_UNKNOWN : DBValueFormatting.getTypeImage((DBSTypedObject)type);
            }
            return DBIcon.TREE_ATTRIBUTE;
        }

        @NotNull
        public String getString(@Nullable SQLGroupingAttribute value) {
            return value == null ? "" : value.getDisplayName();
        }

        @NotNull
        public Boolean isEditable(@Nullable SQLGroupingAttribute value) {
            if (value != null && !(value instanceof SQLGroupingAttribute.CustomAttribute)) {
                return false;
            }
            return true;
        }

        @Nullable
        public SQLGroupingAttribute prepareNewValue(@Nullable SQLGroupingAttribute originalValue, @Nullable String string) {
            if (CommonUtils.isNotEmpty((String)string)) {
                return SQLGroupingAttribute.makeCustom((DBPDataSource)GroupingConfigDialog.this.resultsContainer.getDataContainer().getDataSource(), (String)string);
            }
            return null;
        }
    }
}

