/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.expressions;

import java.util.Collection;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.expressions.WorkbenchWindowExpression;

public final class LegacyActionSetExpression
extends WorkbenchWindowExpression {
    private final String actionSetId;

    public LegacyActionSetExpression(String actionSetId, IWorkbenchWindow window) {
        super(window);
        if (actionSetId == null) {
            throw new NullPointerException("The action set identifier cannot be null");
        }
        this.actionSetId = actionSetId;
    }

    @Override
    public void collectExpressionInfo(ExpressionInfo info) {
        super.collectExpressionInfo(info);
        info.addVariableNameAccess("activeContexts");
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof LegacyActionSetExpression) {
            LegacyActionSetExpression that = (LegacyActionSetExpression)((Object)object);
            return LegacyActionSetExpression.equals((Object)this.actionSetId, (Object)that.actionSetId) && LegacyActionSetExpression.equals((Object)this.getWindow(), (Object)that.getWindow());
        }
        return false;
    }

    @Override
    public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
        EvaluationResult result = super.evaluate(context);
        if (result == EvaluationResult.FALSE) {
            return result;
        }
        Object obj = context.getVariable("activeContexts");
        if (obj instanceof Collection) {
            return EvaluationResult.valueOf((boolean)((Collection)obj).contains(this.actionSetId));
        }
        return EvaluationResult.FALSE;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("ActionSetExpression(");
        buffer.append(this.actionSetId);
        buffer.append(',');
        buffer.append(this.getWindow());
        buffer.append(')');
        return buffer.toString();
    }
}

