/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.registry.RegistryReader;

public class PerspectiveDescriptor
implements IPerspectiveDescriptor,
IPluginContribution {
    private String id;
    private String label;
    private ImageDescriptor image;
    private IConfigurationElement configElement;
    private boolean hasCustomDefinition;
    private String pluginId;
    private String originalId;
    private String defaultShowIn;

    public PerspectiveDescriptor(String id, String label, PerspectiveDescriptor originalDescriptor) {
        this.id = id;
        this.label = label;
        if (originalDescriptor != null) {
            this.originalId = originalDescriptor.getOriginalId();
            this.image = originalDescriptor.getImageDescriptor();
            this.pluginId = originalDescriptor.getPluginId();
            this.hasCustomDefinition = true;
            this.defaultShowIn = originalDescriptor.getDefaultShowIn();
        }
    }

    PerspectiveDescriptor(String id, IConfigurationElement element) {
        this.id = id;
        this.configElement = element;
    }

    public IConfigurationElement getConfigElement() {
        return this.configElement;
    }

    public IPerspectiveFactory createFactory() {
        try {
            return (IPerspectiveFactory)this.configElement.createExecutableExtension("class");
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDescription() {
        return this.configElement == null ? null : RegistryReader.getDescription(this.configElement);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getOriginalId() {
        if (this.originalId == null) {
            this.originalId = this.getId();
        }
        return this.originalId;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        String icon;
        if (this.image != null) {
            return this.image;
        }
        if (this.configElement != null && (icon = this.configElement.getAttribute("icon")) != null) {
            this.image = ResourceLocator.imageDescriptorFromBundle((String)this.configElement.getNamespaceIdentifier(), (String)icon).orElse(null);
        }
        if (this.image == null) {
            this.image = WorkbenchImages.getImageDescriptor("IMG_ETOOL_DEF_PERSPECTIVE");
        }
        return this.image;
    }

    public void setImageDescriptor(ImageDescriptor image) {
        this.image = image;
    }

    @Override
    public String getLabel() {
        return this.configElement == null ? this.label : this.configElement.getAttribute("name");
    }

    @Override
    public String getLocalId() {
        return this.getId();
    }

    @Override
    public String getPluginId() {
        return this.configElement == null ? this.pluginId : this.configElement.getNamespaceIdentifier();
    }

    public boolean hasCustomDefinition() {
        return this.hasCustomDefinition;
    }

    public void setHasCustomDefinition(boolean value) {
        this.hasCustomDefinition = value;
    }

    public boolean isPredefined() {
        return this.configElement != null;
    }

    public boolean isSingleton() {
        return false;
    }

    public String toString() {
        return this.getClass().getName() + " {id=" + this.getId() + "}";
    }

    @Override
    public String getDefaultShowIn() {
        return this.defaultShowIn == null && this.configElement != null ? this.configElement.getAttribute("defaultShowIn") : this.defaultShowIn;
    }
}

