define(["exports","./../dom.js"],function(_exports,_dom){function TinyGesture(element,options){this.element=element,this.touch1=null,this.touch2=null,this.touchStartX=null,this.touchStartY=null,this.touchEndX=null,this.touchEndY=null,this.touchMove1=null,this.touchMove2=null,this.touchMoveX=null,this.touchMoveY=null,this.velocityX=null,this.velocityY=null,this.longPressTimer=null,this.doubleTapTimer=null,this.doubleTapWaiting=!1,this.thresholdX=0,this.thresholdY=0,this.disregardVelocityThresholdX=0,this.disregardVelocityThresholdY=0,this.swipingHorizontal=!1,this.swipingVertical=!1,this.swipingDirection=null,this.swipedHorizontal=!1,this.swipedVertical=!1,this.originalDistance=null,this.newDistance=null,this.scale=null,this.originalAngle=null,this.newAngle=null,this.rotation=null,this.handlers={panstart:[],panmove:[],panend:[],swipeleft:[],swiperight:[],swipeup:[],swipedown:[],tap:[],doubletap:[],longpress:[],pinch:[],pinchend:[],rotate:[],rotateend:[]},this._onTouchStart=this.onTouchStart.bind(this),this._onTouchMove=this.onTouchMove.bind(this),this._onTouchEnd=this.onTouchEnd.bind(this),this.opts=Object.assign({},TinyGesture.defaults,options),_dom.default.addEventListener(this.element,"touchstart",this._onTouchStart,{passive:!0}),this.element.addEventListener("touchmove",this._onTouchMove),_dom.default.addEventListener(this.element,"touchend",this._onTouchEnd,{passive:!0})}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,TinyGesture.prototype.destroy=function(){var _a;_dom.default.removeEventListener(this.element,"touchstart",this._onTouchStart,{passive:!0}),this.element.removeEventListener("touchmove",this._onTouchMove),_dom.default.removeEventListener(this.element,"touchend",this._onTouchEnd,{passive:!0}),clearTimeout(null!=(_a=this.longPressTimer)?_a:void 0),clearTimeout(null!=(_a=this.doubleTapTimer)?_a:void 0)},TinyGesture.prototype.on=function(type,fn){var _this=this;if(this.handlers[type])return this.handlers[type].push(fn),{type:type,fn:fn,cancel:function(){return _this.off(type,fn)}}},TinyGesture.prototype.off=function(type,fn){this.handlers[type]&&-1!==(fn=this.handlers[type].indexOf(fn))&&this.handlers[type].splice(fn,1)},TinyGesture.prototype.fire=function(type,event){for(var i=0;i<this.handlers[type].length;i++)this.handlers[type][i](event)},TinyGesture.prototype.onTouchStart=function(event){var _a,_this2=this,didTouch1=!1;if("mousedown"!==event.type){if(this.touch1||(this.touch1=event.changedTouches[0],didTouch1=!0),(didTouch1&&1<event.changedTouches.length||!didTouch1)&&!this.touch2)return this.touch2=babelHelpers.toConsumableArray(event.changedTouches).find(function(touch){return touch.identifier!==(null==(touch=_this2.touch1)?void 0:touch.identifier)})||null,this.originalDistance=Math.sqrt(Math.pow((null!=(_a=null==(_a=this.touch2)?void 0:_a.screenX)?_a:0)-(null!=(_a=null!=(_a=null==(_a=this.touchMove1)?void 0:_a.screenX)?_a:null==(_a=this.touch1)?void 0:_a.screenX)?_a:0),2)+Math.pow((null!=(_a=null==(_a=this.touch2)?void 0:_a.screenY)?_a:0)-(null!=(_a=null!=(_a=null==(_a=this.touchMove1)?void 0:_a.screenY)?_a:null==(_a=this.touch1)?void 0:_a.screenY)?_a:0),2)),void(this.originalAngle=Math.atan2((null!=(_a=null==(_a=this.touch2)?void 0:_a.screenY)?_a:0)-(null!=(_a=null!=(_a=null==(_a=this.touchMove1)?void 0:_a.screenY)?_a:null==(_a=this.touch1)?void 0:_a.screenY)?_a:0),(null!=(_a=null==(_a=this.touch2)?void 0:_a.screenX)?_a:0)-(null!=(_a=null!=(_a=null==(_a=this.touchMove1)?void 0:_a.screenX)?_a:null==(_a=this.touch1)?void 0:_a.screenX)?_a:0))/(Math.PI/180));if(!didTouch1)return}!didTouch1&&"mousedown"!==event.type||(this.thresholdX=this.opts.threshold("x",this),this.thresholdY=this.opts.threshold("y",this),this.disregardVelocityThresholdX=this.opts.disregardVelocityThreshold("x",this),this.disregardVelocityThresholdY=this.opts.disregardVelocityThreshold("y",this),this.touchStartX="mousedown"===event.type?event.screenX:(null==(_a=this.touch1)?void 0:_a.screenX)||0,this.touchStartY="mousedown"===event.type?event.screenY:(null==(didTouch1=this.touch1)?void 0:didTouch1.screenY)||0,this.touchMoveX=null,this.touchMoveY=null,this.touchEndX=null,this.touchEndY=null,this.swipingDirection=null,this.longPressTimer=setTimeout(function(){return _this2.fire("longpress",event)},this.opts.longPressTime),this.scale=1,this.rotation=0,this.fire("panstart",event))},TinyGesture.prototype.onTouchMove=function(event){var touch1,touch2,_c,_this3=this;("mousemove"!==event.type||this.touchStartX&&null===this.touchEndX)&&(touch2=touch1=void 0,"mousemove"!==event.type&&(touch1=babelHelpers.toConsumableArray(event.changedTouches).find(function(touch){return touch.identifier===(null==(touch=_this3.touch1)?void 0:touch.identifier)}),this.touchMove1=touch1||this.touchMove1,touch2=babelHelpers.toConsumableArray(event.changedTouches).find(function(touch){return touch.identifier===(null==(touch=_this3.touch2)?void 0:touch.identifier)}),this.touchMove2=touch2||this.touchMove2),"mousemove"!==event.type&&!touch1||(touch2=("mousemove"===event.type?event.screenX:null!=(touch2=null==touch1?void 0:touch1.screenX)?touch2:0)-(null!=(touch2=this.touchStartX)?touch2:0),this.velocityX=touch2-(null!=(_c=this.touchMoveX)?_c:0),this.touchMoveX=touch2,touch1=("mousemove"===event.type?event.screenY:null!=(_c=null==touch1?void 0:touch1.screenY)?_c:0)-(null!=(touch2=this.touchStartY)?touch2:0),this.velocityY=touch1-(null!=(_c=this.touchMoveY)?_c:0),this.touchMoveY=touch1,touch2=Math.abs(this.touchMoveX),_c=Math.abs(this.touchMoveY),this.swipingHorizontal=touch2>this.thresholdX,this.swipingVertical=_c>this.thresholdY,this.swipingDirection=_c<touch2?this.swipingHorizontal?"horizontal":"pre-horizontal":this.swipingVertical?"vertical":"pre-vertical",Math.max(touch2,_c)>this.opts.pressThreshold&&clearTimeout(null!=(touch1=this.longPressTimer)?touch1:void 0),this.fire("panmove",event)),"mousemove"!==event.type)&&null!=this.touchMove1&&null!=this.touchMove2&&(this.newDistance=Math.sqrt(Math.pow(this.touchMove2.screenX-this.touchMove1.screenX,2)+Math.pow(this.touchMove2.screenY-this.touchMove1.screenY,2)),this.scale=this.newDistance/(null!=(touch2=this.originalDistance)?touch2:0),this.fire("pinch",event),this.newAngle=Math.atan2((null!=(_c=this.touchMove2.screenY)?_c:0)-(null!=(touch1=this.touchMove1.screenY)?touch1:0),(null!=(touch2=this.touchMove2.screenX)?touch2:0)-(null!=(_c=this.touchMove1.screenX)?_c:0))/(Math.PI/180),this.rotation=this.newAngle-(null!=(touch1=this.originalAngle)?touch1:0),this.fire("rotate",event))},TinyGesture.prototype.onTouchEnd=function(event){var _a,_e,absY,distance,absDistance,diagonal,_this4=this,touch1=void 0;"mouseup"!==event.type&&(touch1=babelHelpers.toConsumableArray(event.changedTouches).find(function(touch){return touch.identifier===(null==(touch=_this4.touch1)?void 0:touch.identifier)}),babelHelpers.toConsumableArray(event.touches).find(function(touch){return touch.identifier===(null==(touch=_this4.touch1)?void 0:touch.identifier)})||(this.touch1=null,this.touchMove1=null),babelHelpers.toConsumableArray(event.touches).find(function(touch){return touch.identifier===(null==(touch=_this4.touch2)?void 0:touch.identifier)})||(this.touch2=null,this.touchMove2=null)),("mouseup"!==event.type||this.touchStartX&&null===this.touchEndX)&&("mouseup"!==event.type&&!touch1||(this.touchEndX="mouseup"===event.type?event.screenX:null!=(_a=null==touch1?void 0:touch1.screenX)?_a:0,this.touchEndY="mouseup"===event.type?event.screenY:null!=(_a=null==touch1?void 0:touch1.screenY)?_a:0,this.fire("panend",event),clearTimeout(null!=(touch1=this.longPressTimer)?touch1:void 0),touch1=this.touchEndX-(null!=(_a=this.touchStartX)?_a:0),_a=Math.abs(touch1),_e=this.touchEndY-(null!=(_e=this.touchStartY)?_e:0),absY=Math.abs(_e),distance=Math.sqrt(Math.pow(touch1,2)+Math.pow(_e,2)),absDistance=Math.abs(distance),diagonal=absY/_a,_a>this.thresholdX||absY>this.thresholdY||this.opts.diagonalSwipes&&(absDistance>this.thresholdX||absDistance>this.thresholdY)?(this.swipedHorizontal=_a>this.thresholdX||this.opts.diagonalSwipes&&absDistance>this.thresholdX,this.swipedVertical=absY>this.thresholdY||this.opts.diagonalSwipes&&absDistance>this.thresholdY,(!this.opts.diagonalSwipes||diagonal<Math.tan((45-this.opts.diagonalLimit)*Math.PI/180)||diagonal>Math.tan((45+this.opts.diagonalLimit)*Math.PI/180))&&(absY<=_a&&(this.swipedVertical=!1),_a<absY)&&(this.swipedHorizontal=!1),this.swipedHorizontal&&(touch1<0?((null!=(absDistance=this.velocityX)?absDistance:0)<-this.opts.velocityThreshold||distance<-this.disregardVelocityThresholdX)&&this.fire("swipeleft",event):((null!=(diagonal=this.velocityX)?diagonal:0)>this.opts.velocityThreshold||distance>this.disregardVelocityThresholdX)&&this.fire("swiperight",event)),this.swipedVertical&&(_e<0?((null!=(touch1=this.velocityY)?touch1:0)<-this.opts.velocityThreshold||distance<-this.disregardVelocityThresholdY)&&this.fire("swipeup",event):((null!=(absDistance=this.velocityY)?absDistance:0)>this.opts.velocityThreshold||distance>this.disregardVelocityThresholdY)&&this.fire("swipedown",event))):_a<this.opts.pressThreshold&&absY<this.opts.pressThreshold&&(this.doubleTapWaiting?(this.doubleTapWaiting=!1,clearTimeout(null!=(diagonal=this.doubleTapTimer)?diagonal:void 0),this.fire("doubletap",event)):(this.doubleTapWaiting=!0,this.doubleTapTimer=setTimeout(function(){return _this4.doubleTapWaiting=!1},this.opts.doubleTapTime),this.fire("tap",event)))),this.touch1||this.touch2||(this.fire("pinchend",event),this.fire("rotateend",event),this.originalDistance=null,this.newDistance=null,this.scale=null,this.originalAngle=null,this.newAngle=null,this.rotation=null))},TinyGesture.defaults={threshold:function(type,_self){return Math.max(25,Math.floor(.15*("x"===type?_dom.default.getWindowSize().innerWidth:_dom.default.getWindowSize().innerHeight)))},velocityThreshold:10,disregardVelocityThreshold:function(type,self){return Math.floor(.5*("x"===type?self.element.clientWidth:self.element.clientHeight))},pressThreshold:8,diagonalSwipes:!1,diagonalLimit:Math.tan(.375*Math.PI),longPressTime:500,doubleTapTime:300};_exports.default=TinyGesture});