/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.task;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.freeplane.plugin.codeexplorer.task.BundlingGroupMatcher;
import org.freeplane.plugin.codeexplorer.task.GroupIdentifier;
import org.freeplane.plugin.codeexplorer.task.GroupMatcher;

class LocationMatcherFactory {
    private final GroupMatcher matcher;

    LocationMatcherFactory(GroupMatcher matcher, JavaClasses classes, Map<String, String> nameGroups) {
        HashMap<String, GroupIdentifier> bundledGroups = new HashMap<String, GroupIdentifier>();
        HashMap bundledIDentifiersByName = new HashMap();
        Map<String, String> groupedProjectIDs = classes.stream().filter(jc -> matcher.projectIdentifier((JavaClass)jc).isPresent()).collect(Collectors.toMap(jc -> matcher.projectIdentifier((JavaClass)jc).get().getId(), jc -> matcher.groupIdentifier((JavaClass)jc).get().getId(), (x, y) -> x == y ? x : LocationMatcherFactory.throwException(x, y)));
        classes.stream().map(jc -> matcher.projectIdentifier((JavaClass)jc)).filter(Optional::isPresent).map(Optional::get).forEach(gi -> {
            String groupName = (String)nameGroups.get(gi.getName());
            if (groupName != null) {
                bundledGroups.computeIfAbsent((String)groupedProjectIDs.get(gi.getId()), x -> bundledIDentifiersByName.computeIfAbsent(groupName, y -> new GroupIdentifier(groupName, groupName)));
            }
        });
        this.matcher = new BundlingGroupMatcher(matcher, bundledGroups);
    }

    private static String throwException(String u, String v) {
        throw new IllegalStateException(String.format("Duplicate values %s, %s", u, v));
    }

    GroupMatcher createMatcher() {
        return this.matcher;
    }
}

