/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.extend;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfProgramHeaderType;
import ghidra.app.util.bin.format.elf.ElfSectionHeaderType;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.extend.ElfExtension;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Language;
import org.apache.commons.lang3.StringUtils;

public class AARCH64_ElfExtension
extends ElfExtension {
    public static final ElfProgramHeaderType PT_AARCH64_ARCHEXT = new ElfProgramHeaderType(0x70000000, "PT_AARCH64_ARCHEXT", "AARCH64 extension");
    public static final ElfSectionHeaderType SHT_AARCH64_ATTRIBUTES = new ElfSectionHeaderType(0x70000003, "SHT_AARCH64_ATTRIBUTES", "Attribute section");
    private static final int SHF_ENTRYSECT = 0x10000000;
    private static final int SHF_COMDEF = Integer.MIN_VALUE;

    public boolean canHandle(ElfHeader elf) {
        return elf.e_machine() == 183;
    }

    public boolean canHandle(ElfLoadHelper elfLoadHelper) {
        Language language = elfLoadHelper.getProgram().getLanguage();
        return this.canHandle(elfLoadHelper.getElfHeader()) && "AARCH64".equals(language.getProcessor().toString());
    }

    public String getDataTypeSuffix() {
        return "_AARCH64";
    }

    public Address evaluateElfSymbol(ElfLoadHelper elfLoadHelper, ElfSymbol elfSymbol, Address address, boolean isExternal) {
        if (isExternal) {
            return address;
        }
        String symName = elfSymbol.getNameAsString();
        if (StringUtils.isBlank((CharSequence)symName)) {
            return address;
        }
        if ("$x".equals(symName) || symName.startsWith("$x.")) {
            elfLoadHelper.markAsCode(address);
            elfLoadHelper.setElfSymbolAddress(elfSymbol, address);
            return null;
        }
        if ("$d".equals(symName) || symName.startsWith("$d.")) {
            elfLoadHelper.createUndefinedData(address, (int)elfSymbol.getSize());
            elfLoadHelper.setElfSymbolAddress(elfSymbol, address);
            return null;
        }
        return address;
    }
}

