/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.config;

import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.rzo.yajsw.config.ConfigurationBinding;
import org.rzo.yajsw.config.YajswConfigurationInterpolator;
import org.rzo.yajsw.util.MyKeyStoreInterface;

public class VarInterpolator
extends ConfigurationInterpolator
implements YajswConfigurationInterpolator {
    Configuration _conf;
    Map _cache = null;
    String[] _imports = null;
    InternalLogger log = InternalLoggerFactory.getInstance(this.getClass().getName());
    Map<String, String> _fromBinding = new HashMap<String, String>();
    volatile MyKeyStoreInterface _ks = null;
    byte _level = 0;
    private ConfigurationBinding _binding;

    public VarInterpolator(Configuration conf, boolean cache, String[] imports, Map utils) {
        this._conf = conf;
        this._binding = new ConfigurationBinding(conf, utils);
        this.setCache(cache);
        this._imports = imports;
    }

    public VarInterpolator(Configuration conf) {
        this(conf, false, null, null);
    }

    public void setCache(boolean cache) {
        if (cache) {
            this._cache = new HashMap();
        }
    }

    @Override
    public Object interpolate(Object value) {
        Object cachedResult;
        if (!(value instanceof String)) {
            return value;
        }
        if (this._cache != null && (cachedResult = this._cache.get(value)) != null) {
            return cachedResult;
        }
        String result = (String)value;
        try {
            if (result.startsWith("${keystore ")) {
                String x = result.substring(11);
                x = x.substring(0, x.lastIndexOf(125));
                return this.getFromKeystore(x.trim());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        int i = result.lastIndexOf("${");
        while (i != -1) {
            int r = this.getExpression(result, i + 2);
            String expression = result.substring(i + 2, r);
            this._level = (byte)(this._level + 1);
            String eval = this.evaluate(expression);
            this._level = (byte)(this._level - 1);
            String p1 = result.substring(0, i);
            String p2 = result.substring(r + 1);
            result = p1 + eval + p2;
            i = result.lastIndexOf("${");
            if (i == -1 || value == null || result == null || !value.equals(result)) continue;
            result = "?unresolved?cycle";
            i = -1;
        }
        if (this._cache != null) {
            this._cache.put(value, result);
        }
        return result;
    }

    public String getFromKeystore(String key) throws Exception {
        MyKeyStoreInterface ks = this.getKeyStore();
        String result = new String(ks.get(key));
        return result;
    }

    private MyKeyStoreInterface getKeyStore() throws Exception {
        if (this._ks == null) {
            Class<?> clazz = MyKeyStoreInterface.class.getClassLoader().loadClass("org.rzo.yajsw.util.MyKeyStore");
            this._ks = (MyKeyStoreInterface)clazz.newInstance();
            this._ks.start();
        }
        return this._ks;
    }

    private int getExpression(String value, int i) {
        int i1 = value.indexOf(123, i);
        int i2 = value.indexOf(125, i);
        while (i1 != -1 && i2 > i1) {
            i2 = value.indexOf(125, i2 + 1);
            i1 = value.indexOf(123, i1 + 1);
        }
        return i2;
    }

    private String evaluate(String value) {
        if (this._level > 10) {
            return "?unresolved?recursion>10?";
        }
        String result = null;
        Exception caught = null;
        try {
            result = (String)this._binding.getVariable(value);
            if (result != null) {
                String result1 = result;
                while (result1 != null && result1.contains("${")) {
                    result1 = (String)this.interpolate(result1);
                }
                this._fromBinding.put(value, result1);
            }
        }
        catch (Exception ex) {
            caught = ex;
            try {
                result = this._conf.getString(value);
            }
            catch (Exception ex1) {
                caught = ex1;
            }
        }
        if (result == null) {
            try {
                result = this._binding.getVariable(value).toString();
            }
            catch (Exception ex) {
                caught = ex;
            }
        }
        if (result == null) {
            result = "?unresolved?";
            if (caught != null) {
                this.log.warn("error evaluating " + value + " : " + caught.getMessage());
            } else {
                this.log.warn("error evaluating " + value);
            }
        }
        return result;
    }

    public Map<String, String> getFromBinding() {
        return this._fromBinding;
    }

    @Override
    public Map<String, String> getUsedEnvVars() {
        return this._binding.getUsedEnvVars();
    }

    public static void main(String[] args) {
        VarInterpolator gi = new VarInterpolator(null);
        Object r = gi.interpolate("${relativeRAM.invoke('calc',15)}");
        System.out.println(r);
    }

    @Override
    public Object getBinding() {
        return this._binding;
    }
}

