/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.bitpatterns.gui.BitsInputDialogComponentProvider;
import ghidra.bitpatterns.gui.ClipboardPanel;
import ghidra.bitpatterns.gui.PatternInfoRowObject;
import ghidra.bitpatterns.info.ContextRegisterFilter;
import ghidra.bitpatterns.info.PatternType;
import ghidra.framework.preferences.Preferences;
import ghidra.util.Msg;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class ExportPatternFileActionListener
implements ActionListener {
    private static final String BITS_PROVIDER_MESSAGE = "Enter Bit Constraints";
    private static final String XML_EXPORT_DIR_PROPERTY = "ClipboardPanel_XML_EXPORT_DIR_PROPERTY";
    private ClipboardPanel clipboardPanel;
    private Component component;

    public ExportPatternFileActionListener(ClipboardPanel clipboardPanel, Component comp) {
        this.clipboardPanel = clipboardPanel;
        this.clipboardPanel.getAccessibleContext().setAccessibleName("Clipboard");
        this.component = comp;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File dir;
        List<PatternInfoRowObject> selected = this.clipboardPanel.getLastSelectedObjects();
        if (selected.isEmpty()) {
            return;
        }
        boolean containsPostPattern = false;
        boolean containsPrePattern = false;
        for (PatternInfoRowObject row : selected) {
            if (row.getPatternType().equals((Object)PatternType.FIRST)) {
                containsPostPattern = true;
            }
            if (!row.getPatternType().equals((Object)PatternType.PRE)) continue;
            containsPrePattern = true;
        }
        if (!containsPostPattern) {
            Msg.showWarn((Object)this, (Component)this.component, (String)"No Post Pattern", (Object)"Selected patterns must contain at least one post pattern");
            return;
        }
        if (!containsPrePattern) {
            Msg.showWarn((Object)this, (Component)this.component, (String)"No Pre Pattern", (Object)"Selected patterns must contain at least one pre pattern");
            return;
        }
        boolean proceed = this.checkConsistencyForExport(selected);
        if (!proceed) {
            return;
        }
        GhidraFileChooser gFileChooser = new GhidraFileChooser(this.component);
        gFileChooser.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        ExtensionFileFilter xmlFilter = new ExtensionFileFilter("xml", "XML Files");
        gFileChooser.setFileFilter((GhidraFileFilter)xmlFilter);
        String baseDir = Preferences.getProperty((String)XML_EXPORT_DIR_PROPERTY);
        if (baseDir != null && (dir = new File(baseDir)).isDirectory()) {
            gFileChooser.setCurrentDirectory(dir);
        }
        gFileChooser.setTitle("Select Export File");
        File outFile = gFileChooser.getSelectedFile();
        String lastDirPath = gFileChooser.getCurrentDirectory().getAbsolutePath();
        gFileChooser.dispose();
        if (gFileChooser.wasCancelled() || outFile == null) {
            return;
        }
        Preferences.setProperty((String)XML_EXPORT_DIR_PROPERTY, (String)lastDirPath);
        Preferences.store();
        BitsInputDialogComponentProvider bitsProvider = new BitsInputDialogComponentProvider(BITS_PROVIDER_MESSAGE);
        if (bitsProvider.isCanceled()) {
            return;
        }
        int totalBits = bitsProvider.getTotalBits();
        int postBits = bitsProvider.getPostBits();
        try {
            PatternInfoRowObject.exportXMLFile(selected, outFile, postBits, totalBits);
        }
        catch (IOException e1) {
            Msg.showError((Object)this, (Component)this.component, (String)"IO Error", (Object)"IO error exporting pattern xml file", (Throwable)e1);
        }
    }

    private boolean checkConsistencyForExport(List<PatternInfoRowObject> selected) {
        if (selected.isEmpty()) {
            Msg.showWarn((Object)this, (Component)this.component, (String)"Export Error", (Object)"Can't export empty selection.");
            return false;
        }
        Integer alignment = null;
        ContextRegisterFilter cRegFilter = null;
        for (PatternInfoRowObject row : selected) {
            if (!row.getPatternType().equals((Object)PatternType.FIRST)) continue;
            alignment = row.getAlignment();
            cRegFilter = row.getContextRegisterFilter();
            break;
        }
        for (PatternInfoRowObject row : selected) {
            if (!row.getPatternType().equals((Object)PatternType.FIRST) || Objects.equals(alignment, row.getAlignment()) && Objects.equals(cRegFilter, row.getContextRegisterFilter())) continue;
            Msg.showWarn((Object)this, (Component)this.component, (String)"Export Error", (Object)"Selected POST rows must all agree on alignment and context registers");
            return false;
        }
        return true;
    }
}

