/*
 * Decompiled with CFR 0.152.
 */
package ghidra.closedpatternmining;

import ghidra.closedpatternmining.FrequentSequenceItem;
import ghidra.closedpatternmining.ProjectedSequenceInfo;
import ghidra.closedpatternmining.Sequence;
import ghidra.closedpatternmining.SequenceDatabase;
import ghidra.closedpatternmining.SequenceItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ProjectedDatabase {
    private SequenceDatabase database;
    private List<SequenceItem> prefixSequence;
    private List<ProjectedSequenceInfo> projectedInfo;
    private int support;

    public ProjectedDatabase(SequenceDatabase database, List<SequenceItem> prefixSequence) {
        this.prefixSequence = prefixSequence;
        this.database = database;
        this.projectedInfo = new ArrayList<ProjectedSequenceInfo>();
        int numSequences = database.getSequences().size();
        for (int i = 0; i < numSequences; ++i) {
            Sequence seq = database.getSequences().get(i);
            int projectedIndex = seq.getIndexAfterFirstInstance(prefixSequence);
            if (projectedIndex == -1) continue;
            ProjectedSequenceInfo projSeq = new ProjectedSequenceInfo(i, projectedIndex);
            this.projectedInfo.add(projSeq);
            this.support += seq.getCount();
        }
    }

    public ProjectedDatabase(ProjectedDatabase projDatabase, SequenceItem extendingItem) {
        List<SequenceItem> initialList = projDatabase.getPrefix();
        SequenceItem lastItem = initialList.get(initialList.size() - 1);
        if (lastItem.getIndex() >= extendingItem.getIndex()) {
            throw new IllegalArgumentException("extending item must be after all items of the prefixSequence of projDatabase!");
        }
        this.database = projDatabase.getDatabase();
        this.prefixSequence = new ArrayList<SequenceItem>(initialList);
        this.prefixSequence.add(extendingItem);
        this.projectedInfo = new ArrayList<ProjectedSequenceInfo>();
        List<Sequence> sequences = this.database.getSequences();
        this.support = 0;
        int indexToCheck = extendingItem.getIndex();
        String symbolToFind = extendingItem.getSymbol();
        for (ProjectedSequenceInfo projSeq : projDatabase.getProjectedInfo()) {
            Sequence sequence = sequences.get(projSeq.getSequenceIndex());
            String seqAsString = sequence.getSequenceAsString();
            if (!seqAsString.substring(indexToCheck, indexToCheck + 1).equals(symbolToFind)) continue;
            this.support += sequence.getCount();
            ProjectedSequenceInfo extendedSequence = new ProjectedSequenceInfo(projSeq.getSequenceIndex(), indexToCheck + 1);
            this.projectedInfo.add(extendedSequence);
        }
    }

    public SequenceDatabase getDatabase() {
        return this.database;
    }

    public List<SequenceItem> getPrefix() {
        return this.prefixSequence;
    }

    public List<ProjectedSequenceInfo> getProjectedInfo() {
        return this.projectedInfo;
    }

    Set<String> getProjectedSequencesAsSet() {
        if (this.projectedInfo == null) {
            return null;
        }
        HashSet<String> projectedSeqs = new HashSet<String>();
        for (ProjectedSequenceInfo projSeq : this.projectedInfo) {
            Sequence seq = this.database.getSequences().get(projSeq.getSequenceIndex());
            String seqString = seq.getSequenceAsString();
            int end = seqString.length();
            int begin = Math.min(projSeq.getProjectedIndex(), end);
            projectedSeqs.add(seqString.substring(begin, end));
        }
        return projectedSeqs;
    }

    public int getSupport() {
        return this.support;
    }

    public TreeSet<FrequentSequenceItem> getLocallyFrequentItems(Set<FrequentSequenceItem> globallyFrequentItems, int minSupport) {
        HashMap<SequenceItem, Integer> frequentItemBag = new HashMap<SequenceItem, Integer>();
        for (ProjectedSequenceInfo currentProjSeq : this.projectedInfo) {
            for (FrequentSequenceItem globFreqItem : globallyFrequentItems) {
                Sequence fullSequence;
                String symbol;
                SequenceItem globalItem = globFreqItem.getItem();
                int index = globalItem.getIndex();
                if (index < currentProjSeq.getProjectedIndex() || !(symbol = (fullSequence = this.database.getSequences().get(currentProjSeq.getSequenceIndex())).getSequenceAsString().substring(index, index + 1)).equals(globalItem.getSymbol())) continue;
                Integer count = (Integer)frequentItemBag.get(globalItem);
                if (count == null) {
                    frequentItemBag.put(globalItem, fullSequence.getCount());
                    continue;
                }
                frequentItemBag.put(globalItem, count + fullSequence.getCount());
            }
        }
        TreeSet<FrequentSequenceItem> frequentItemSet = new TreeSet<FrequentSequenceItem>();
        for (Map.Entry itemAndCount : frequentItemBag.entrySet()) {
            int count = (Integer)itemAndCount.getValue();
            if (count < minSupport) continue;
            frequentItemSet.add(new FrequentSequenceItem(count, (SequenceItem)itemAndCount.getKey()));
        }
        return frequentItemSet;
    }

    public Set<FrequentSequenceItem> getForwardExtensionItems(Set<FrequentSequenceItem> locallyFrequentItems) {
        HashSet<FrequentSequenceItem> localExtensionItems = new HashSet<FrequentSequenceItem>();
        for (FrequentSequenceItem fItem : locallyFrequentItems) {
            if (fItem.getSupport() != this.support) continue;
            localExtensionItems.add(fItem);
        }
        return localExtensionItems;
    }

    public Set<FrequentSequenceItem> getBackwardExtensionItems() {
        HashSet<FrequentSequenceItem> backwardExtensionItems = new HashSet<FrequentSequenceItem>();
        if (this.projectedInfo.size() == 0) {
            return backwardExtensionItems;
        }
        HashMap positionsToSymbols = new HashMap();
        int dittedPosition = 0;
        List<Sequence> sequences = this.database.getSequences();
        Sequence firstSequence = sequences.get(this.projectedInfo.get(0).getSequenceIndex());
        for (SequenceItem currentItem : this.prefixSequence) {
            int fixedPosition = currentItem.getIndex();
            while (dittedPosition < fixedPosition) {
                Iterator symbol = firstSequence.getSequenceAsString().substring(dittedPosition, dittedPosition + 1);
                positionsToSymbols.put(dittedPosition, symbol);
                ++dittedPosition;
            }
            ++dittedPosition;
        }
        if (positionsToSymbols.isEmpty()) {
            return backwardExtensionItems;
        }
        int numSequences = this.projectedInfo.size();
        for (int i = 1; i < numSequences; ++i) {
            HashSet<Integer> positionsToRemove = new HashSet<Integer>();
            for (Map.Entry entry : positionsToSymbols.entrySet()) {
                Sequence testSequence;
                String testValue;
                Integer key = (Integer)entry.getKey();
                String storedValue = (String)entry.getValue();
                if (storedValue.equals(testValue = (testSequence = sequences.get(this.projectedInfo.get(i).getSequenceIndex())).getSequenceAsString().substring(key, key + 1))) continue;
                positionsToRemove.add(key);
            }
            for (Integer n : positionsToRemove) {
                positionsToSymbols.remove(n);
            }
            if (!positionsToSymbols.isEmpty()) continue;
            return backwardExtensionItems;
        }
        for (Map.Entry entry : positionsToSymbols.entrySet()) {
            int position = (Integer)entry.getKey();
            String string = (String)entry.getValue();
            SequenceItem item = new SequenceItem(string, position);
            FrequentSequenceItem fItem = new FrequentSequenceItem(this.support, item);
            backwardExtensionItems.add(fItem);
        }
        return backwardExtensionItems;
    }
}

