/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.renderers;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.function.BiFunction;
import org.jgrapht.Graph;
import org.jungrapht.visualization.PropertyLoader;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.renderers.AbstractEdgeRenderer;
import org.jungrapht.visualization.renderers.CenterEdgeArrowRenderingSupport;
import org.jungrapht.visualization.renderers.DefaultEdgeArrowRenderingSupport;
import org.jungrapht.visualization.renderers.EdgeArrowRenderingSupport;
import org.jungrapht.visualization.renderers.Renderer;
import org.jungrapht.visualization.selection.MutableSelectedState;
import org.jungrapht.visualization.transform.shape.GraphicsDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeavyweightEdgeRenderer<V, E>
extends AbstractEdgeRenderer<V, E>
implements Renderer.Edge<V, E> {
    private static Logger log = LoggerFactory.getLogger(HeavyweightEdgeRenderer.class);
    protected EdgeArrowRenderingSupport<V, E> edgeArrowRenderingSupport = this.getPreferredEdgeArrowRenderingSupport();
    protected float edgeArrowScaleThreshold = Float.parseFloat(System.getProperty("jungrapht.lightweightScaleThreshold", "0.3f"));

    private EdgeArrowRenderingSupport<V, E> getPreferredEdgeArrowRenderingSupport() {
        switch (System.getProperty("jungrapht.edgeArrowPlacement", "ENDPOINTS")) {
            case "CENTER": {
                return new CenterEdgeArrowRenderingSupport();
            }
        }
        return new DefaultEdgeArrowRenderingSupport();
    }

    @Override
    protected Shape getEdgeShape(BiFunction<Graph<V, E>, E, Shape> edgeShapeFunction, E edge, Graph<V, E> graph) {
        return edgeShapeFunction.apply(graph, edge);
    }

    @Override
    protected void drawSimpleEdge(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, E e) {
        Paint drawPaint;
        Paint fillPaint;
        Graphics2D g2d = renderContext.getGraphicsContext().getDelegate();
        Stroke savedStroke = g2d.getStroke();
        float widenessFactor = (float)(1.0 / g2d.getTransform().getScaleX());
        if (savedStroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)savedStroke;
            BasicStroke widerStroke = new BasicStroke(basicStroke.getLineWidth() * widenessFactor, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase());
            g2d.setStroke(widerStroke);
        } else {
            g2d.setStroke(new BasicStroke(renderContext.getEdgeWidth() * widenessFactor));
        }
        int[] coords = new int[4];
        boolean[] loop = new boolean[1];
        Shape edgeShape = this.prepareFinalEdgeShape(renderContext, layoutModel, e, coords, loop);
        int x1 = coords[0];
        int y1 = coords[1];
        int x2 = coords[2];
        int y2 = coords[3];
        boolean isLoop = loop[0];
        GraphicsDecorator g = renderContext.getGraphicsContext();
        Graph graph = layoutModel.getGraph();
        Paint oldPaint = g.getPaint();
        MutableSelectedState<E> edgeSelectedState = renderContext.getSelectedEdgeState();
        if (edgeSelectedState.isSelected(e)) {
            fillPaint = renderContext.getSelectedEdgeFillPaintFunction().apply(e);
            drawPaint = renderContext.getSelectedEdgeDrawPaintFunction().apply(e);
        } else {
            fillPaint = renderContext.getEdgeFillPaintFunction().apply(e);
            drawPaint = renderContext.getEdgeDrawPaintFunction().apply(e);
        }
        if (fillPaint != null) {
            g.setPaint(fillPaint);
            g.fill(edgeShape);
        }
        if (drawPaint != null) {
            g.setPaint(drawPaint);
            g.draw(edgeShape);
        }
        float scalex = (float)g.getTransform().getScaleX();
        float scaley = (float)g.getTransform().getScaleY();
        if (scalex < this.edgeArrowScaleThreshold || scaley < this.edgeArrowScaleThreshold) {
            return;
        }
        if (renderContext.renderEdgeArrow()) {
            Stroke new_stroke = renderContext.getEdgeArrowStrokeFunction().apply(e);
            Stroke old_stroke = g.getStroke();
            if (new_stroke != null) {
                g.setStroke(new_stroke);
            }
            Shape destVertexShape = renderContext.getVertexShapeFunction().apply(graph.getEdgeTarget(e));
            AffineTransform xf = AffineTransform.getTranslateInstance(x2, y2);
            destVertexShape = xf.createTransformedShape(destVertexShape);
            AffineTransform at = this.edgeArrowRenderingSupport.getArrowTransform(renderContext, edgeShape, destVertexShape);
            if (at == null) {
                return;
            }
            Shape arrow = renderContext.getEdgeArrow();
            arrow = at.createTransformedShape(arrow);
            g.setPaint(renderContext.getArrowFillPaintFunction().apply(e));
            g.fill(arrow);
            g.setPaint(renderContext.getArrowDrawPaintFunction().apply(e));
            g.draw(arrow);
            if (!graph.getType().isDirected()) {
                Shape vertexShape = renderContext.getVertexShapeFunction().apply(graph.getEdgeSource(e));
                xf = AffineTransform.getTranslateInstance(x1, y1);
                vertexShape = xf.createTransformedShape(vertexShape);
                at = this.edgeArrowRenderingSupport.getReverseArrowTransform(renderContext, edgeShape, vertexShape, !isLoop);
                if (at == null) {
                    return;
                }
                arrow = renderContext.getEdgeArrow();
                arrow = at.createTransformedShape(arrow);
                g.setPaint(renderContext.getArrowFillPaintFunction().apply(e));
                g.fill(arrow);
                g.setPaint(renderContext.getArrowDrawPaintFunction().apply(e));
                g.draw(arrow);
            }
            if (new_stroke != null) {
                g.setStroke(old_stroke);
            }
        }
        g.setPaint(oldPaint);
        g2d.setStroke(savedStroke);
    }

    @Override
    public EdgeArrowRenderingSupport<V, E> getEdgeArrowRenderingSupport() {
        return this.edgeArrowRenderingSupport;
    }

    @Override
    public void setEdgeArrowRenderingSupport(EdgeArrowRenderingSupport<V, E> edgeArrowRenderingSupport) {
        this.edgeArrowRenderingSupport = edgeArrowRenderingSupport;
    }

    static {
        PropertyLoader.load();
    }
}

