/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.transform;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.event.ChangeListener;
import org.jungrapht.visualization.transform.AffineTransformer;
import org.jungrapht.visualization.transform.MutableTransformer;
import org.jungrapht.visualization.transform.shape.ShapeTransformer;
import org.jungrapht.visualization.util.ChangeEventSupport;
import org.jungrapht.visualization.util.DefaultChangeEventSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableAffineTransformer
extends AffineTransformer
implements MutableTransformer,
ShapeTransformer,
ChangeEventSupport {
    private static Logger log = LoggerFactory.getLogger(MutableAffineTransformer.class);
    protected ChangeEventSupport changeSupport = new DefaultChangeEventSupport(this);

    public MutableAffineTransformer() {
    }

    public MutableAffineTransformer(AffineTransform transform) {
        super(transform);
    }

    @Override
    public void scale(double scalex, double scaley, Point2D from) {
        AffineTransform xf = AffineTransform.getTranslateInstance(from.getX(), from.getY());
        xf.scale(scalex, scaley);
        xf.translate(-from.getX(), -from.getY());
        this.inverse = null;
        this.transform.preConcatenate(xf);
        this.fireStateChanged();
    }

    @Override
    public void setScale(double scalex, double scaley, Point2D from) {
        this.transform.setToIdentity();
        this.scale(scalex, scaley, from);
    }

    @Override
    public void shear(double shx, double shy, Point2D from) {
        this.inverse = null;
        AffineTransform at = AffineTransform.getTranslateInstance(from.getX(), from.getY());
        at.shear(shx, shy);
        at.translate(-from.getX(), -from.getY());
        this.transform.preConcatenate(at);
        this.fireStateChanged();
    }

    @Override
    public void setTranslate(double tx, double ty) {
        float scalex = (float)this.transform.getScaleX();
        float scaley = (float)this.transform.getScaleY();
        float shearx = (float)this.transform.getShearX();
        float sheary = (float)this.transform.getShearY();
        this.inverse = null;
        this.transform.setTransform(scalex, sheary, shearx, scaley, tx, ty);
        this.fireStateChanged();
    }

    @Override
    public void translate(double offsetx, double offsety) {
        this.inverse = null;
        this.transform.translate(offsetx, offsety);
        this.fireStateChanged();
    }

    @Override
    public void rotate(double theta, Point2D from) {
        AffineTransform rotate = AffineTransform.getRotateInstance(theta, from.getX(), from.getY());
        this.inverse = null;
        this.transform.preConcatenate(rotate);
        this.fireStateChanged();
    }

    @Override
    public void rotate(double radians, double x, double y) {
        this.inverse = null;
        this.transform.rotate(radians, x, y);
        this.fireStateChanged();
    }

    @Override
    public void concatenate(AffineTransform xform) {
        this.inverse = null;
        this.transform.concatenate(xform);
        this.fireStateChanged();
    }

    @Override
    public void preConcatenate(AffineTransform xform) {
        this.inverse = null;
        this.transform.preConcatenate(xform);
        this.fireStateChanged();
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public ChangeListener[] getChangeListeners() {
        return this.changeSupport.getChangeListeners();
    }

    @Override
    public void fireStateChanged() {
        this.changeSupport.fireStateChanged();
    }

    @Override
    public void setToIdentity() {
        this.inverse = null;
        this.transform.setToIdentity();
        this.fireStateChanged();
    }
}

