/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.util;

import java.util.HashMap;
import java.util.Map;
import org.jgrapht.Graph;
import org.jungrapht.visualization.util.EdgeIndexFunction;

public class ParallelEdgeIndexFunction<V, E>
implements EdgeIndexFunction<V, E> {
    protected Map<E, Integer> edgeIndex = new HashMap<E, Integer>();

    @Override
    public Integer apply(Graph<V, E> graph, E edge) {
        Integer index = this.edgeIndex.get(edge);
        if (index == null) {
            Object u = graph.getEdgeSource(edge);
            Object v = graph.getEdgeTarget(edge);
            int count = 0;
            for (Object connectingEdge : graph.getAllEdges(u, v)) {
                this.edgeIndex.put(connectingEdge, count++);
            }
            return this.edgeIndex.getOrDefault(edge, 0);
        }
        return index;
    }

    @Override
    public void reset(Graph<V, E> graph, E edge) {
        this.edgeIndex.remove(edge);
    }

    @Override
    public void reset() {
        this.edgeIndex.clear();
    }
}

