/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.RefExpr;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.ts.Cfg;
import com.googlecode.dex2jar.ir.ts.Transformer;
import com.googlecode.dex2jar.ir.ts.an.SimpleLiveAnalyze;
import com.googlecode.dex2jar.ir.ts.an.SimpleLiveValue;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Ir2JRegAssignTransformer
implements Transformer {
    private static final Comparator<Reg> ORDER_REG_ASSIGN_BY_PREFERRED_SIZE_DESC = (o1, o2) -> {
        int x = o2.prefers.size() - o1.prefers.size();
        if (x == 0) {
            x = o2.excludes.size() - o1.excludes.size();
        }
        return x;
    };

    private Reg[] genGraph(IrMethod method, Reg[] regs) {
        Reg[] args = method.isStatic ? new Reg[method.args.length] : new Reg[method.args.length + 1];
        HashSet<Stmt> tos = new HashSet<Stmt>();
        for (Stmt stmt : method.stmts) {
            if (stmt.st != Stmt.ST.ASSIGN && stmt.st != Stmt.ST.IDENTITY || stmt.getOp1().vt != Value.VT.LOCAL) continue;
            Local left = (Local)stmt.getOp1();
            Value op2 = stmt.getOp2();
            int idx = left.lsIndex;
            Reg leftReg = regs[idx];
            Cfg.collectTos(stmt, tos);
            for (Stmt next : tos) {
                SimpleLiveValue[] frame = (SimpleLiveValue[])next.frame;
                if (frame == null) continue;
                for (int i = 0; i < frame.length; ++i) {
                    SimpleLiveValue v;
                    if (i == idx || (v = frame[i]) == null || !v.used) continue;
                    Reg rightReg = regs[i];
                    leftReg.excludes.add(rightReg);
                    rightReg.excludes.add(leftReg);
                }
            }
            tos.clear();
            if (op2.vt == Value.VT.LOCAL) {
                Reg rightReg = regs[((Local)op2).lsIndex];
                leftReg.prefers.add(rightReg);
                rightReg.prefers.add(leftReg);
            }
            if (op2.vt == Value.VT.THIS_REF) {
                args[0] = leftReg;
                continue;
            }
            if (op2.vt != Value.VT.PARAMETER_REF) continue;
            RefExpr refExpr = (RefExpr)op2;
            if (method.isStatic) {
                args[refExpr.parameterIndex] = leftReg;
                continue;
            }
            args[refExpr.parameterIndex + 1] = leftReg;
        }
        for (Reg reg : regs) {
            reg.excludes.remove(reg);
            reg.prefers.remove(reg);
        }
        return args;
    }

    Map<Character, List<Reg>> groupAndCleanUpByType(Reg[] regs) {
        HashMap<Character, List<Reg>> groups = new HashMap<Character, List<Reg>>();
        for (Reg reg : regs) {
            char simpleType = reg.type;
            List group = groups.computeIfAbsent(Character.valueOf(simpleType), k -> new ArrayList());
            group.add(reg);
            reg.excludes.removeIf(ex -> ex.type != reg.type);
            reg.prefers.removeIf(ex -> ex.type != reg.type);
        }
        return groups;
    }

    private void initExcludeColor(BitSet excludeColor, Reg as) {
        excludeColor.clear();
        for (Reg ex : as.excludes) {
            if (ex.reg < 0) continue;
            excludeColor.set(ex.reg);
            if (ex.type != 'J' && ex.type != 'D') continue;
            excludeColor.set(ex.reg + 1);
        }
    }

    private void initSuggestColor(BitSet suggestColor, Reg as) {
        suggestColor.clear();
        for (Reg ex : as.prefers) {
            if (ex.reg < 0) continue;
            suggestColor.set(ex.reg);
        }
    }

    @Override
    public void transform(IrMethod method) {
        if (method.locals.isEmpty()) {
            return;
        }
        SimpleLiveAnalyze sa = new SimpleLiveAnalyze(method, true);
        sa.analyze();
        int maxLocalSize = sa.getLocalSize();
        Reg[] regs = new Reg[maxLocalSize];
        for (Local local : method.locals) {
            Reg[] reg = new Reg();
            int type = local.valueType.charAt(0);
            if (type == 91) {
                type = 76;
            }
            reg.type = (char)type;
            local.tag = reg;
            regs[local.lsIndex] = reg;
        }
        Reg[] args = this.genGraph(method, regs);
        if (!method.isStatic) {
            Reg atThis = args[0];
            for (Reg reg : regs) {
                if (reg == atThis) continue;
                reg.excludes.add(atThis);
                atThis.excludes.add(reg);
            }
        }
        int i = 0;
        int index = 0;
        if (!method.isStatic) {
            args[i++].reg = index++;
        }
        for (int j = 0; j < method.args.length; ++j) {
            Reg reg = args[i++];
            String type = method.args[j];
            if (reg == null) {
                ++index;
            } else {
                reg.reg = index++;
            }
            if (!"J".equals(type) && !"D".equals(type)) continue;
            ++index;
        }
        Map<Character, List<Reg>> groups = this.groupAndCleanUpByType(regs);
        BitSet excludeColor = new BitSet();
        BitSet suggestColor = new BitSet();
        BitSet globalExcludes = new BitSet();
        BitSet usedInOneType = new BitSet();
        for (Map.Entry<Character, List<Reg>> e : groups.entrySet()) {
            List<Reg> assigns = e.getValue();
            assigns.sort(ORDER_REG_ASSIGN_BY_PREFERRED_SIZE_DESC);
            char type = e.getKey().charValue();
            boolean doubleOrLong = type == 'J' || type == 'D';
            for (Reg as : assigns) {
                if (as.reg < 0) {
                    this.initExcludeColor(excludeColor, as);
                    this.excludeParameters(excludeColor, args, type);
                    excludeColor.or(globalExcludes);
                    this.initSuggestColor(suggestColor, as);
                    int i2 = suggestColor.nextSetBit(0);
                    while (i2 >= 0) {
                        if (doubleOrLong) {
                            if (!excludeColor.get(i2) && !excludeColor.get(i2 + 1)) {
                                as.reg = i2;
                                break;
                            }
                        } else if (!excludeColor.get(i2)) {
                            as.reg = i2;
                            break;
                        }
                        i2 = suggestColor.nextSetBit(i2 + 1);
                    }
                    if (as.reg < 0) {
                        if (doubleOrLong) {
                            int reg = -1;
                            do {
                                ++reg;
                            } while (excludeColor.get((reg = excludeColor.nextClearBit(reg)) + 1));
                            as.reg = reg;
                        } else {
                            as.reg = excludeColor.nextClearBit(0);
                        }
                    }
                }
                usedInOneType.set(as.reg);
                if (!doubleOrLong) continue;
                usedInOneType.set(as.reg + 1);
            }
            globalExcludes.or(usedInOneType);
            usedInOneType.clear();
        }
        for (Local local : method.locals) {
            Reg as = (Reg)local.tag;
            local.lsIndex = as.reg;
            local.tag = null;
        }
        for (Stmt stmt : method.stmts) {
            stmt.frame = null;
        }
    }

    private void excludeParameters(BitSet excludeColor, Reg[] args, char type) {
        for (Reg arg : args) {
            if (arg.type == type) continue;
            excludeColor.set(arg.reg);
            if (arg.type != 'J' && arg.type != 'D') continue;
            excludeColor.set(arg.reg + 1);
        }
    }

    public static class Reg {
        public Set<Reg> excludes = new HashSet<Reg>(4);
        public Set<Reg> prefers = new HashSet<Reg>(3);
        int reg = -1;
        public char type;
    }
}

