/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.KeyEntryListener;
import docking.KeyEntryTextField;
import docking.widgets.EmptyBorderButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import resources.Icons;

public class KeyEntryPanel
extends JPanel {
    private KeyEntryTextField keyEntryField;
    private JButton clearButton;

    public KeyEntryPanel(int columns, KeyEntryListener listener) {
        this.setLayout(new BoxLayout(this, 2));
        this.keyEntryField = new KeyEntryTextField(columns, listener);
        this.clearButton = new EmptyBorderButton(Icons.DELETE_ICON);
        this.clearButton.setName("Clear Key Binding");
        this.clearButton.addActionListener(e -> this.keyEntryField.clearKeyStroke());
        this.add(this.keyEntryField);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.clearButton);
    }

    @Override
    public void requestFocus() {
        this.keyEntryField.requestFocus();
    }

    public JTextField getTextField() {
        return this.keyEntryField;
    }

    public void setKeyStroke(KeyStroke ks) {
        this.keyEntryField.setKeyStroke(ks);
    }

    public KeyStroke getKeyStroke() {
        return this.keyEntryField.getKeyStroke();
    }

    public void setDisabledHint(String disabledHint) {
        this.keyEntryField.setDisabledHint(disabledHint);
    }

    public void clearField() {
        this.keyEntryField.clearField();
    }
}

