/*
 * Decompiled with CFR 0.152.
 */
package docking.menu;

import docking.DockingUtils;
import docking.DockingWindowManager;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import docking.menu.ToolBarItemManager;
import docking.widgets.VariableHeightPanel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;

public class ToolBarManager {
    private Map<String, List<ToolBarItemManager>> groupToItemsMap = new TreeMap<String, List<ToolBarItemManager>>(new GroupComparator(this));
    private Comparator<? super ToolBarItemManager> toolBarItemComparator = new ToolBarItemManagerComparator(this);
    private volatile JComponent toolBar;
    private final DockingWindowManager windowManager;

    public ToolBarManager(DockingWindowManager windowManager) {
        this.windowManager = windowManager;
    }

    public void clearActions() {
        this.groupToItemsMap.clear();
        this.toolBar = null;
    }

    public void addAction(DockingActionIf action) {
        ToolBarData toolBarData = action.getToolBarData();
        if (toolBarData == null) {
            return;
        }
        this.toolBar = null;
        String group = toolBarData.getToolBarGroup();
        List<ToolBarItemManager> items = this.groupToItemsMap.get(group);
        if (items == null) {
            items = new ArrayList<ToolBarItemManager>();
            this.groupToItemsMap.put(group, items);
        }
        items.add(new ToolBarItemManager(action, this.windowManager));
        Collections.sort(items, this.toolBarItemComparator);
    }

    public DockingActionIf getAction(String actionName) {
        Collection<List<ToolBarItemManager>> values = this.groupToItemsMap.values();
        for (List<ToolBarItemManager> list : values) {
            for (ToolBarItemManager manager : list) {
                DockingActionIf action = manager.getAction();
                if (!actionName.equals(action.getName())) continue;
                return action;
            }
        }
        return null;
    }

    public void dispose() {
        Set<Map.Entry<String, List<ToolBarItemManager>>> entrySet = this.groupToItemsMap.entrySet();
        for (Map.Entry<String, List<ToolBarItemManager>> entry : entrySet) {
            List<ToolBarItemManager> items = entry.getValue();
            for (ToolBarItemManager item : items) {
                item.dispose();
            }
        }
        this.groupToItemsMap.clear();
    }

    public boolean isEmpty() {
        return this.groupToItemsMap.isEmpty();
    }

    public JComponent getToolBar() {
        JComponent localToolBar = this.toolBar;
        if (localToolBar == null) {
            this.toolBar = localToolBar = this.buildToolbar();
        }
        return localToolBar;
    }

    private JComponent buildToolbar() {
        VariableHeightPanel newToolBar = new VariableHeightPanel(true, 0, 0);
        newToolBar.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        boolean isFirstGroup = true;
        Set<Map.Entry<String, List<ToolBarItemManager>>> entrySet = this.groupToItemsMap.entrySet();
        for (Map.Entry<String, List<ToolBarItemManager>> entry : entrySet) {
            List<ToolBarItemManager> items = entry.getValue();
            if (items.isEmpty()) continue;
            if (!isFirstGroup) {
                this.insertSeparator(newToolBar);
            }
            this.addButtonsToToolBar(newToolBar, items);
            isFirstGroup = false;
        }
        return newToolBar;
    }

    private void addButtonsToToolBar(JComponent toolBarComponent, List<ToolBarItemManager> items) {
        for (ToolBarItemManager item : items) {
            JButton button = item.getButton();
            toolBarComponent.add(button);
        }
    }

    private void insertSeparator(JComponent toolBarComponent) {
        toolBarComponent.add(Box.createHorizontalStrut(5));
        toolBarComponent.add(DockingUtils.createToolbarSeparator());
        toolBarComponent.add(Box.createHorizontalStrut(5));
    }

    public void removeAction(DockingActionIf action) {
        ToolBarData toolBarData = action.getToolBarData();
        if (toolBarData == null) {
            return;
        }
        String group = toolBarData.getToolBarGroup();
        List<ToolBarItemManager> groupItems = this.groupToItemsMap.get(group);
        if (groupItems == null) {
            return;
        }
        Iterator<ToolBarItemManager> it = groupItems.iterator();
        while (it.hasNext()) {
            ToolBarItemManager item = it.next();
            if (item.getAction() != action) continue;
            item.dispose();
            it.remove();
            this.toolBar = null;
        }
        if (groupItems.isEmpty()) {
            this.groupToItemsMap.remove(group);
        }
    }

    private class GroupComparator
    implements Comparator<String> {
        private GroupComparator(ToolBarManager toolBarManager) {
        }

        @Override
        public int compare(String group1, String group2) {
            if (group1 == null && group2 == null) {
                return 0;
            }
            if (group1 == null) {
                return 1;
            }
            if (group2 == null) {
                return -1;
            }
            return group1.compareTo(group2);
        }
    }

    private class ToolBarItemManagerComparator
    implements Comparator<ToolBarItemManager> {
        private ToolBarItemManagerComparator(ToolBarManager toolBarManager) {
        }

        @Override
        public int compare(ToolBarItemManager t1, ToolBarItemManager t2) {
            String subGroup2;
            DockingActionIf action1 = t1.getAction();
            DockingActionIf action2 = t2.getAction();
            ToolBarData toolBarData1 = action1.getToolBarData();
            ToolBarData toolBarData2 = action2.getToolBarData();
            String subGroup1 = toolBarData1.getToolBarSubGroup();
            int result = subGroup1.compareTo(subGroup2 = toolBarData2.getToolBarSubGroup());
            if (result != 0) {
                return result;
            }
            String name1 = action1.getOwner();
            String name2 = action2.getOwner();
            return name1.compareTo(name2);
        }
    }
}

