/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.options.editor.SwatchPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.util.List;
import java.util.Objects;
import javax.swing.UIManager;

class RecentSwatchPanel
extends SwatchPanel {
    private List<Color> recentColors;

    RecentSwatchPanel() {
        this.initColors();
    }

    List<Color> getRecentColors() {
        return List.of(this.colors);
    }

    @Override
    protected void initValues() {
        this.swatchSize = UIManager.getDimension("ColorChooser.swatchesRecentSwatchSize");
        this.numSwatches = new Dimension(5, 7);
        this.gap = new Dimension(1, 1);
    }

    @Override
    protected void initColors() {
        Color defaultRecentColor = UIManager.getColor("ColorChooser.swatchesDefaultRecentColor");
        int numColors = this.numSwatches.width * this.numSwatches.height;
        this.colors = new Color[numColors];
        for (int i = 0; i < numColors; ++i) {
            this.colors[i] = defaultRecentColor;
        }
        if (this.recentColors != null && this.recentColors.size() > 0) {
            int recentColorCount = this.recentColors.size();
            for (int i = 0; i < recentColorCount; ++i) {
                this.colors[i] = this.recentColors.get(i);
            }
        }
    }

    void setMostRecentColor(Color c) {
        Color lastColor = this.colors[0];
        if (Objects.equals(lastColor, c)) {
            return;
        }
        System.arraycopy(this.colors, 0, this.colors, 1, this.colors.length - 1);
        this.colors[0] = c;
        this.repaint();
    }

    void setRecentColors(List<Color> recentColors) {
        this.recentColors = recentColors;
        this.initColors();
    }
}

