/*
 * Decompiled with CFR 0.152.
 */
package docking.theme.gui;

import docking.theme.gui.GThemeValuesCache;
import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import generic.theme.ColorValue;
import generic.theme.GThemeDefaults;
import generic.theme.GThemeValueMap;
import generic.theme.Gui;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import ghidra.util.ColorUtils;
import ghidra.util.WebColors;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JLabel;

public class ThemeColorTableModel
extends GDynamicColumnTableModel<ColorValue, Object> {
    protected List<ColorValue> colors;
    private GThemeValueMap currentValues;
    private GThemeValueMap themeValues;
    private GThemeValueMap defaultValues;
    private GThemeValueMap lightDefaultValues;
    private GThemeValueMap darkDefaultValues;
    private GThemeValuesCache valuesCache;
    private boolean showSystemValues;

    public ThemeColorTableModel(GThemeValuesCache valuesProvider) {
        super((ServiceProvider)new ServiceProviderStub());
        this.valuesCache = valuesProvider;
        this.load();
    }

    public void setShowSystemValues(boolean show) {
        this.showSystemValues = show;
    }

    public boolean isShowingSystemValues() {
        return this.showSystemValues;
    }

    public void reloadCurrent() {
        this.currentValues = this.valuesCache.getCurrentValues();
        this.colors = this.currentValues.getColors();
        this.filter();
        this.fireTableDataChanged();
    }

    public void reloadAll() {
        this.load();
        this.fireTableDataChanged();
    }

    ColorValue getThemeValue(String id) {
        return this.themeValues.getColor(id);
    }

    private void load() {
        this.currentValues = this.valuesCache.getCurrentValues();
        this.colors = this.currentValues.getColors();
        this.themeValues = this.valuesCache.getThemeValues();
        this.defaultValues = this.valuesCache.getDefaultValues();
        this.lightDefaultValues = this.valuesCache.getLightValues();
        this.darkDefaultValues = this.valuesCache.getDarkValues();
        this.filter();
    }

    protected void filter() {
        ArrayList<ColorValue> filtered = new ArrayList<ColorValue>();
        for (ColorValue colorValue : this.colors) {
            String id = colorValue.getId();
            if (this.showSystemValues) {
                filtered.add(colorValue);
                continue;
            }
            if (Gui.isSystemId((String)id)) continue;
            filtered.add(colorValue);
        }
        this.colors = filtered;
    }

    @Override
    public String getName() {
        return "Colors";
    }

    @Override
    public List<ColorValue> getModelData() {
        return this.colors;
    }

    @Override
    protected TableColumnDescriptor<ColorValue> createTableColumnDescriptor() {
        TableColumnDescriptor<ColorValue> descriptor = new TableColumnDescriptor<ColorValue>();
        descriptor.addVisibleColumn(new IdColumn(this));
        descriptor.addVisibleColumn(new ValueColumn(this, "Current Color", () -> this.currentValues));
        descriptor.addVisibleColumn(new ValueColumn(this, "Theme Color", () -> this.themeValues));
        descriptor.addVisibleColumn(new ValueColumn(this, "Default Color", () -> this.defaultValues));
        descriptor.addHiddenColumn(new ValueColumn(this, "Light Defaults", () -> this.lightDefaultValues));
        descriptor.addHiddenColumn(new ValueColumn(this, "Dark Defaults", () -> this.darkDefaultValues));
        return descriptor;
    }

    @Override
    public Object getDataSource() {
        return null;
    }

    private class IdColumn
    extends AbstractDynamicTableColumn<ColorValue, String, Object> {
        private IdColumn(ThemeColorTableModel themeColorTableModel) {
        }

        @Override
        public String getColumnName() {
            return "Id";
        }

        @Override
        public String getValue(ColorValue themeColor, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
            return themeColor.getId();
        }

        @Override
        public int getColumnPreferredWidth() {
            return 300;
        }
    }

    private class ValueColumn
    extends AbstractDynamicTableColumn<ColorValue, ResolvedColor, Object> {
        private ThemeColorRenderer renderer;
        private String name;
        private Supplier<GThemeValueMap> valueSupplier;

        ValueColumn(ThemeColorTableModel themeColorTableModel, String name, Supplier<GThemeValueMap> supplier) {
            this.name = name;
            this.valueSupplier = supplier;
            this.renderer = themeColorTableModel.new ThemeColorRenderer();
        }

        @Override
        public String getColumnName() {
            return this.name;
        }

        @Override
        public ResolvedColor getValue(ColorValue themeColor, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
            Color color;
            String id;
            GThemeValueMap valueMap = this.valueSupplier.get();
            ColorValue colorValue = valueMap.getColor(id = themeColor.getId());
            if (colorValue == null) {
                return null;
            }
            Color color2 = color = colorValue.hasResolvableValue(valueMap) ? (Color)colorValue.get(valueMap) : null;
            if (color == null) {
                return null;
            }
            return new ResolvedColor(id, colorValue.getReferenceId(), color);
        }

        @Override
        public GColumnRenderer<ResolvedColor> getColumnRenderer() {
            return this.renderer;
        }

        @Override
        public Comparator<ResolvedColor> getComparator() {
            return (v1, v2) -> {
                if (v1 == null && v2 == null) {
                    return 0;
                }
                if (v1 == null) {
                    return 1;
                }
                if (v2 == null) {
                    return -1;
                }
                return ColorUtils.COMPARATOR.compare(v1.color, v2.color);
            };
        }

        @Override
        public int getColumnPreferredWidth() {
            return 300;
        }
    }

    private record ResolvedColor(String id, String refId, Color color) {
    }

    private static class SwatchIcon
    implements Icon {
        private Color color;
        private Color border;

        SwatchIcon(Color c, Color border) {
            this.color = c;
            this.border = border;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this.color);
            g.fillRect(x, y, 25, 16);
            g.setColor(this.border);
            g.drawRect(x, y, 25, 16);
        }

        @Override
        public int getIconWidth() {
            return 25;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }
    }

    private class ThemeColorRenderer
    extends AbstractGColumnRenderer<ResolvedColor> {
        private ThemeColorRenderer() {
        }

        @Override
        protected Font getDefaultFont() {
            return this.fixedWidthFont;
        }

        @Override
        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(data);
            ResolvedColor resolved = (ResolvedColor)data.getValue();
            String text = this.getValueText(resolved);
            Object color = resolved == null ? GThemeDefaults.Colors.BACKGROUND : resolved.color();
            String webName = WebColors.toWebColorName((Color)color);
            String hex = WebColors.toString((Color)color, (boolean)false);
            String toolTipText = (webName == null ? "" : webName.toLowerCase()) + " " + hex;
            label.setToolTipText(toolTipText);
            label.setText(text);
            label.setIcon(new SwatchIcon((Color)color, label.getForeground()));
            label.setOpaque(true);
            return label;
        }

        private String getValueText(ResolvedColor resolvedColor) {
            if (resolvedColor == null) {
                return "<No Value>";
            }
            Color color = resolvedColor.color();
            String name = WebColors.toWebColorName((Color)color);
            if (resolvedColor.refId() != null) {
                return "[" + resolvedColor.refId() + "] ";
            }
            Object text = WebColors.toString((Color)color, (boolean)false);
            if (name != null) {
                text = (String)text + " (" + name + ")";
            }
            return text;
        }

        @Override
        public String getFilterString(ResolvedColor colorValue, Settings settings) {
            return this.getValueText(colorValue);
        }
    }
}

