/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.widgets.CursorPosition;
import docking.widgets.FindDialogSearcher;
import docking.widgets.SearchLocation;
import generic.theme.GColor;
import ghidra.util.Msg;
import ghidra.util.UserSearchUtils;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;

public class TextComponentSearcher
implements FindDialogSearcher {
    private Color highlightColor = new GColor("color.bg.find.highlight");
    private Color activeHighlightColor = new GColor("color.bg.find.highlight.active");
    private JEditorPane editorPane;
    private DocumentListener documentListener = new DocumentChangeListener();
    private CaretListener caretListener = new CaretChangeListener();
    private SwingUpdateManager caretUpdater = new SwingUpdateManager(() -> this.updateActiveHighlight());
    private volatile boolean isUpdatingCaretInternally;
    private SearchResults searchResults;

    public TextComponentSearcher(JEditorPane editorPane) {
        this.editorPane = editorPane;
        if (editorPane == null) {
            return;
        }
        Document document = editorPane.getDocument();
        document.addDocumentListener(this.documentListener);
        editorPane.addCaretListener(this.caretListener);
    }

    public void setEditorPane(JEditorPane editorPane) {
        if (this.editorPane != editorPane) {
            Document document = editorPane.getDocument();
            document.removeDocumentListener(this.documentListener);
            this.markResultsStale();
        }
        this.editorPane = editorPane;
    }

    public JEditorPane getEditorPane() {
        return this.editorPane;
    }

    @Override
    public void dispose() {
        this.caretUpdater.dispose();
        if (this.editorPane != null) {
            Document document = this.editorPane.getDocument();
            document.removeDocumentListener(this.documentListener);
            this.clearHighlights();
        }
    }

    @Override
    public void clearHighlights() {
        if (this.searchResults != null) {
            this.searchResults.removeHighlights();
            this.searchResults = null;
        }
    }

    public boolean hasSearchResults() {
        return this.searchResults != null && !this.searchResults.isEmpty();
    }

    public boolean isStale() {
        return this.searchResults != null && this.searchResults.isStale();
    }

    private void markResultsStale() {
        if (this.searchResults != null) {
            this.searchResults.setStale();
        }
    }

    private void updateActiveHighlight() {
        if (this.searchResults == null) {
            return;
        }
        int pos = this.editorPane.getCaretPosition();
        this.searchResults.updateActiveMatch(pos);
    }

    private void setCaretPositionInternally(int pos) {
        this.isUpdatingCaretInternally = true;
        try {
            this.editorPane.setCaretPosition(pos);
        }
        finally {
            this.isUpdatingCaretInternally = false;
        }
    }

    @Override
    public CursorPosition getCursorPosition() {
        int pos = this.editorPane.getCaretPosition();
        return new CursorPosition(pos);
    }

    @Override
    public void setCursorPosition(CursorPosition position) {
        int pos = position.getPosition();
        this.editorPane.setCaretPosition(pos);
    }

    @Override
    public CursorPosition getStart() {
        return new CursorPosition(0);
    }

    @Override
    public CursorPosition getEnd() {
        int length = this.editorPane.getDocument().getLength();
        return new CursorPosition(length - 1);
    }

    @Override
    public void highlightSearchResults(SearchLocation location) {
        if (location == null) {
            this.clearHighlights();
            return;
        }
        TextComponentSearchLocation textLocation = (TextComponentSearchLocation)location;
        FindMatch match = textLocation.getMatch();
        this.searchResults.setActiveMatch(match);
    }

    @Override
    public SearchLocation search(String text, CursorPosition cursorPosition, boolean searchForward, boolean useRegex) {
        this.updateSearchResults(text, useRegex);
        int pos = cursorPosition.getPosition();
        int searchStart = this.getSearchStart(pos, searchForward);
        FindMatch match = this.searchResults.getNextMatch(searchStart, searchForward);
        if (match == null) {
            return null;
        }
        return new TextComponentSearchLocation(this, match.getStart(), match.getEnd(), text, searchForward, match);
    }

    private void updateSearchResults(String text, boolean useRegex) {
        if (this.searchResults != null) {
            if (!this.searchResults.isInvalid(text)) {
                return;
            }
            this.searchResults.removeHighlights();
        }
        SearchTask searchTask = new SearchTask(text, useRegex);
        TaskLauncher.launch(searchTask);
        this.searchResults = searchTask.getSearchResults();
        this.searchResults.applyHighlights();
    }

    private int getSearchStart(int startPosition, boolean isForward) {
        FindMatch activeMatch = this.searchResults.getActiveMatch();
        if (activeMatch == null) {
            return startPosition;
        }
        int lastMatchStart = activeMatch.getStart();
        if (startPosition != lastMatchStart) {
            return startPosition;
        }
        if (isForward) {
            return startPosition + 1;
        }
        if (startPosition == 0) {
            return this.editorPane.getText().length();
        }
        return startPosition - 1;
    }

    private class DocumentChangeListener
    implements DocumentListener {
        private DocumentChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            TextComponentSearcher.this.markResultsStale();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TextComponentSearcher.this.markResultsStale();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    private class CaretChangeListener
    implements CaretListener {
        private int lastPos = -1;

        private CaretChangeListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            int pos = e.getDot();
            if (TextComponentSearcher.this.isUpdatingCaretInternally) {
                this.lastPos = pos;
                return;
            }
            if (pos == this.lastPos) {
                return;
            }
            this.lastPos = pos;
            TextComponentSearcher.this.caretUpdater.update();
        }
    }

    private class SearchResults {
        private TreeMap<Integer, FindMatch> matchesByPosition;
        private FindMatch activeMatch;
        private boolean isStale;
        private String searchText;

        SearchResults(String searchText, TreeMap<Integer, FindMatch> matchesByPosition) {
            this.searchText = searchText;
            this.matchesByPosition = matchesByPosition;
        }

        boolean isStale() {
            return this.isStale;
        }

        void updateActiveMatch(int pos) {
            if (this.activeMatch != null) {
                this.activeMatch.setActive(false);
                this.activeMatch = null;
            }
            if (this.isStale) {
                return;
            }
            for (FindMatch match : this.matchesByPosition.values()) {
                boolean isActive = false;
                if (match.contains(pos)) {
                    this.activeMatch = match;
                    isActive = true;
                }
                match.setActive(isActive);
            }
        }

        FindMatch getActiveMatch() {
            return this.activeMatch;
        }

        FindMatch getNextMatch(int searchStart, boolean searchForward) {
            Map.Entry<Integer, FindMatch> entry = searchForward ? this.matchesByPosition.ceilingEntry(searchStart) : this.matchesByPosition.floorEntry(searchStart);
            if (entry == null) {
                return null;
            }
            return entry.getValue();
        }

        boolean isEmpty() {
            return this.matchesByPosition.isEmpty();
        }

        void setStale() {
            this.isStale = true;
        }

        boolean isInvalid(String otherSearchText) {
            if (this.isStale) {
                return true;
            }
            return !this.searchText.equals(otherSearchText);
        }

        void setActiveMatch(FindMatch match) {
            if (this.activeMatch != null) {
                this.activeMatch.setActive(false);
            }
            this.activeMatch = match;
            this.activeMatch.activate();
        }

        void applyHighlights() {
            Collection<FindMatch> matches = this.matchesByPosition.values();
            for (FindMatch match : matches) {
                match.applyHighlight();
            }
        }

        void removeHighlights() {
            this.activeMatch = null;
            JEditorPane editor = TextComponentSearcher.this.editorPane;
            Highlighter highlighter = editor.getHighlighter();
            if (highlighter != null) {
                highlighter.removeAllHighlights();
            }
            this.matchesByPosition.clear();
        }
    }

    private class TextComponentSearchLocation
    extends SearchLocation {
        private FindMatch match;

        public TextComponentSearchLocation(TextComponentSearcher textComponentSearcher, int start, int end, String searchText, boolean forwardDirection, FindMatch match) {
            super(start, end, searchText, forwardDirection);
            this.match = match;
        }

        FindMatch getMatch() {
            return this.match;
        }
    }

    private class FindMatch {
        private String text;
        private int start;
        private int end;
        private boolean isActive;
        private Object lastHighlightTag;

        FindMatch(String text, int start, int end) {
            this.start = start;
            this.end = end;
            this.text = text;
        }

        boolean contains(int pos) {
            return this.start <= pos && pos < this.end;
        }

        void activate() {
            this.setActive(true);
            TextComponentSearcher.this.setCaretPositionInternally(this.start);
            this.scrollToVisible();
        }

        void setActive(boolean b) {
            this.isActive = b;
            this.applyHighlight();
        }

        int getStart() {
            return this.start;
        }

        int getEnd() {
            return this.end;
        }

        void scrollToVisible() {
            try {
                Rectangle startR = TextComponentSearcher.this.editorPane.modelToView2D(this.start).getBounds();
                Rectangle endR = TextComponentSearcher.this.editorPane.modelToView2D(this.end).getBounds();
                endR.width += 20;
                Rectangle union = startR.union(endR);
                TextComponentSearcher.this.editorPane.scrollRectToVisible(union);
            }
            catch (BadLocationException e) {
                Msg.debug((Object)this, (Object)"Exception scrolling to text", (Throwable)e);
            }
        }

        public String toString() {
            return "[" + this.start + "," + this.end + "] " + this.text;
        }

        void applyHighlight() {
            Highlighter highlighter = TextComponentSearcher.this.editorPane.getHighlighter();
            if (highlighter == null) {
                highlighter = new DefaultHighlighter();
                TextComponentSearcher.this.editorPane.setHighlighter(highlighter);
            }
            DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(this.isActive ? TextComponentSearcher.this.activeHighlightColor : TextComponentSearcher.this.highlightColor);
            try {
                if (this.lastHighlightTag != null) {
                    highlighter.removeHighlight(this.lastHighlightTag);
                }
                this.lastHighlightTag = highlighter.addHighlight(this.start, this.end, painter);
            }
            catch (BadLocationException e) {
                Msg.debug((Object)this, (Object)"Exception adding highlight", (Throwable)e);
            }
        }
    }

    private class SearchTask
    extends Task {
        private String searchText;
        private TreeMap<Integer, FindMatch> searchHits;
        private boolean useRegex;

        SearchTask(String searchText, boolean useRegex) {
            super("Help Search Task", true, false, true, true);
            this.searchHits = new TreeMap();
            this.searchText = searchText;
            this.useRegex = useRegex;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            String screenText;
            try {
                Document document = TextComponentSearcher.this.editorPane.getDocument();
                screenText = document.getText(0, document.getLength());
            }
            catch (BadLocationException e) {
                Msg.error((Object)((Object)this), (Object)"Unable to get text for user find operation", (Throwable)e);
                return;
            }
            Pattern pattern = this.createSearchPattern(this.searchText, this.useRegex);
            Matcher matcher = pattern.matcher(screenText);
            while (matcher.find()) {
                monitor.checkCancelled();
                int start = matcher.start();
                int end = matcher.end();
                FindMatch match = new FindMatch(this.searchText, start, end);
                this.searchHits.put(start, match);
            }
        }

        private Pattern createSearchPattern(String searchString, boolean isRegex) {
            int options = 34;
            if (isRegex) {
                try {
                    return Pattern.compile(searchString, options);
                }
                catch (PatternSyntaxException e) {
                    Msg.showError((Object)((Object)this), (Component)TextComponentSearcher.this.editorPane, (String)"Regular Expression Syntax Error", (Object)e.getMessage());
                    return null;
                }
            }
            return UserSearchUtils.createPattern((String)searchString, (boolean)false, (int)options);
        }

        SearchResults getSearchResults() {
            return new SearchResults(this.searchText, this.searchHits);
        }
    }
}

