/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.RowColLocation;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.text.BreakIterator;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.JComponent;
import javax.swing.text.AttributeSet;

public class AccessibleField
extends AccessibleContext
implements Accessible,
AccessibleComponent,
AccessibleText {
    private Field field;
    private int indexInParent;
    private Rectangle boundsInParent;
    private Locale locale;
    private JComponent parent;
    private int caretPos = 0;
    private boolean isSelected = false;

    public AccessibleField(Field field, JComponent parent, int indexInParent, Rectangle bounds) {
        this.field = field;
        this.parent = parent;
        this.indexInParent = indexInParent;
        this.locale = parent.getLocale();
        this.boundsInParent = bounds;
        this.setAccessibleName("Field");
    }

    public void setCaretPos(int caretPos) {
        if (caretPos >= 0 && caretPos < this.field.getText().length()) {
            this.caretPos = caretPos;
        }
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public String getText() {
        return this.field.getText();
    }

    public int getTextOffset(int row, int col) {
        return this.field.screenLocationToTextOffset(row, col);
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return this;
    }

    @Override
    public AccessibleText getAccessibleText() {
        return this;
    }

    @Override
    public AccessibleComponent getAccessibleComponent() {
        return this;
    }

    @Override
    public AccessibleRole getAccessibleRole() {
        return AccessibleRole.TEXT;
    }

    @Override
    public AccessibleStateSet getAccessibleStateSet() {
        AccessibleStateSet states = new AccessibleStateSet();
        states.add(AccessibleState.MULTI_LINE);
        states.add(AccessibleState.TRANSIENT);
        return states;
    }

    @Override
    public int getAccessibleIndexInParent() {
        return this.indexInParent;
    }

    @Override
    public int getAccessibleChildrenCount() {
        return 0;
    }

    @Override
    public Accessible getAccessibleChild(int i) {
        return null;
    }

    @Override
    public Locale getLocale() throws IllegalComponentStateException {
        return this.locale;
    }

    @Override
    public int getIndexAtPoint(Point p) {
        int row = this.field.getRow(p.y - this.field.getHeightAbove());
        int col = this.field.getCol(row, p.x + this.field.getStartX());
        int result = this.field.screenLocationToTextOffset(row, col);
        return result;
    }

    @Override
    public Rectangle getCharacterBounds(int i) {
        if (i < 0 || i >= this.getCharCount()) {
            return new Rectangle(0, 0, 0, 0);
        }
        RowColLocation rowCol = this.field.textOffsetToScreenLocation(i);
        int row = rowCol.row();
        int col = rowCol.col();
        Rectangle charBounds = this.field.getCursorBounds(row, col);
        Rectangle nextCharBounds = this.field.getCursorBounds(row, col + 1);
        charBounds.width = nextCharBounds.x - charBounds.x;
        charBounds.y += this.field.getHeightAbove();
        charBounds.x -= this.field.getStartX();
        return charBounds;
    }

    @Override
    public int getCharCount() {
        return this.field.getText().length();
    }

    @Override
    public String getAtIndex(int part, int index) {
        String text = this.field.getText();
        if (index < 0 || index >= text.length()) {
            return null;
        }
        switch (part) {
            case 1: {
                return text.substring(index, index + 1);
            }
            case 2: {
                BreakIterator words = BreakIterator.getWordInstance(this.locale);
                words.setText(text);
                int end = words.following(index);
                return text.substring(words.previous(), end);
            }
            case 3: {
                BreakIterator sentences = BreakIterator.getSentenceInstance(this.locale);
                sentences.setText(text);
                int end = sentences.following(index);
                return text.substring(sentences.previous(), end);
            }
        }
        return null;
    }

    @Override
    public String getAfterIndex(int part, int index) {
        String text = this.field.getText();
        if (index < 0 || index >= text.length() - 1) {
            return null;
        }
        switch (part) {
            case 1: {
                return text.substring(index + 1, index + 2);
            }
            case 2: {
                BreakIterator words = BreakIterator.getWordInstance(this.locale);
                words.setText(text);
                int start = words.following(index);
                if (start == -1 || start >= text.length()) {
                    return null;
                }
                int end = words.following(start);
                if (end == -1 || end > text.length()) {
                    return null;
                }
                return text.substring(start, end);
            }
            case 3: {
                BreakIterator sentences = BreakIterator.getSentenceInstance(this.locale);
                sentences.setText(text);
                int start = sentences.following(index);
                if (start == -1 || start > text.length()) {
                    return null;
                }
                int end = sentences.following(start);
                if (end == -1 || end > text.length()) {
                    return null;
                }
                return text.substring(start, end);
            }
        }
        return null;
    }

    @Override
    public String getBeforeIndex(int part, int index) {
        String text = this.field.getText();
        if (index < 1 || index > text.length()) {
            return null;
        }
        switch (part) {
            case 1: {
                return text.substring(index - 1, index);
            }
            case 2: {
                BreakIterator words = BreakIterator.getWordInstance(this.locale);
                words.setText(text);
                if (!words.isBoundary(index)) {
                    words.preceding(index);
                }
                int start = words.previous();
                int end = words.next();
                if (start == -1) {
                    return null;
                }
                return text.substring(start, end);
            }
            case 3: {
                BreakIterator sentences = BreakIterator.getSentenceInstance(this.locale);
                sentences.setText(text);
                if (!sentences.isBoundary(index)) {
                    sentences.preceding(index);
                }
                int start = sentences.previous();
                int end = sentences.next();
                if (start == -1) {
                    return null;
                }
                return text.substring(start, end);
            }
        }
        return null;
    }

    @Override
    public int getCaretPosition() {
        return this.caretPos;
    }

    @Override
    public AttributeSet getCharacterAttribute(int i) {
        return null;
    }

    @Override
    public int getSelectionStart() {
        return 0;
    }

    @Override
    public int getSelectionEnd() {
        if (this.isSelected) {
            return this.field.getText().length();
        }
        return 0;
    }

    @Override
    public String getSelectedText() {
        if (this.isSelected) {
            return this.field.getText();
        }
        return null;
    }

    @Override
    public Color getBackground() {
        return this.parent.getBackground();
    }

    @Override
    public void setBackground(Color c) {
    }

    @Override
    public Color getForeground() {
        return this.parent.getForeground();
    }

    @Override
    public void setForeground(Color c) {
    }

    @Override
    public Cursor getCursor() {
        return this.parent.getCursor();
    }

    @Override
    public void setCursor(Cursor cursor) {
    }

    @Override
    public Font getFont() {
        return this.parent.getFont();
    }

    @Override
    public void setFont(Font f) {
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.parent.getFontMetrics(f);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean b) {
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void setVisible(boolean b) {
    }

    @Override
    public boolean isShowing() {
        return true;
    }

    @Override
    public boolean contains(Point p) {
        return p.x >= 0 && p.x < this.field.getWidth() && p.y >= 0 && p.y < this.field.getHeight();
    }

    @Override
    public Point getLocationOnScreen() {
        Point parentLoc = this.parent.getLocationOnScreen();
        return new Point(parentLoc.x + this.boundsInParent.x, parentLoc.y + this.boundsInParent.y);
    }

    @Override
    public Point getLocation() {
        return this.boundsInParent.getLocation();
    }

    @Override
    public void setLocation(Point p) {
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.boundsInParent);
    }

    @Override
    public void setBounds(Rectangle r) {
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.field.getWidth(), this.field.getHeight());
    }

    @Override
    public void setSize(Dimension d) {
    }

    @Override
    public Accessible getAccessibleAt(Point p) {
        return null;
    }

    @Override
    public boolean isFocusTraversable() {
        return false;
    }

    @Override
    public void requestFocus() {
    }

    @Override
    public void addFocusListener(FocusListener l) {
    }

    @Override
    public void removeFocusListener(FocusListener l) {
    }
}

