/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filter;

import docking.widgets.filter.AbstractPatternTextFilter;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class MatchesPatternTextFilter
extends AbstractPatternTextFilter {
    protected boolean caseSensitive;
    protected boolean allowGlobbing;

    public MatchesPatternTextFilter(String filterText, boolean caseSensitive, boolean allowGlobbing) {
        super(filterText);
        this.caseSensitive = caseSensitive;
        this.allowGlobbing = allowGlobbing;
    }

    protected boolean parentIsGlobEscape(MatchesPatternTextFilter parent) {
        boolean endsWithEscapedGlob;
        return this.allowGlobbing && (endsWithEscapedGlob = StringUtils.endsWithAny((CharSequence)this.filterText, (CharSequence[])new CharSequence[]{"\\?", "\\*"})) && parent.filterText.endsWith("\\");
    }

    @Override
    public boolean matches(String text, Pattern pattern) {
        return pattern.matcher(text).matches();
    }

    @Override
    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MatchesPatternTextFilter other = (MatchesPatternTextFilter)obj;
        if (this.allowGlobbing != other.allowGlobbing) {
            return false;
        }
        return this.caseSensitive == other.caseSensitive;
    }
}

