/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.list;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class ListRendererMouseEventForwarder
extends MouseAdapter {
    @Override
    public void mouseMoved(MouseEvent e) {
        this.redispatchEvent(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.redispatchEvent(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.redispatchEvent(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.redispatchEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.redispatchEvent(e);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.redispatchEvent(event);
    }

    private void redispatchEvent(MouseEvent event) {
        int index;
        JList list = (JList)event.getSource();
        Rectangle cellBounds = list.getCellBounds(index = list.locationToIndex(event.getPoint()), index);
        if (cellBounds == null) {
            return;
        }
        ListModel model = list.getModel();
        Object state = model.getElementAt(index);
        ListCellRenderer renderer = list.getCellRenderer();
        Component rendererComponent = renderer.getListCellRendererComponent(list, state, index, true, true);
        rendererComponent.setBounds(cellBounds);
        Point p = event.getPoint();
        p.translate(-cellBounds.x, -cellBounds.y);
        MouseEvent newEvent = new MouseEvent(rendererComponent, event.getID(), event.getWhen(), event.getModifiers(), p.x, p.y, event.getXOnScreen(), event.getYOnScreen(), event.getClickCount(), event.isPopupTrigger(), event.getButton());
        rendererComponent.dispatchEvent(newEvent);
        list.repaint();
    }
}

