/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.support;

import docking.DockingUtils;
import docking.UndoRedoKeeper;
import docking.widgets.tree.GTreeNode;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;

public class GTreeCellEditor
extends DefaultTreeCellEditor {
    private UndoRedoKeeper undoRedoKeeper;

    public GTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
        super(tree, renderer);
        Component c;
        if (this.realEditor instanceof DefaultCellEditor && (c = ((DefaultCellEditor)this.realEditor).getComponent()) instanceof JTextField) {
            JTextField tf = (JTextField)c;
            this.undoRedoKeeper = DockingUtils.installUndoRedo(tf);
        }
    }

    @Override
    public boolean stopCellEditing() {
        if (super.stopCellEditing()) {
            this.clearUndoRedo();
            return true;
        }
        return false;
    }

    @Override
    public void cancelCellEditing() {
        super.cancelCellEditing();
        this.clearUndoRedo();
    }

    private void clearUndoRedo() {
        if (this.undoRedoKeeper != null) {
            this.undoRedoKeeper.clear();
        }
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        GTreeNode node = (GTreeNode)value;
        if (node.isLeaf()) {
            this.renderer.setLeafIcon(node.getIcon(expanded));
        } else {
            this.renderer.setOpenIcon(node.getIcon(true));
            this.renderer.setClosedIcon(node.getIcon(false));
        }
        return super.getTreeCellEditorComponent(jTree, value, isSelected, expanded, leaf, row);
    }
}

