/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import db.DBRecord;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.database.target.DBTraceObjectManager;
import ghidra.trace.database.target.DBTraceObjectValueData;
import ghidra.trace.database.target.DBTraceObjectValueMapAddressSetView;
import ghidra.trace.database.target.DBTraceObjectValueNode;
import ghidra.trace.database.target.TraceObjectValueQuery;
import ghidra.trace.database.target.ValueBox;
import ghidra.trace.database.target.ValueShape;
import ghidra.trace.database.target.ValueSpace;
import ghidra.trace.database.target.ValueTriple;
import ghidra.trace.model.Lifespan;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.spatial.AbstractConstraintsTree;
import ghidra.util.database.spatial.AbstractRStarConstraintsTree;
import ghidra.util.database.spatial.DBTreeDataRecord;
import ghidra.util.database.spatial.DBTreeRecord;
import ghidra.util.database.spatial.SpatialMap;
import ghidra.util.database.spatial.hyper.AbstractHyperBoxQuery;
import ghidra.util.database.spatial.hyper.AbstractHyperRStarTree;
import ghidra.util.database.spatial.hyper.EuclideanHyperSpace;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Predicate;

public class DBTraceObjectValueRStarTree
extends AbstractHyperRStarTree<ValueTriple, ValueShape, DBTraceObjectValueData, ValueBox, DBTraceObjectValueNode, DBTraceObjectValueData, TraceObjectValueQuery> {
    protected final DBTraceObjectManager manager;
    protected final DBCachedObjectIndex<Long, DBTraceObjectValueNode> nodesByParent;
    protected final DBCachedObjectIndex<Long, DBTraceObjectValueData> dataByParent;

    public DBTraceObjectValueRStarTree(DBTraceObjectManager manager, DBCachedObjectStoreFactory storeFactory, String tableName, EuclideanHyperSpace<ValueTriple, ValueBox> space, Class<DBTraceObjectValueData> dataType, Class<DBTraceObjectValueNode> nodeType, boolean upgradeable, int maxChildren) throws VersionException, IOException {
        super(storeFactory, tableName, space, dataType, nodeType, upgradeable, maxChildren);
        this.manager = manager;
        this.nodesByParent = this.nodeStore.getIndex(Long.TYPE, DBTraceObjectValueNode.PARENT_COLUMN);
        this.dataByParent = this.dataStore.getIndex(Long.TYPE, DBTraceObjectValueNode.PARENT_COLUMN);
        this.init();
    }

    protected DBCachedObjectStore<DBTraceObjectValueData> getDataStore() {
        return this.dataStore;
    }

    protected void doUnparentEntry(DBTraceObjectValueData data) {
        super.doUnparentEntry((DBTreeDataRecord)data);
    }

    protected void doInsertDataEntry(DBTraceObjectValueData entry) {
        super.doInsert((DBTreeRecord)entry, new AbstractRStarConstraintsTree.LevelInfo(this.leafLevel));
    }

    protected void doDeleteEntry(DBTraceObjectValueData data) {
        super.doDeleteEntry((DBTreeDataRecord)data);
    }

    protected DBTraceObjectValueData createDataEntry(DBCachedObjectStore<DBTraceObjectValueData> store, DBRecord record) {
        return new DBTraceObjectValueData(this.manager, this, store, record);
    }

    protected DBTraceObjectValueNode createNodeEntry(DBCachedObjectStore<DBTraceObjectValueNode> store, DBRecord record) {
        return new DBTraceObjectValueNode(this, store, record);
    }

    protected Collection<DBTraceObjectValueNode> getNodeChildrenOf(long parentKey) {
        return this.nodesByParent.get((Object)parentKey);
    }

    protected Collection<DBTraceObjectValueData> getDataChildrenOf(long parentKey) {
        return this.dataByParent.get((Object)parentKey);
    }

    public DBTraceObjectValueMap asSpatialMap() {
        return new DBTraceObjectValueMap((AbstractConstraintsTree<ValueShape, DBTraceObjectValueData, ValueBox, ?, DBTraceObjectValueData, TraceObjectValueQuery>)this, null, this.manager.trace.getBaseAddressFactory(), this.manager.lock);
    }

    public static class DBTraceObjectValueMap
    extends AbstractHyperRStarTree.AsSpatialMap<ValueShape, DBTraceObjectValueData, ValueBox, DBTraceObjectValueData, TraceObjectValueQuery> {
        private final AddressFactory factory;
        private final ReadWriteLock lock;

        public DBTraceObjectValueMap(AbstractConstraintsTree<ValueShape, DBTraceObjectValueData, ValueBox, ?, DBTraceObjectValueData, TraceObjectValueQuery> tree, TraceObjectValueQuery query, AddressFactory factory, ReadWriteLock lock) {
            super(tree, (AbstractHyperBoxQuery)query);
            this.factory = factory;
            this.lock = lock;
        }

        public DBTraceObjectValueMap reduce(TraceObjectValueQuery andQuery) {
            return new DBTraceObjectValueMap(this.tree, this.query == null ? andQuery : (TraceObjectValueQuery)((TraceObjectValueQuery)this.query).and(andQuery), this.factory, this.lock);
        }

        public AddressSetView getAddressSetView(Lifespan at, Predicate<? super DBTraceObjectValueData> predicate) {
            return new DBTraceObjectValueMapAddressSetView(this.factory, this.lock, (SpatialMap<ValueShape, DBTraceObjectValueData, TraceObjectValueQuery>)this.reduce(TraceObjectValueQuery.intersecting(ValueSpace.EntryKeyDimension.INSTANCE.absoluteMin(), ValueSpace.EntryKeyDimension.INSTANCE.absoluteMax(), at, ValueSpace.AddressDimension.INSTANCE.absoluteMin(), ValueSpace.AddressDimension.INSTANCE.absoluteMax())), predicate);
        }
    }
}

