/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model;

import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.model.Lifespan;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public interface TraceTimeViewport {
    public void setSnap(long var1);

    public void addChangeListener(Runnable var1);

    public void removeChangeListener(Runnable var1);

    public boolean isForked();

    public boolean containsAnyUpper(Lifespan var1);

    public <T> boolean isCompletelyVisible(AddressRange var1, Lifespan var2, T var3, Occlusion<T> var4);

    public <T> AddressSet computeVisibleParts(AddressSetView var1, Lifespan var2, T var3, Occlusion<T> var4);

    public List<Lifespan> getOrderedSpans();

    public List<Lifespan> getReversedSpans();

    public List<Long> getOrderedSnaps();

    public List<Long> getReversedSnaps();

    public <T> T getTop(Function<Long, T> var1);

    public <T> Iterator<T> mergedIterator(Function<Long, Iterator<T>> var1, Comparator<? super T> var2);

    public AddressSetView unionedAddresses(Function<Long, AddressSetView> var1);

    public static interface SetQueryOcclusion<T>
    extends QueryOcclusion<T> {
        @Override
        default public boolean itemOccludes(AddressRange range, T t, long snap) {
            return this.set(t, snap).intersects(range.getMinAddress(), range.getMaxAddress());
        }

        @Override
        default public void removeItem(AddressSet remains, T t, long snap) {
            for (AddressRange range : this.set(t, snap)) {
                remains.delete(range);
                if (!remains.isEmpty()) continue;
                return;
            }
        }

        public AddressSetView set(T var1, long var2);
    }

    public static interface RangeQueryOcclusion<T>
    extends QueryOcclusion<T> {
        @Override
        default public boolean itemOccludes(AddressRange range, T t, long snap) {
            return this.range(t, snap).intersects(range);
        }

        @Override
        default public void removeItem(AddressSet remains, T t, long snap) {
            remains.delete(this.range(t, snap));
        }

        public AddressRange range(T var1, long var2);
    }

    public static interface QueryOcclusion<T>
    extends Occlusion<T> {
        @Override
        default public boolean occluded(T object, AddressRange range, Lifespan span) {
            for (T found : this.query(range, span)) {
                if (found == object || !this.itemOccludes(range, found, span.lmax())) continue;
                return true;
            }
            return false;
        }

        @Override
        default public void remove(T object, AddressSet remains, Lifespan span) {
            for (T found : this.query((AddressRange)new AddressRangeImpl(remains.getMinAddress(), remains.getMaxAddress()), span)) {
                if (found == object) continue;
                this.removeItem(remains, found, span.lmax());
                if (!remains.isEmpty()) continue;
                return;
            }
        }

        public Iterable<? extends T> query(AddressRange var1, Lifespan var2);

        public boolean itemOccludes(AddressRange var1, T var2, long var3);

        public void removeItem(AddressSet var1, T var2, long var3);
    }

    public static interface Occlusion<T> {
        public boolean occluded(T var1, AddressRange var2, Lifespan var3);

        public void remove(T var1, AddressSet var2, Lifespan var3);
    }
}

