/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.python.icu.text.StringTransform;
import org.python.icu.text.SymbolTable;
import org.python.icu.text.UnicodeSet;
import org.python.icu.util.Freezable;

public class UnicodeRegex
implements Cloneable,
Freezable<UnicodeRegex>,
StringTransform {
    private static final Pattern SUPP_ESCAPE = Pattern.compile("\\\\U00([0-9a-fA-F]{6})");
    private SymbolTable symbolTable;
    private static final UnicodeRegex STANDARD = new UnicodeRegex();
    private String bnfCommentString = "#";
    private String bnfVariableInfix = "=";
    private String bnfLineSeparator = "\n";
    private Comparator<Object> LongestFirst = new Comparator<Object>(){

        @Override
        public int compare(Object obj0, Object obj1) {
            int len1;
            String arg0 = obj0.toString();
            String arg1 = obj1.toString();
            int len0 = arg0.length();
            if (len0 != (len1 = arg1.length())) {
                return len1 - len0;
            }
            return arg0.compareTo(arg1);
        }
    };

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public UnicodeRegex setSymbolTable(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String transform(String regex) {
        StringBuilder result2 = new StringBuilder();
        UnicodeSet temp = new UnicodeSet();
        ParsePosition pos = new ParsePosition(0);
        int state = 0;
        int i = 0;
        while (true) {
            block13: {
                if (i >= regex.length()) {
                    return result2.toString();
                }
                char ch = regex.charAt(i);
                switch (state) {
                    case 0: {
                        if (ch == '\\') {
                            if (UnicodeSet.resemblesPattern(regex, i)) {
                                i = this.processSet(regex, i, result2, temp, pos);
                                break block13;
                            } else {
                                state = 1;
                                break;
                            }
                        }
                        if (ch != '[' || !UnicodeSet.resemblesPattern(regex, i)) break;
                        i = this.processSet(regex, i, result2, temp, pos);
                        break block13;
                    }
                    case 1: {
                        if (ch == 'Q') {
                            state = 2;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 2: {
                        if (ch != '\\') break;
                        state = 3;
                        break;
                    }
                    case 3: {
                        if (ch == 'E') {
                            state = 0;
                            break;
                        }
                        if (ch == '\\') break;
                        state = 2;
                    }
                }
                result2.append(ch);
            }
            ++i;
        }
    }

    public static String fix(String regex) {
        return STANDARD.transform(regex);
    }

    public static Pattern compile(String regex) {
        return Pattern.compile(STANDARD.transform(regex));
    }

    public static Pattern compile(String regex, int options) {
        return Pattern.compile(STANDARD.transform(regex), options);
    }

    public String compileBnf(String bnfLines) {
        return this.compileBnf(Arrays.asList(bnfLines.split("\\r\\n?|\\n")));
    }

    public String compileBnf(List<String> lines) {
        Map<String, String> variables = this.getVariables(lines);
        LinkedHashSet<String> unused = new LinkedHashSet<String>(variables.keySet());
        for (int i = 0; i < 2; ++i) {
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                String variable = entry.getKey();
                String definition = entry.getValue();
                for (Map.Entry<String, String> entry2 : variables.entrySet()) {
                    String altered2;
                    String variable2 = entry2.getKey();
                    String definition2 = entry2.getValue();
                    if (variable.equals(variable2) || (altered2 = definition2.replace(variable, definition)).equals(definition2)) continue;
                    unused.remove(variable);
                    variables.put(variable2, altered2);
                }
            }
        }
        if (unused.size() != 1) {
            throw new IllegalArgumentException("Not a single root: " + unused);
        }
        return variables.get(unused.iterator().next());
    }

    public String getBnfCommentString() {
        return this.bnfCommentString;
    }

    public void setBnfCommentString(String bnfCommentString) {
        this.bnfCommentString = bnfCommentString;
    }

    public String getBnfVariableInfix() {
        return this.bnfVariableInfix;
    }

    public void setBnfVariableInfix(String bnfVariableInfix) {
        this.bnfVariableInfix = bnfVariableInfix;
    }

    public String getBnfLineSeparator() {
        return this.bnfLineSeparator;
    }

    public void setBnfLineSeparator(String bnfLineSeparator) {
        this.bnfLineSeparator = bnfLineSeparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> appendLines(List<String> result2, String file, String encoding) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            List<String> list = UnicodeRegex.appendLines(result2, is, encoding);
            return list;
        }
    }

    public static List<String> appendLines(List<String> result2, InputStream inputStream, String encoding) throws UnsupportedEncodingException, IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, encoding == null ? "UTF-8" : encoding));
        while ((line = in.readLine()) != null) {
            result2.add(line);
        }
        return result2;
    }

    @Override
    public UnicodeRegex cloneAsThawed() {
        try {
            return (UnicodeRegex)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public UnicodeRegex freeze() {
        return this;
    }

    @Override
    public boolean isFrozen() {
        return true;
    }

    private int processSet(String regex, int i, StringBuilder result2, UnicodeSet temp, ParsePosition pos) {
        try {
            pos.setIndex(i);
            UnicodeSet x = temp.clear().applyPattern(regex, pos, this.symbolTable, 0);
            x.complement().complement();
            String pattern = x.toPattern(false);
            if (pattern.contains("\\U")) {
                pattern = SUPP_ESCAPE.matcher(pattern).replaceAll("\\\\x{$1}");
            }
            result2.append(pattern);
            i = pos.getIndex() - 1;
            return i;
        }
        catch (Exception e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Error in " + regex).initCause(e);
        }
    }

    private Map<String, String> getVariables(List<String> lines) {
        TreeMap<Object, String> variables = new TreeMap<Object, String>(this.LongestFirst);
        String variable = null;
        StringBuffer definition = new StringBuffer();
        int count2 = 0;
        for (String line : lines) {
            int equalsPos;
            String linePart;
            String trimline;
            int hashPos;
            ++count2;
            if (line.length() == 0) continue;
            if (line.charAt(0) == '\ufeff') {
                line = line.substring(1);
            }
            if (this.bnfCommentString != null && (hashPos = line.indexOf(this.bnfCommentString)) >= 0) {
                line = line.substring(0, hashPos);
            }
            if ((trimline = line.trim()).length() == 0 || (linePart = line).trim().length() == 0) continue;
            boolean terminated = trimline.endsWith(";");
            if (terminated) {
                linePart = linePart.substring(0, linePart.lastIndexOf(59));
            }
            if ((equalsPos = linePart.indexOf(this.bnfVariableInfix)) >= 0) {
                if (variable != null) {
                    throw new IllegalArgumentException("Missing ';' before " + count2 + ") " + line);
                }
                variable = linePart.substring(0, equalsPos).trim();
                if (variables.containsKey(variable)) {
                    throw new IllegalArgumentException("Duplicate variable definition in " + line);
                }
                definition.append(linePart.substring(equalsPos + 1).trim());
            } else {
                if (variable == null) {
                    throw new IllegalArgumentException("Missing '=' at " + count2 + ") " + line);
                }
                definition.append(this.bnfLineSeparator).append(linePart);
            }
            if (!terminated) continue;
            variables.put(variable, definition.toString());
            variable = null;
            definition.setLength(0);
        }
        if (variable != null) {
            throw new IllegalArgumentException("Missing ';' at end");
        }
        return variables;
    }
}

