/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.number;

import java.text.Format;
import org.python.icu.impl.FormattedStringBuilder;
import org.python.icu.impl.SimpleFormatterImpl;
import org.python.icu.impl.number.Modifier;
import org.python.icu.impl.number.range.PrefixInfixSuffixLengthHelper;
import org.python.icu.util.ICUException;

public class SimpleModifier
implements Modifier {
    private final String compiledPattern;
    private final Format.Field field;
    private final boolean strong;
    private final Modifier.Parameters parameters;
    private static final int ARG_NUM_LIMIT = 256;

    public SimpleModifier(String compiledPattern, Format.Field field, boolean strong) {
        this(compiledPattern, field, strong, null);
    }

    public SimpleModifier(String compiledPattern, Format.Field field, boolean strong, Modifier.Parameters parameters) {
        assert (compiledPattern != null);
        this.compiledPattern = compiledPattern;
        this.field = field;
        this.strong = strong;
        this.parameters = parameters;
    }

    @Override
    public int apply(FormattedStringBuilder output, int leftIndex, int rightIndex) {
        return SimpleFormatterImpl.formatPrefixSuffix(this.compiledPattern, this.field, leftIndex, rightIndex, output);
    }

    @Override
    public int getPrefixLength() {
        return SimpleFormatterImpl.getPrefixLength(this.compiledPattern);
    }

    @Override
    public int getCodePointCount() {
        return SimpleFormatterImpl.getLength(this.compiledPattern, true);
    }

    @Override
    public boolean isStrong() {
        return this.strong;
    }

    @Override
    public boolean containsField(Format.Field field) {
        assert (false);
        return false;
    }

    @Override
    public Modifier.Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public boolean strictEquals(Modifier other) {
        if (!(other instanceof SimpleModifier)) {
            return false;
        }
        SimpleModifier _other = (SimpleModifier)other;
        return this.compiledPattern.equals(_other.compiledPattern) && this.field == _other.field && this.strong == _other.strong;
    }

    public static void formatTwoArgPattern(String compiledPattern, FormattedStringBuilder result2, int index, PrefixInfixSuffixLengthHelper h, Format.Field field) {
        int suffixLength;
        int argLimit = SimpleFormatterImpl.getArgumentLimit(compiledPattern);
        if (argLimit != 2) {
            throw new ICUException();
        }
        int offset = 1;
        int length = 0;
        int prefixLength = compiledPattern.charAt(offset);
        ++offset;
        if (prefixLength < 256) {
            prefixLength = 0;
        } else {
            result2.insert(index + length, compiledPattern, offset, offset + (prefixLength -= 256), field);
            offset += prefixLength;
            length += prefixLength;
            ++offset;
        }
        int infixLength = compiledPattern.charAt(offset);
        ++offset;
        if (infixLength < 256) {
            infixLength = 0;
        } else {
            result2.insert(index + length, compiledPattern, offset, offset + (infixLength -= 256), field);
            offset += infixLength;
            length += infixLength;
            ++offset;
        }
        if (offset == compiledPattern.length()) {
            suffixLength = 0;
        } else {
            suffixLength = compiledPattern.charAt(offset) - 256;
            result2.insert(index + length, compiledPattern, ++offset, offset + suffixLength, field);
            length += suffixLength;
        }
        h.lengthPrefix = prefixLength;
        h.lengthInfix = infixLength;
        h.lengthSuffix = suffixLength;
    }
}

