/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.DropTargetHandler;
import docking.dnd.DropTgtAdapter;
import docking.dnd.Droppable;
import ghidra.app.util.FileOpenDataFlavorHandler;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.CascadedDropTarget;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.swing.CellRendererPane;

public class FileOpenDropHandler
implements DropTargetHandler,
Droppable,
ContainerListener {
    private static LinkedHashMap<DataFlavor, FileOpenDataFlavorHandler> handlers = new LinkedHashMap();
    private DropTgtAdapter dropTargetAdapter;
    private DropTarget globalDropTarget;
    private PluginTool tool;
    private Component component;

    public FileOpenDropHandler(PluginTool tool, Component component) {
        this.tool = tool;
        this.component = component;
        Set<DataFlavor> keySet = handlers.keySet();
        DataFlavor[] handlersFlavorArray = keySet.toArray(new DataFlavor[keySet.size()]);
        this.dropTargetAdapter = new DropTgtAdapter((Droppable)this, 3, handlersFlavorArray);
        this.globalDropTarget = new DropTarget(component, 3, (DropTargetListener)this.dropTargetAdapter, true);
        this.initializeComponents(component);
    }

    public void dispose() {
        this.deinitializeComponents(this.component);
        this.globalDropTarget.removeDropTargetListener((DropTargetListener)this.dropTargetAdapter);
    }

    public boolean isDropOk(DropTargetDragEvent e) {
        Set<DataFlavor> flavors = handlers.keySet();
        for (DataFlavor dataFlavor : flavors) {
            if (!e.isDataFlavorSupported(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public void add(Object obj, DropTargetDropEvent e, DataFlavor f) {
        FileOpenDataFlavorHandler handler = handlers.get(f);
        if (handler != null) {
            handler.handle(this.tool, obj, e, f);
        }
    }

    private void initializeComponents(Component comp) {
        DropTarget primaryDropTarget;
        if (comp instanceof CellRendererPane) {
            return;
        }
        if (comp instanceof Container) {
            Component[] comps;
            Container c = (Container)comp;
            c.addContainerListener(this);
            for (Component element : comps = c.getComponents()) {
                this.initializeComponents(element);
            }
        }
        if ((primaryDropTarget = comp.getDropTarget()) != null) {
            new CascadedDropTarget(comp, primaryDropTarget, this.globalDropTarget);
        }
    }

    private void deinitializeComponents(Component comp) {
        DropTarget dt;
        if (comp instanceof CellRendererPane) {
            return;
        }
        if (comp instanceof Container) {
            Component[] comps;
            Container c = (Container)comp;
            c.removeContainerListener(this);
            for (Component element : comps = c.getComponents()) {
                this.deinitializeComponents(element);
            }
        }
        if ((dt = comp.getDropTarget()) instanceof CascadedDropTarget) {
            CascadedDropTarget target = (CascadedDropTarget)dt;
            DropTarget newTarget = target.removeDropTarget(this.globalDropTarget);
            comp.setDropTarget(newTarget);
        }
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this.initializeComponents(e.getChild());
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        this.deinitializeComponents(e.getChild());
    }

    public static void addDataFlavorHandler(DataFlavor dataFlavor, FileOpenDataFlavorHandler handler) {
        handlers.put(dataFlavor, handler);
    }

    public static FileOpenDataFlavorHandler removeDataFlavorHandler(DataFlavor dataFlavor) {
        return (FileOpenDataFlavorHandler)handlers.remove(dataFlavor);
    }
}

