/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.framework.store.local.IndexedLocalFileSystem;
import ghidra.framework.store.local.IndexedV1LocalFileSystem;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.framework.store.local.MangledLocalFileSystem;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class ConvertFileSystem
implements GhidraLaunchable {
    public void launch(GhidraApplicationLayout layout, String[] args) {
        MessageListener msgListener = string -> System.out.println(string);
        try {
            File dir = ConvertFileSystem.getDir(args.length == 0 ? null : args[0]);
            if (dir.getName().endsWith(".rep")) {
                ConvertFileSystem.convertProject(dir, msgListener);
            } else {
                ConvertFileSystem.convertRepositories(dir, msgListener);
            }
        }
        catch (ConvertFileSystemException e) {
            System.err.println(e.getMessage());
        }
    }

    private static File getDir(String path) throws ConvertFileSystemException {
        if (path == null) {
            throw new ConvertFileSystemException("Must specify a project (*.rep) or server repositories directory");
        }
        File dir = new File(path);
        if (!dir.isDirectory()) {
            throw new ConvertFileSystemException("Invalid project or repositories directory specified: " + String.valueOf(dir));
        }
        return dir;
    }

    private static void convertRepositories(File dir, MessageListener msgListener) throws ConvertFileSystemException {
        File file = new File(dir, "~admin");
        if (!file.isDirectory()) {
            throw new ConvertFileSystemException("Invalid repositories directory specified (~admin not found): " + String.valueOf(dir));
        }
        file = new File(dir, "users");
        if (!file.isFile()) {
            throw new ConvertFileSystemException("Invalid repositories directory specified (users not found): " + String.valueOf(dir));
        }
        file = new File(dir, "server.log");
        if (!file.isFile()) {
            throw new ConvertFileSystemException("Invalid repositories directory specified (server.log not found): " + String.valueOf(dir));
        }
        ArrayList<File> repoDirs = new ArrayList<File>();
        for (File f : dir.listFiles()) {
            if (!f.isDirectory() || LocalFileSystem.isHiddenDirName((String)f.getName())) continue;
            repoDirs.add(f);
        }
        msgListener.println("Converting " + repoDirs.size() + " repositories...");
        for (File repoDir : repoDirs) {
            ConvertFileSystem.convertRepo(repoDir, msgListener);
        }
    }

    private static void convertRepo(File repoDir, MessageListener msgListener) throws ConvertFileSystemException {
        try {
            LocalFileSystem fs = LocalFileSystem.getLocalFileSystem((String)repoDir.getAbsolutePath(), (boolean)false, (boolean)true, (boolean)false, (boolean)false);
            if (fs instanceof MangledLocalFileSystem) {
                MangledLocalFileSystem mfs = (MangledLocalFileSystem)fs;
                msgListener.println("Converting repository directory: " + String.valueOf(repoDir));
                mfs.convertToIndexedLocalFileSystem();
            } else if (fs instanceof IndexedLocalFileSystem && ((IndexedLocalFileSystem)fs).getIndexImplementationVersion() < 1) {
                msgListener.println("Rebuilding Index for repository directory (" + fs.getItemCount() + " files): " + String.valueOf(repoDir));
                fs.dispose();
                IndexedV1LocalFileSystem.rebuild((File)repoDir);
            } else {
                msgListener.println("Repository directory has previously been converted: " + String.valueOf(repoDir));
            }
        }
        catch (IOException e) {
            if (e instanceof ConvertFileSystemException) {
                throw (ConvertFileSystemException)e;
            }
            throw new ConvertFileSystemException("Error converting repository directory (" + String.valueOf(repoDir) + "): " + e.getMessage(), e);
        }
    }

    private static void convertProjectDir(File dir, String dirType, MessageListener msgListener) throws ConvertFileSystemException {
        try {
            LocalFileSystem fs = LocalFileSystem.getLocalFileSystem((String)dir.getAbsolutePath(), (boolean)false, (boolean)false, (boolean)false, (boolean)false);
            if (fs instanceof MangledLocalFileSystem) {
                MangledLocalFileSystem mfs = (MangledLocalFileSystem)fs;
                msgListener.println("Converting " + dirType + " directory: " + String.valueOf(dir));
                mfs.convertToIndexedLocalFileSystem();
            } else if (fs instanceof IndexedLocalFileSystem && ((IndexedLocalFileSystem)fs).getIndexImplementationVersion() < 1) {
                msgListener.println("Rebuilding Index for " + dirType + " directory (" + fs.getItemCount() + " files): " + String.valueOf(dir));
                fs.dispose();
                IndexedV1LocalFileSystem.rebuild((File)dir);
            } else if (fs instanceof IndexedLocalFileSystem) {
                msgListener.println("Project " + dirType + " directory has previously been converted: " + String.valueOf(dir));
            }
        }
        catch (IOException e) {
            if (e instanceof ConvertFileSystemException) {
                throw (ConvertFileSystemException)e;
            }
            throw new ConvertFileSystemException("Error converting project " + dirType + " directory (" + String.valueOf(dir) + "): " + e.getMessage(), e);
        }
    }

    public static void convertProject(File dir, MessageListener msgListener) throws ConvertFileSystemException {
        File userDir;
        File projectPropertiesFile = new File(dir, "project.prp");
        if (!projectPropertiesFile.isFile()) {
            throw new ConvertFileSystemException("Invalid project directory specified (project.prp not found): " + String.valueOf(dir));
        }
        File dataDir = new File(dir, "data");
        if (!dataDir.isDirectory()) {
            dataDir = new File(dir, "idata");
        }
        if (!dataDir.isDirectory()) {
            throw new ConvertFileSystemException("Invalid project directory specified (project data not found): " + String.valueOf(dir));
        }
        ConvertFileSystem.convertProjectDir(dataDir, "data", msgListener);
        File versionedDir = new File(dir, "versioned");
        if (versionedDir.isDirectory()) {
            ConvertFileSystem.convertProjectDir(versionedDir, "versioned data", msgListener);
        }
        if ((userDir = new File(dir, "user")).isDirectory()) {
            ConvertFileSystem.convertProjectDir(userDir, "user data", msgListener);
        }
    }

    public static interface MessageListener {
        public void println(String var1);
    }

    public static class ConvertFileSystemException
    extends IOException {
        public ConvertFileSystemException() {
        }

        public ConvertFileSystemException(String message) {
            super(message);
        }

        public ConvertFileSystemException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

