/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.widgets.table.AbstractDynamicTableColumnStub;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.threaded.ThreadedTableModelStub;
import ghidra.docking.settings.Settings;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.main.datatree.CheckoutInfo;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainFolderListenerAdapter;
import ghidra.framework.model.ProjectData;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.Msg;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Date;

class FindCheckoutsTableModel
extends ThreadedTableModelStub<CheckoutInfo> {
    public static final String CHECKOUT_DATE = "Checkout Date";
    private DomainFolder parent;
    private ProjectData projectData;
    DomainFolderChangeListener folderListener;
    private String failedStatusMessage = null;

    public FindCheckoutsTableModel(DomainFolder parent, PluginTool pluginTool) {
        super("Find Checkouts", (ServiceProvider)pluginTool);
        this.parent = parent;
        this.folderListener = new DomainFolderListenerAdapter(){

            @Override
            public void domainFileStatusChanged(DomainFile file, boolean fileIDset) {
                FindCheckoutsTableModel.this.reload();
            }
        };
        this.projectData = parent.getProjectData();
        this.projectData.addDomainFolderChangeListener(this.folderListener);
    }

    public void dispose() {
        super.dispose();
        this.projectData.removeDomainFolderChangeListener(this.folderListener);
        this.projectData = null;
    }

    protected void doLoad(Accumulator<CheckoutInfo> accumulator, TaskMonitor monitor) throws CancelledException {
        this.failedStatusMessage = null;
        try {
            this.findCheckouts(this.parent, accumulator, monitor);
        }
        catch (CancelledException cancelledException) {
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get check out status");
        }
    }

    String getFailedStatusMessage() {
        return this.failedStatusMessage;
    }

    DomainFile getDomainFile(int row) {
        CheckoutInfo info = (CheckoutInfo)this.filteredData.get(row);
        return info.getFile();
    }

    private void findCheckouts(DomainFolder parentFolder, Accumulator<CheckoutInfo> accumulator, TaskMonitor monitor) throws IOException, CancelledException {
        DomainFolder[] folders;
        DomainFile[] files;
        for (DomainFile file : files = parentFolder.getFiles()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            if (!file.isCheckedOut()) continue;
            try {
                CheckoutInfo info = new CheckoutInfo(file);
                accumulator.add((Object)info);
            }
            catch (NotConnectedException nce) {
                this.failedStatusMessage = nce.getMessage();
                return;
            }
            catch (IOException e) {
                Msg.showError((Object)((Object)this), null, (String)"Error Getting Checkout Info", (Object)("Failed to get checkout information for\n" + file.getName()), (Throwable)e);
                throw e;
            }
        }
        for (DomainFolder folder : folders = parentFolder.getFolders()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            this.findCheckouts(folder, accumulator, monitor);
        }
    }

    protected TableColumnDescriptor<CheckoutInfo> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new NameTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new PathTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new CheckoutDateTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new VersionTableColumn(this));
        return descriptor;
    }

    private class NameTableColumn
    extends AbstractDynamicTableColumnStub<CheckoutInfo, String> {
        private NameTableColumn(FindCheckoutsTableModel findCheckoutsTableModel) {
        }

        public String getColumnName() {
            return "Name";
        }

        public String getValue(CheckoutInfo rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getFile().getName();
        }

        public int getColumnPreferredWidth() {
            return 150;
        }
    }

    private class PathTableColumn
    extends AbstractDynamicTableColumnStub<CheckoutInfo, String> {
        private PathTableColumn(FindCheckoutsTableModel findCheckoutsTableModel) {
        }

        public String getColumnName() {
            return "Pathname";
        }

        public String getValue(CheckoutInfo rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getFile().getParent().getPathname();
        }

        public int getColumnPreferredWidth() {
            return 100;
        }
    }

    private class CheckoutDateTableColumn
    extends AbstractDynamicTableColumnStub<CheckoutInfo, Date> {
        private CheckoutDateTableColumn(FindCheckoutsTableModel findCheckoutsTableModel) {
        }

        public String getColumnName() {
            return FindCheckoutsTableModel.CHECKOUT_DATE;
        }

        public Date getValue(CheckoutInfo rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
            return new Date(rowObject.getStatus().getCheckoutTime());
        }

        public int getColumnPreferredWidth() {
            return 150;
        }
    }

    private class VersionTableColumn
    extends AbstractDynamicTableColumnStub<CheckoutInfo, Integer> {
        private VersionTableColumn(FindCheckoutsTableModel findCheckoutsTableModel) {
        }

        public String getColumnName() {
            return "Version";
        }

        public Integer getValue(CheckoutInfo rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getStatus().getCheckoutVersion();
        }

        public int getColumnPreferredWidth() {
            return 70;
        }
    }
}

