/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.ContextSpecificAction;
import docking.action.MenuData;
import docking.widgets.tree.GTreeNode;
import ghidra.framework.main.datatable.ProjectTreeContext;
import ghidra.framework.main.datatree.DataTree;
import javax.swing.tree.TreePath;

public class ProjectDataExpandAction<T extends ProjectTreeContext>
extends ContextSpecificAction<T> {
    public ProjectDataExpandAction(String owner, String group, Class<T> contextClass) {
        super("Expand All", owner, contextClass);
        this.setPopupMenuData(new MenuData(new String[]{"Expand All"}, group));
        this.markHelpUnnecessary();
    }

    protected void actionPerformed(T context) {
        DataTree tree = context.getTree();
        TreePath[] paths = context.getSelectionPaths();
        this.expand(tree, paths[0]);
    }

    public boolean isAddToPopup(T context) {
        return context.getFolderCount() == 1 && context.getFileCount() == 0;
    }

    protected boolean isEnabledForContext(T context) {
        return context.getFolderCount() == 1 && context.getFileCount() == 0;
    }

    private void expand(DataTree tree, TreePath path) {
        tree.expandTree((GTreeNode)path.getLastPathComponent());
    }
}

