/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.wizard.project;

import docking.wizard.WizardModel;
import docking.wizard.WizardStep;
import ghidra.framework.main.wizard.project.ProjectWizardData;
import ghidra.framework.main.wizard.project.SelectProjectPanel;
import ghidra.framework.model.ProjectLocator;
import ghidra.util.HelpLocation;
import ghidra.util.NamingUtilities;
import java.io.File;
import javax.swing.JComponent;

public class SelectProjectStep
extends WizardStep<ProjectWizardData> {
    private SelectProjectPanel panel = new SelectProjectPanel(() -> this.notifyStatusChanged());

    protected SelectProjectStep(WizardModel<ProjectWizardData> model) {
        super(model, "", null);
    }

    public void initialize(ProjectWizardData data) {
        boolean isShared = data.isSharedProject();
        if (isShared) {
            String repositoryName = data.getRepositoryName();
            if (this.panel.getProjectName().isBlank()) {
                this.panel.setProjectName(repositoryName);
            }
            this.setTitle("Select Local Project Location for Repository \"" + repositoryName + "\"");
            this.setHelpLocation(new HelpLocation("FrontEndPlugin", "SelectProjectLocation"));
        } else {
            this.setTitle("Select Project Location");
            this.setHelpLocation(new HelpLocation("FrontEndPlugin", "CreateNonSharedProject"));
        }
    }

    public boolean isValid() {
        String dir = this.panel.getDirectoryName();
        String projectName = this.panel.getProjectName();
        return this.isValid(dir, projectName);
    }

    private boolean isValid(String dir, String projectName) {
        if (dir.isBlank()) {
            this.setStatusMessage("Please specify project directory");
            return false;
        }
        File projectDir = new File(dir);
        if (!projectDir.isDirectory()) {
            this.setStatusMessage("Project directory does not exist.");
            return false;
        }
        if (!NamingUtilities.isValidProjectName((String)projectName)) {
            this.setStatusMessage("Please specify valid project name");
            return false;
        }
        try {
            ProjectLocator locator = new ProjectLocator(dir, projectName);
            if (locator.getMarkerFile().exists() || locator.getProjectDir().exists()) {
                this.setStatusMessage("A project named " + locator.getName() + " already exists in " + projectDir.getAbsolutePath());
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            this.setStatusMessage(e.getMessage());
            return false;
        }
        return true;
    }

    public void populateData(ProjectWizardData data) {
        String dir = this.panel.getDirectoryName();
        String projectName = this.panel.getProjectName();
        data.setProjectLocator(new ProjectLocator(dir, projectName));
    }

    public boolean canFinish(ProjectWizardData data) {
        String dir;
        ProjectLocator projectLocator = data.getProjectLocator();
        if (projectLocator != null) {
            return true;
        }
        String name = data.getRepositoryName();
        if (data.isSharedProject() && name != null && this.isValid(dir = this.panel.getDirectoryName(), name)) {
            data.setProjectLocator(new ProjectLocator(dir, name));
            return true;
        }
        return false;
    }

    public boolean apply(ProjectWizardData data) {
        return true;
    }

    public JComponent getComponent() {
        return this.panel;
    }
}

