/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.util;

import ghidra.framework.plugintool.Plugin;
import java.util.ArrayList;
import java.util.List;

public class TransientToolState {
    private List<PluginState> states = new ArrayList<PluginState>();

    public TransientToolState(List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            Object state = plugin.getTransientState();
            if (state == null) continue;
            this.states.add(new PluginState(plugin, state));
        }
    }

    public void restoreTool() {
        for (PluginState ps : this.states) {
            ps.restore();
        }
    }

    private static class PluginState {
        private Plugin plugin;
        private Object state;

        PluginState(Plugin p, Object state) {
            this.plugin = p;
            this.state = state;
        }

        void restore() {
            if (!this.plugin.isDisposed()) {
                this.plugin.restoreTransientState(this.state);
            }
        }
    }
}

