/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project.extensions;

import docking.widgets.OkDialog;
import docking.widgets.OptionDialog;
import generic.jar.ResourceFile;
import ghidra.framework.Application;
import ghidra.util.Msg;
import ghidra.util.extensions.ExtensionDetails;
import ghidra.util.extensions.ExtensionUtils;
import ghidra.util.extensions.Extensions;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utility.application.ApplicationLayout;

public class ExtensionInstaller {
    private static final Logger log = LogManager.getLogger(ExtensionInstaller.class);

    public static boolean install(File file) {
        log.trace("Installing extension file " + String.valueOf(file));
        if (file == null) {
            log.error("Install file cannot be null");
            return false;
        }
        ExtensionDetails extension = ExtensionUtils.getExtension((File)file, (boolean)false);
        if (extension == null) {
            Msg.showError(ExtensionInstaller.class, null, (String)"Error Installing Extension", (Object)(file.getAbsolutePath() + " does not point to a valid ghidra extension"));
            return false;
        }
        Extensions extensions = ExtensionUtils.getAllInstalledExtensions();
        if (ExtensionInstaller.checkForConflictWithDevelopmentExtension(extension, extensions)) {
            return false;
        }
        if (ExtensionInstaller.checkForDuplicateExtensions(extension, extensions)) {
            return false;
        }
        if (!ExtensionInstaller.validateExtensionVersion(extension)) {
            return false;
        }
        AtomicBoolean installed = new AtomicBoolean(false);
        TaskLauncher.launchModal((String)"Installing Extension", monitor -> installed.set(ExtensionUtils.install((ExtensionDetails)extension, (File)file, (TaskMonitor)monitor)));
        boolean success = installed.get();
        if (success) {
            log.trace("Finished installing " + String.valueOf(file));
        } else {
            log.trace("Failed to install " + String.valueOf(file));
        }
        return success;
    }

    public static boolean installExtensionFromArchive(ExtensionDetails extension) {
        if (extension == null) {
            log.error("Extension to install cannot be null");
            return false;
        }
        String archivePath = extension.getArchivePath();
        if (archivePath == null) {
            log.error("Cannot install from archive; extension is missing archive path");
            return false;
        }
        ApplicationLayout layout = Application.getApplicationLayout();
        ResourceFile extInstallDir = (ResourceFile)layout.getExtensionInstallationDirs().get(0);
        String extName = extension.getName();
        File extDestinationDir = new ResourceFile(extInstallDir, extName).getFile(false);
        File archiveFile = new File(archivePath);
        if (ExtensionInstaller.install(archiveFile)) {
            extension.setInstallDir(new File(extDestinationDir, extName));
            return true;
        }
        return false;
    }

    private static boolean validateExtensionVersion(ExtensionDetails extension) {
        String appVersion;
        String extVersion = extension.getVersion();
        if (extVersion == null) {
            extVersion = "<no version>";
        }
        if (extVersion.equals(appVersion = Application.getApplicationVersion())) {
            return true;
        }
        String message = "Extension version mismatch.\nName: " + extension.getName() + "Extension version: " + extVersion + ".\nGhidra version: " + appVersion + ".";
        int choice = OptionDialog.showOptionDialogWithCancelAsDefaultButton(null, (String)"Extension Version Mismatch", (String)message, (String)"Install Anyway");
        if (choice != 1) {
            log.info(ExtensionInstaller.removeNewlines(message + " Did not install"));
            return false;
        }
        return true;
    }

    private static String removeNewlines(String s) {
        return s.replaceAll("\n", " ");
    }

    private static boolean checkForDuplicateExtensions(ExtensionDetails newExtension, Extensions extensions) {
        String name = newExtension.getName();
        log.trace("Checking for duplicate extensions for '" + name + "'");
        List matches = extensions.getMatchingExtensions(newExtension);
        if (matches.isEmpty()) {
            log.trace("No matching extensions installed");
            return false;
        }
        log.trace("Duplicate extensions found by name '" + name + "'");
        if (matches.size() > 1) {
            ExtensionInstaller.reportMultipleDuplicateExtensionsWhenInstalling(newExtension, matches);
            return true;
        }
        ExtensionDetails installedExtension = (ExtensionDetails)matches.get(0);
        String message = "Attempting to install an extension matching the name of an existing extension.\nNew extension version: " + newExtension.getVersion() + ".\nInstalled extension version: " + installedExtension.getVersion() + ".\n\nTo install, click 'Remove Existing', restart Ghidra, then install again.";
        int choice = OptionDialog.showOptionDialogWithCancelAsDefaultButton(null, (String)"Duplicate Extension", (String)message, (String)"Remove Existing");
        String installPath = installedExtension.getInstallPath();
        if (choice != 1) {
            log.info(ExtensionInstaller.removeNewlines(message + " Skipping installation. Original extension still installed: " + installPath));
            return true;
        }
        log.info(ExtensionInstaller.removeNewlines(message + " Installing new extension. Existing extension will be removed after restart: " + installPath));
        installedExtension.markForUninstall();
        return true;
    }

    private static void reportMultipleDuplicateExtensionsWhenInstalling(ExtensionDetails extension, List<ExtensionDetails> matches) {
        StringBuilder buffy = new StringBuilder();
        buffy.append("Found multiple duplicate extensions while trying to install '").append(extension.getName()).append("'\n");
        for (ExtensionDetails otherExtension : matches) {
            buffy.append("Duplicate: " + otherExtension.getInstallPath()).append('\n');
        }
        buffy.append("Please close Ghidra and manually remove from these extensions from the filesystem.");
        Msg.showInfo(ExtensionInstaller.class, null, (String)"Duplicate Extensions Found", (Object)buffy.toString());
    }

    private static boolean checkForConflictWithDevelopmentExtension(ExtensionDetails newExtension, Extensions extensions) {
        String name = newExtension.getName();
        log.trace("Checking for duplicate dev mode extensions for '" + name + "'");
        List matches = extensions.getMatchingExtensions(newExtension);
        if (matches.isEmpty()) {
            log.trace("No matching extensions installed");
            return false;
        }
        for (ExtensionDetails extension : matches) {
            if (!extension.isInstalledInInstallationFolder()) continue;
            String message = "Attempting to install an extension that conflicts with an extension located in the Ghidra installation folder.\nYou must manually remove the existing extension to install the new extension.\nExisting extension: " + String.valueOf(extension.getInstallDir());
            log.trace(ExtensionInstaller.removeNewlines(message));
            OkDialog.showError((String)"Duplicate Extensions Found", (String)message);
            return true;
        }
        return false;
    }
}

