/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.taint.lib;

import ghidra.pcode.emu.sys.BytesEmuFileContents;
import ghidra.pcode.emu.sys.EmuFileContents;
import ghidra.pcode.emu.sys.EmuIOException;
import ghidra.pcode.emu.sys.PairedEmuFileContents;
import ghidra.pcode.emu.unix.AbstractEmuUnixFile;
import ghidra.pcode.emu.unix.AbstractEmuUnixFileSystem;
import ghidra.pcode.emu.unix.EmuUnixFile;
import ghidra.pcode.emu.unix.EmuUnixFileStat;
import ghidra.taint.model.TaintVec;
import org.apache.commons.lang3.tuple.Pair;

public class TaintEmuUnixFileSystem
extends AbstractEmuUnixFileSystem<Pair<byte[], TaintVec>> {
    public AbstractEmuUnixFile<Pair<byte[], TaintVec>> newFile(String pathname, int mode) throws EmuIOException {
        return new TaintEmuUnixFile(pathname, mode);
    }

    public void putTaintedFile(String pathname, byte[] contents) {
        TaintEmuUnixFile file = new TaintEmuUnixFile(pathname, 511);
        file.setTainted(true);
        EmuUnixFileStat stat = file.getStat();
        file.concrete.write(0L, contents, stat.st_size);
        stat.st_size = contents.length;
        this.putFile(pathname, (EmuUnixFile)file);
    }

    public static class TaintEmuUnixFile
    extends AbstractEmuUnixFile<Pair<byte[], TaintVec>> {
        protected BytesEmuFileContents concrete = new BytesEmuFileContents();

        public TaintEmuUnixFile(String pathname, int mode) {
            super(pathname, mode);
        }

        protected EmuFileContents<Pair<byte[], TaintVec>> createDefaultContents() {
            return new PairedEmuFileContents((EmuFileContents)this.concrete, (EmuFileContents)new UntaintedFileContents());
        }

        public void setTainted(boolean tainted) {
            this.contents = new PairedEmuFileContents((EmuFileContents)this.concrete, (EmuFileContents)new ReadOnlyTaintArrayFileContents(this.pathname));
        }
    }

    public static class ReadOnlyTaintArrayFileContents
    implements EmuFileContents<TaintVec> {
        private final String filename;

        public ReadOnlyTaintArrayFileContents(String filename) {
            this.filename = filename;
        }

        public long read(long offset, TaintVec buf, long fileSize) {
            buf.setArray(this.filename, offset);
            return buf.length;
        }

        public long write(long offset, TaintVec buf, long curSize) {
            return 0L;
        }

        public void truncate() {
        }
    }

    public static class UntaintedFileContents
    implements EmuFileContents<TaintVec> {
        public long read(long offset, TaintVec buf, long fileSize) {
            buf.setEmpties();
            return buf.length;
        }

        public long write(long offset, TaintVec buf, long curSize) {
            return 0L;
        }

        public void truncate() {
        }
    }
}

