/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.ToolBarData;
import docking.widgets.fieldpanel.support.ViewerPosition;
import generic.theme.GIcon;
import ghidra.app.events.AbstractHighlightPluginEvent;
import ghidra.app.events.AbstractLocationPluginEvent;
import ghidra.app.events.AbstractSelectionPluginEvent;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramHighlightPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.nav.DecoratorPanel;
import ghidra.app.nav.LocationMemento;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigatableIconFactory;
import ghidra.app.nav.NavigatableRegistry;
import ghidra.app.nav.NavigatableRemovalListener;
import ghidra.app.plugin.core.byteviewer.AbstractByteViewerPlugin;
import ghidra.app.plugin.core.byteviewer.ByteBlockChangeManager;
import ghidra.app.plugin.core.byteviewer.ByteBlockChangePluginEvent;
import ghidra.app.plugin.core.byteviewer.ByteViewerActionContext;
import ghidra.app.plugin.core.byteviewer.ByteViewerClipboardProvider;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponent;
import ghidra.app.plugin.core.byteviewer.ByteViewerComponentProvider;
import ghidra.app.plugin.core.byteviewer.ByteViewerLocationMemento;
import ghidra.app.plugin.core.byteviewer.ByteViewerProgramLocation;
import ghidra.app.plugin.core.byteviewer.ByteViewerState;
import ghidra.app.plugin.core.byteviewer.ProgramByteBlockSet;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockInfo;
import ghidra.app.plugin.core.format.ByteBlockSelection;
import ghidra.app.plugin.core.format.ByteEditInfo;
import ghidra.app.plugin.core.format.DataFormatModel;
import ghidra.app.plugin.core.format.ProgramDataFormatModel;
import ghidra.app.services.ClipboardContentProviderService;
import ghidra.app.services.ClipboardService;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramEvent;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ProgramByteViewerComponentProvider
extends ByteViewerComponentProvider
implements DomainObjectListener,
Navigatable {
    private ImageIcon navigatableIcon;
    protected DecoratorPanel decorationComponent;
    private WeakSet<NavigatableRemovalListener> navigationListeners = WeakDataStructureFactory.createCopyOnWriteWeakSet();
    private CloneByteViewerAction cloneByteViewerAction;
    protected Program program;
    protected ProgramSelection currentSelection;
    protected ProgramSelection liveSelection;
    protected ProgramSelection currentHighlight;
    protected ProgramLocation currentLocation;
    private ClipboardService clipboardService;
    private ByteViewerClipboardProvider clipboardProvider;
    private final boolean isConnected;
    private boolean disposed;

    public ProgramByteViewerComponentProvider(PluginTool tool, AbstractByteViewerPlugin<?> plugin, boolean isConnected) {
        this(tool, plugin, "Bytes", isConnected);
    }

    protected ProgramByteViewerComponentProvider(PluginTool tool, AbstractByteViewerPlugin<?> plugin, String name, boolean isConnected) {
        super(tool, plugin, name, ByteViewerActionContext.class);
        this.isConnected = isConnected;
        this.setIcon((Icon)new GIcon("icon.plugin.byteviewer.provider"));
        if (!isConnected) {
            this.setTransient();
        } else {
            this.addToToolbar();
        }
        this.decorationComponent = new DecoratorPanel((JComponent)this.panel, isConnected);
        this.clipboardProvider = this.newClipboardProvider();
        this.addToTool();
        this.createProgramActions();
        this.updateTitle();
        this.registerNavigatable();
    }

    protected ByteViewerClipboardProvider newClipboardProvider() {
        return new ByteViewerClipboardProvider(this, this.tool);
    }

    public void createProgramActions() {
        this.cloneByteViewerAction = new CloneByteViewerAction();
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.cloneByteViewerAction);
    }

    public boolean isSnapshot() {
        return !this.isConnected();
    }

    @Override
    public JComponent getComponent() {
        return this.decorationComponent;
    }

    public String getWindowGroup() {
        if (this.isConnected()) {
            return "";
        }
        return "disconnected";
    }

    public void componentShown() {
        this.panel.refreshView();
        if (this.currentLocation != null) {
            this.setLocation(this.currentLocation);
        }
        if (this.currentSelection != null) {
            this.setSelection(this.currentSelection, false);
        }
    }

    public ActionContext getActionContext(MouseEvent event) {
        ByteBlockInfo info = this.panel.getCursorLocation();
        if (info == null) {
            return null;
        }
        return this.newByteViewerActionContext();
    }

    protected ByteViewerActionContext newByteViewerActionContext() {
        return new ByteViewerActionContext(this);
    }

    public void closeComponent() {
        super.closeComponent();
        this.plugin.closeProvider(this);
    }

    public void setSelection(ProgramSelection selection) {
        this.setSelection(selection, true);
    }

    public ProgramSelection getSelection() {
        return this.currentSelection;
    }

    public ProgramSelection getHighlight() {
        return this.currentHighlight;
    }

    public String getTextSelection() {
        return this.getCurrentTextSelection();
    }

    protected void setSelection(ProgramSelection selection, boolean notify) {
        this.liveSelection = null;
        this.currentSelection = selection;
        this.updateTitle();
        if (selection == null) {
            return;
        }
        if (!this.tool.isVisible((ComponentProvider)this)) {
            return;
        }
        ByteBlockSelection blockSelection = this.blockSet.getBlockSelection(selection);
        this.clipboardProvider.setSelection(this.currentSelection);
        this.panel.setViewerSelection(blockSelection);
        if (notify) {
            AbstractSelectionPluginEvent selectionEvent = this.blockSet.getPluginEvent(this.getName(), blockSelection);
            this.plugin.updateSelection(this, selectionEvent, this.program);
        }
        this.contextChanged();
    }

    public boolean supportsHighlight() {
        return true;
    }

    public void setHighlight(ProgramSelection newHighlight) {
        this.currentHighlight = newHighlight;
        if (newHighlight == null) {
            return;
        }
        if (!this.tool.isVisible((ComponentProvider)this)) {
            return;
        }
        ByteBlockSelection highlight = this.blockSet.getBlockSelection(this.currentHighlight);
        this.panel.setViewerHighlight(highlight);
        this.contextChanged();
        this.plugin.highlightChanged(this, newHighlight);
    }

    void enablePaste(boolean enabled) {
        this.clipboardProvider.setPasteEnabled(enabled);
    }

    protected void doSetProgram(Program newProgram) {
        this.setOptionsAction.setEnabled(newProgram != null);
        this.cloneByteViewerAction.setEnabled(newProgram != null);
        if (this.program != null) {
            this.program.removeListener((DomainObjectListener)this);
        }
        this.program = newProgram;
        this.clipboardProvider.setProgram(newProgram);
        for (ByteViewerComponent byteViewerComponent : this.viewMap.values()) {
            DataFormatModel dataModel = byteViewerComponent.getDataModel();
            if (!(dataModel instanceof ProgramDataFormatModel)) continue;
            ((ProgramDataFormatModel)dataModel).setProgram(newProgram);
        }
        if (newProgram != null) {
            newProgram.addListener((DomainObjectListener)this);
        }
        this.setByteBlocks(null);
        this.updateTitle();
    }

    protected void updateTitle() {
        String title = "Bytes: " + (this.program == null ? "No Program" : this.program.getDomainFile().getName());
        if (!this.isConnected()) {
            title = "[" + title + "]";
        }
        this.setTitle(title);
        this.updateSubTitle();
    }

    private void updateSubTitle() {
        ProgramSelection selection = this.liveSelection != null ? this.liveSelection : this.currentSelection;
        Object selectionInfo = null;
        if (selection != null && !selection.isEmpty()) {
            long n = selection.getNumAddresses();
            String nString = Long.toString(n);
            selectionInfo = n == 1L ? "(1 byte selected)" : "(" + nString + " bytes selected)";
        }
        this.setSubTitle((String)selectionInfo);
    }

    public ProgramLocation getLocation() {
        return this.currentLocation;
    }

    public Program getProgram() {
        return this.program;
    }

    public boolean goTo(Program gotoProgram, ProgramLocation location) {
        if (gotoProgram != this.program) {
            if (!this.isConnected()) {
                this.tool.setStatusInfo("Program location not applicable for this provider!");
                return false;
            }
            ProgramManager programManagerService = (ProgramManager)this.tool.getService(ProgramManager.class);
            if (programManagerService != null) {
                programManagerService.setCurrentProgram(gotoProgram);
            }
        }
        this.setLocation(location, false);
        return true;
    }

    public LocationMemento getMemento() {
        ByteBlockInfo info = this.panel.getCursorLocation();
        int blockNumber = -1;
        BigInteger blockOffset = null;
        int column = 0;
        if (info != null) {
            blockNumber = this.getBlockNumber(info);
            blockOffset = info.getOffset();
            column = info.getColumn();
        }
        ViewerPosition vp = this.panel.getViewerPosition();
        return new ByteViewerLocationMemento(this.program, this.currentLocation, blockNumber, blockOffset, column, vp);
    }

    public void setMemento(LocationMemento memento) {
        ByteViewerLocationMemento bvMemento = (ByteViewerLocationMemento)memento;
        int blockNumber = bvMemento.getBlockNum();
        BigInteger blockOffset = bvMemento.getBlockOffset();
        ViewerPosition vp = bvMemento.getViewerPosition();
        int column = bvMemento.getColumn();
        ByteBlock[] blocks = this.getByteBlocks();
        if (blocks != null && blockNumber >= 0 && blockNumber < blocks.length) {
            ByteViewerState view = new ByteViewerState(this.blockSet, new ByteBlockInfo(blocks[blockNumber], blockOffset, column), vp);
            this.panel.restoreView(view);
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean supportsMarkers() {
        return this.isConnected;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public Icon getIcon() {
        if (this.isConnected()) {
            return this.getBaseIcon();
        }
        if (this.navigatableIcon == null) {
            Icon primaryIcon = this.getBaseIcon();
            this.navigatableIcon = NavigatableIconFactory.createSnapshotOverlayIcon((Icon)primaryIcon);
        }
        return this.navigatableIcon;
    }

    public Icon getNavigatableIcon() {
        return this.getIcon();
    }

    public boolean isVisible() {
        return this.tool.isVisible((ComponentProvider)this);
    }

    private void setLocation(ProgramLocation location, boolean fireEvent) {
        CodeUnit cu;
        this.currentLocation = location;
        if (location == null) {
            return;
        }
        if (!this.tool.isVisible((ComponentProvider)this)) {
            return;
        }
        this.clipboardProvider.setLocation(location);
        Address address = location.getByteAddress();
        if (!this.program.getMemory().contains(address) && (cu = this.program.getListing().getCodeUnitAfter(address)) != null) {
            address = cu.getMinAddress();
        }
        if (address == null) {
            return;
        }
        ByteBlockInfo byteBlockInfo = this.blockSet.getByteBlockInfo(address);
        if (byteBlockInfo == null) {
            return;
        }
        ByteBlock block = byteBlockInfo.getBlock();
        BigInteger blockOffset = byteBlockInfo.getOffset();
        int column = 0;
        if (location instanceof ByteViewerProgramLocation) {
            column = location.getCharOffset();
        }
        this.panel.setCursorLocation(block, blockOffset, column);
        Address blockSetAddress = this.blockSet.getAddress(block, blockOffset);
        if (blockSetAddress == null) {
            return;
        }
        this.currentLocation = this.getLocation(block, blockOffset, column);
        if (fireEvent && this.tool.isVisible((ComponentProvider)this)) {
            this.updateLocation(block, blockOffset, column, false);
            this.plugin.fireProgramLocationPluginEvent(this, this.blockSet.getPluginEvent(this.getName(), block, blockOffset, column));
        } else {
            this.contextChanged();
        }
    }

    protected ProgramLocation getLocation(ByteBlock block, BigInteger offset, int column) {
        Address address = this.blockSet.getAddress(block, offset);
        int characterOffset = column;
        ByteViewerProgramLocation loc = new ByteViewerProgramLocation(this.program, address, characterOffset);
        return loc;
    }

    protected void setLocation(ProgramLocation location) {
        this.setLocation(location, false);
    }

    void memoryConfigurationChanged() {
        ProgramLocation location = this.currentLocation;
        ProgramSelection selection = this.currentSelection;
        ByteBlockChangeManager bbcm = null;
        if (this.blockSet != null) {
            bbcm = this.blockSet.getByteBlockChangeManager();
        }
        this.setByteBlocks(bbcm);
        if (!this.tool.isVisible((ComponentProvider)this)) {
            return;
        }
        this.setLocation(location, true);
        this.setSelection(selection, true);
    }

    void doHandleEvent(PluginEvent event) {
        if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent ev = (ProgramActivatedPluginEvent)event;
            Program newProgram = ev.getActiveProgram();
            this.doSetProgram(newProgram);
            this.setLocation(null);
            this.setSelection(null, false);
            return;
        }
        ByteBlock[] blocks = this.getByteBlocks();
        if (blocks == null) {
            return;
        }
        if (event instanceof ByteBlockChangePluginEvent) {
            this.blockSet.processByteBlockChangeEvent((ByteBlockChangePluginEvent)event);
        } else if (event instanceof ProgramLocationPluginEvent) {
            ProgramLocationPluginEvent ev = (ProgramLocationPluginEvent)event;
            this.processLocationEvent((AbstractLocationPluginEvent)ev);
        } else if (event instanceof ProgramSelectionPluginEvent) {
            ProgramSelectionPluginEvent ev = (ProgramSelectionPluginEvent)event;
            this.processSelectionEvent((AbstractSelectionPluginEvent)ev);
        } else if (event instanceof ProgramHighlightPluginEvent) {
            this.processHighlightEvent((AbstractHighlightPluginEvent)((ProgramHighlightPluginEvent)event));
        }
    }

    protected void processHighlightEvent(AbstractHighlightPluginEvent event) {
        ProgramSelection programSelection = event.getHighlight();
        this.setHighlight(programSelection);
    }

    protected void processSelectionEvent(AbstractSelectionPluginEvent event) {
        ProgramSelection programSelection = event.getSelection();
        this.setSelection(programSelection);
    }

    protected void processLocationEvent(AbstractLocationPluginEvent event) {
        ProgramLocation loc = event.getLocation();
        this.setLocation(loc);
    }

    public void notifyEdit(ByteEditInfo edit) {
        if (this.tool.isVisible((ComponentProvider)this)) {
            this.plugin.firePluginEvent(new ByteBlockChangePluginEvent(this.plugin.getName(), edit, this.program));
        }
    }

    ProgramLocation getCurrentLocation() {
        return this.currentLocation;
    }

    ProgramSelection getCurrentSelection() {
        return this.currentSelection;
    }

    String getCurrentTextSelection() {
        return this.panel.getCurrentComponent().getTextForSelection();
    }

    public void domainObjectChanged(DomainObjectChangedEvent event) {
        if (this.blockSet != null && event.contains(new EventType[]{DomainObjectEvent.SAVED, DomainObjectEvent.FILE_CHANGED})) {
            this.blockSet.setByteBlockChangeManager(this.newByteBlockChangeManager(this.blockSet, null));
            this.updateManager.update();
        }
        if (event.contains(new EventType[]{DomainObjectEvent.RESTORED, ProgramEvent.MEMORY_BLOCK_CHANGED, ProgramEvent.MEMORY_BLOCK_ADDED, ProgramEvent.MEMORY_BLOCK_MOVED, ProgramEvent.MEMORY_BLOCK_REMOVED, ProgramEvent.MEMORY_BLOCKS_JOINED, ProgramEvent.MEMORY_BLOCK_SPLIT})) {
            this.memoryConfigurationChanged();
            return;
        }
        if (event.contains(new EventType[]{ProgramEvent.MEMORY_BYTES_CHANGED, ProgramEvent.CODE_ADDED, ProgramEvent.REFERENCE_ADDED})) {
            this.updateManager.update();
        }
    }

    protected ByteBlockChangeManager newByteBlockChangeManager(ProgramByteBlockSet blocks, ByteBlockChangeManager bbcm) {
        return new ByteBlockChangeManager(blocks, bbcm);
    }

    protected ProgramByteBlockSet newByteBlockSet(ByteBlockChangeManager changeManager) {
        if (this.program == null) {
            return null;
        }
        return new ProgramByteBlockSet(this, this.program, changeManager);
    }

    protected void setByteBlocks(ByteBlockChangeManager changeManager) {
        if (this.blockSet != null) {
            this.blockSet.dispose();
        }
        this.blockSet = this.newByteBlockSet(changeManager);
        this.panel.setByteBlocks(this.blockSet);
    }

    @Override
    protected void updateSelection(ByteBlockSelection selection) {
        AbstractSelectionPluginEvent event = this.blockSet.getPluginEvent(this.plugin.getName(), selection);
        this.liveSelection = null;
        this.currentSelection = event.getSelection();
        this.plugin.updateSelection(this, event, this.program);
        this.clipboardProvider.setSelection(this.currentSelection);
        this.updateTitle();
        this.contextChanged();
    }

    @Override
    protected void updateLiveSelection(ByteBlockSelection selection) {
        AbstractSelectionPluginEvent event = this.blockSet.getPluginEvent(this.plugin.getName(), selection);
        this.liveSelection = event.getSelection();
        this.updateTitle();
    }

    @Override
    protected void updateLocation(ByteBlock block, BigInteger blockOffset, int column, boolean export) {
        AbstractLocationPluginEvent event = this.blockSet.getPluginEvent(this.plugin.getName(), block, blockOffset, column);
        this.currentLocation = event.getLocation();
        this.plugin.updateLocation(this, event, export);
        this.clipboardProvider.setLocation(this.currentLocation);
        this.contextChanged();
    }

    protected void readDataState(SaveState saveState) {
        this.unRegisterNavigatable();
        this.initializeInstanceID(saveState.getLong("NAV_ID", this.getInstanceID()));
        this.registerNavigatable();
        this.restoreLocation(saveState);
    }

    void restoreLocation(SaveState saveState) {
        int blockNumber = saveState.getInt("Block Num", 0);
        BigInteger blockOffset = new BigInteger(saveState.getString("Block Offset", "0"));
        int column = saveState.getInt("Block Column", 0);
        int index = saveState.getInt("Index", 0);
        int xOffset = saveState.getInt("X Offset", 0);
        int yOffset = saveState.getInt("Y Offset", 0);
        ViewerPosition vp = new ViewerPosition(index, xOffset, yOffset);
        ByteBlock[] blocks = this.getByteBlocks();
        if (blocks != null && blockNumber >= 0 && blockNumber < blocks.length) {
            ByteViewerState view = new ByteViewerState(this.blockSet, new ByteBlockInfo(blocks[blockNumber], blockOffset, column), vp);
            this.panel.restoreView(view);
        }
    }

    Object getUndoRedoState(DomainObject domainObject) {
        if (this.program != domainObject || this.blockSet == null) {
            return null;
        }
        return this.blockSet.getUndoRedoState();
    }

    void restoreUndoRedoState(DomainObject domainObject, Object state) {
        if (this.program != domainObject || this.blockSet == null) {
            return;
        }
        SaveState saveState = (SaveState)state;
        this.blockSet.restoreUndoRedoState(saveState);
    }

    protected void writeDataState(SaveState saveState) {
        saveState.putLong("NAV_ID", this.getInstanceID());
        ByteBlockInfo info = this.panel.getCursorLocation();
        int blockNumber = -1;
        String blockOffset = "0";
        int column = 0;
        if (info != null) {
            blockNumber = this.getBlockNumber(info);
            blockOffset = info.getOffset().toString();
            column = info.getColumn();
        }
        saveState.putInt("Block Num", blockNumber);
        saveState.putString("Block Offset", blockOffset);
        saveState.putInt("Block Column", column);
        ViewerPosition vp = this.panel.getViewerPosition();
        saveState.putInt("Index", vp.getIndexAsInt());
        saveState.putInt("X Offset", vp.getXOffset());
        saveState.putInt("Y Offset", vp.getYOffset());
    }

    private int getBlockNumber(ByteBlockInfo info) {
        ByteBlock[] blocks = this.getByteBlocks();
        ByteBlock b = info.getBlock();
        for (int i = 0; i < blocks.length; ++i) {
            if (blocks[i] != b) continue;
            return i;
        }
        return -1;
    }

    @Override
    public DataFormatModel getDataFormatModel(String formatName) {
        DataFormatModel dataFormatModel = super.getDataFormatModel(formatName);
        if (dataFormatModel instanceof ProgramDataFormatModel) {
            ((ProgramDataFormatModel)dataFormatModel).setProgram(this.program);
        }
        return dataFormatModel;
    }

    @Override
    void setEditMode(boolean isEditable) {
        super.setEditMode(isEditable);
        this.enablePaste(isEditable);
    }

    @Override
    void dispose() {
        if (this.program != null) {
            this.program.removeListener((DomainObjectListener)this);
        }
        this.program = null;
        this.setByteBlocks(null);
        if (this.clipboardService != null) {
            this.clipboardService.deRegisterClipboardContentProvider((ClipboardContentProviderService)this.clipboardProvider);
        }
        this.disposed = true;
        this.unRegisterNavigatable();
        super.dispose();
    }

    @Override
    protected Set<DataFormatModel> getDataFormatModels() {
        Set<DataFormatModel> dataFormatModels = super.getDataFormatModels();
        List instances = ClassSearcher.getInstances(ProgramDataFormatModel.class);
        dataFormatModels.addAll(instances);
        return dataFormatModels;
    }

    public void cloneWindow() {
        Object newProvider = this.plugin.createNewDisconnectedProvider();
        SaveState saveState = new SaveState();
        this.writeConfigState(saveState);
        ((ByteViewerComponentProvider)((Object)newProvider)).readConfigState(saveState);
        ((ProgramByteViewerComponentProvider)((Object)newProvider)).doSetProgram(this.program);
        ((ProgramByteViewerComponentProvider)((Object)newProvider)).setLocation(this.currentLocation);
        ((ProgramByteViewerComponentProvider)((Object)newProvider)).setSelection(this.currentSelection, false);
        ((ProgramByteViewerComponentProvider)((Object)newProvider)).setHighlight(this.currentHighlight);
        ViewerPosition viewerPosition = this.panel.getViewerPosition();
        ((ProgramByteViewerComponentProvider)((Object)newProvider)).panel.setViewerPosition(viewerPosition);
    }

    public void addNavigatableListener(NavigatableRemovalListener listener) {
        this.navigationListeners.add((Object)listener);
    }

    public void removeNavigatableListener(NavigatableRemovalListener listener) {
        this.navigationListeners.remove((Object)listener);
    }

    void registerNavigatable() {
        NavigatableRegistry.registerNavigatable((PluginTool)this.tool, (Navigatable)this);
    }

    void unRegisterNavigatable() {
        NavigatableRegistry.unregisterNavigatable((PluginTool)this.tool, (Navigatable)this);
        for (NavigatableRemovalListener listener : this.navigationListeners) {
            listener.navigatableRemoved((Navigatable)this);
        }
    }

    void setClipboardService(ClipboardService service) {
        this.clipboardService = service;
        if (this.clipboardService != null) {
            this.clipboardService.registerClipboardContentProvider((ClipboardContentProviderService)this.clipboardProvider);
        }
    }

    public void removeHighlightProvider(ListingHighlightProvider highlightProvider, Program p) {
    }

    public void setHighlightProvider(ListingHighlightProvider highlightProvider, Program p) {
    }

    private class CloneByteViewerAction
    extends DockingAction {
        public CloneByteViewerAction() {
            super("ByteViewer Clone", ProgramByteViewerComponentProvider.this.plugin.getName());
            GIcon image = new GIcon("icon.provider.clone");
            this.setToolBarData(new ToolBarData((Icon)image, "ZZZ"));
            this.setDescription("Create a snapshot (disconnected) copy of this Bytes window ");
            this.setHelpLocation(new HelpLocation("Snapshots", "Snapshots_Start"));
            this.setKeyBindingData(new KeyBindingData(84, 192));
        }

        public void actionPerformed(ActionContext context) {
            ProgramByteViewerComponentProvider.this.cloneWindow();
        }
    }
}

