/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.disassemble;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.program.disassemble.DisassemblerContextImpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;

public class ArmDisassembleCommand
extends DisassembleCommand {
    private boolean thumbMode;

    public ArmDisassembleCommand(AddressSetView startSet, AddressSetView restrictedSet, boolean thumbMode) {
        super("Disassemble " + (thumbMode ? "Thumb" : "Arm"), startSet, restrictedSet, true);
        this.thumbMode = thumbMode;
    }

    public ArmDisassembleCommand(Address start, AddressSetView restrictedSet, boolean thumbMode) {
        this((AddressSetView)new AddressSet(start, start), restrictedSet, thumbMode);
        this.useDefaultRepeatPatternBehavior = true;
    }

    @Override
    public void setSeedContext(DisassemblerContextImpl seedContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInitialContext(RegisterValue initialContextValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean applyTo(Program program, TaskMonitor monitor) {
        this.disassemblyPerformed = false;
        this.unalignedStart = false;
        Register tmodeReg = program.getProgramContext().getRegister("TMode");
        RegisterValue tmodeValue = null;
        if (tmodeReg == null) {
            if (this.thumbMode) {
                return false;
            }
        } else {
            tmodeValue = new RegisterValue(tmodeReg, BigInteger.valueOf(this.thumbMode ? 1L : 0L));
            super.setInitialContext(tmodeValue);
        }
        int alignment = this.thumbMode ? 2 : 4;
        long alignMask = this.thumbMode ? -2L : -4L;
        try {
            if (this.startSet != null) {
                AddressSet alignedSet = new AddressSet();
                for (AddressRange range : this.startSet) {
                    Address max;
                    long maxOffset;
                    Address min = range.getMinAddress();
                    long minOfffset = min.getOffset() & alignMask;
                    if (minOfffset != min.getOffset()) {
                        min = min.getNewAddress(minOfffset);
                    }
                    if ((maxOffset = (max = range.getMaxAddress()).getOffset() & alignMask) < minOfffset) continue;
                    if (maxOffset != max.getOffset()) {
                        max = max.getNewAddress(maxOffset);
                    }
                    alignedSet.addRange(min, max);
                }
                if (alignedSet.isEmpty()) {
                    this.unalignedStart = true;
                    return false;
                }
                this.startSet = program.getListing().getUndefinedRanges((AddressSetView)alignedSet, true, monitor);
                if (this.startSet.isEmpty()) {
                    return true;
                }
            }
        }
        catch (CancelledException e) {
            return true;
        }
        return this.doDisassembly(monitor, program, alignment);
    }
}

