/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.module;

import ghidra.framework.cmd.Command;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.Msg;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.exception.NotFoundException;

public class MergeFolderCmd
implements Command<Program> {
    private String treeName;
    private String folderName;
    private String parentName;
    private String errMsg;

    public MergeFolderCmd(String treeName, String folderName, String parentName) {
        this.treeName = treeName;
        this.folderName = folderName;
        this.parentName = parentName;
    }

    public boolean applyTo(Program program) {
        Group[] groups;
        Listing listing = program.getListing();
        ProgramModule parentModule = listing.getModule(this.treeName, this.parentName);
        ProgramModule module = listing.getModule(this.treeName, this.folderName);
        if (parentModule == null || module == null) {
            return true;
        }
        for (Group group : groups = module.getChildren()) {
            String name = group.getName();
            ProgramModule m = listing.getModule(this.treeName, name);
            ProgramFragment f = null;
            try {
                if (m != null && parentModule.contains(m)) {
                    module.removeChild(name);
                    continue;
                }
                if (m == null && parentModule.contains(f = listing.getFragment(this.treeName, name))) {
                    module.removeChild(name);
                    continue;
                }
                parentModule.reparent(name, module);
            }
            catch (NotEmptyException e) {
                Msg.showError((Object)this, null, (String)"Error", (Object)"Error merging folder with its parent");
            }
            catch (NotFoundException e) {
                Msg.showError((Object)this, null, (String)"Error", (Object)"Error merging folder with its parent");
            }
        }
        try {
            ProgramModule[] parents;
            ProgramModule m = listing.getModule(this.treeName, this.folderName);
            for (ProgramModule parent : parents = m.getParents()) {
                parent.removeChild(this.folderName);
            }
            return true;
        }
        catch (NotEmptyException e) {
            this.errMsg = e.getMessage();
            return false;
        }
    }

    public String getStatusMsg() {
        return this.errMsg;
    }

    public String getName() {
        return "Merge " + this.folderName + " with Parent";
    }
}

