/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import docking.widgets.button.GRadioButton;
import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.GTable;
import ghidra.app.merge.listing.ListChoiceTable;
import ghidra.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;

class ListChoice
extends JPanel {
    JRadioButton rb;
    private String[] headings = new String[0];
    private List<String[]> data;
    private AbstractSortedTableModel<String[]> model;
    private GTable table;

    ListChoice(ButtonGroup group, ItemListener radioButtonListener) {
        this.setLayout(new BorderLayout());
        this.rb = new GRadioButton("UNKNOWN");
        this.rb.addItemListener(radioButtonListener);
        group.add(this.rb);
        this.add((Component)this.rb, "North");
        this.model = new AbstractSortedTableModel<String[]>(){

            public Object getColumnValueForRow(String[] t, int columnIndex) {
                return t[columnIndex];
            }

            public String getName() {
                return "Choice Panel";
            }

            public String getColumnName(int column) {
                return ListChoice.this.headings[column];
            }

            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }

            public List<String[]> getModelData() {
                return ListChoice.this.data;
            }

            public int getColumnCount() {
                return ListChoice.this.headings.length;
            }

            public boolean isSortable(int columnIndex) {
                return true;
            }
        };
        this.table = new ListChoiceTable((TableModel)this.model);
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setFocusable(false);
        JScrollPane scrollPane = new JScrollPane((Component)this.table);
        this.add((Component)scrollPane, "Center");
    }

    void setChoiceName(String rbText, String rbName) {
        this.rb.setText(rbText);
        this.rb.setName(rbName);
    }

    void setData(String[] headings, List<String[]> data) {
        this.headings = headings;
        this.data = data;
        SystemUtilities.runIfSwingOrPostSwingLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ListChoice.this.model.fireTableStructureChanged();
            }
        });
    }

    public boolean isSelected() {
        return this.rb.isSelected();
    }
}

