/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.framework.options.Options;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class AnalysisOptionsUpdater {
    private static final Function<Object, Object> OLD_VALUE_REPLACER = oldValue -> oldValue;
    private Map<String, ReplaceableOption> optionsByNewName = new HashMap<String, ReplaceableOption>();

    public void registerReplacement(String newOptionName, String oldOptionName) {
        this.registerReplacement(newOptionName, oldOptionName, OLD_VALUE_REPLACER);
    }

    public void registerReplacement(String newOptionName, String oldOptionName, Function<Object, Object> replacer) {
        this.optionsByNewName.put(newOptionName, new ReplaceableOption(newOptionName, oldOptionName, replacer));
    }

    Set<ReplaceableOption> getReplaceableOptions() {
        return new HashSet<ReplaceableOption>(this.optionsByNewName.values());
    }

    public static class ReplaceableOption {
        private final String newName;
        private final String oldName;
        private final Function<Object, Object> replacer;

        ReplaceableOption(String newName, String oldName, Function<Object, Object> replacer) {
            this.newName = newName;
            this.oldName = oldName;
            this.replacer = replacer;
        }

        void replace(Options options) {
            Object oldValue = options.getObject(this.oldName, null);
            if (oldValue == null) {
                return;
            }
            if (options.isDefaultValue(this.oldName)) {
                return;
            }
            if (!options.isDefaultValue(this.newName)) {
                return;
            }
            Object newValue = this.replacer.apply(oldValue);
            options.putObject(this.newName, newValue);
        }

        String getNewName() {
            return this.newName;
        }

        String getOldName() {
            return this.oldName;
        }
    }
}

