/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.rust.demangler;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RustDemanglerLegacy {
    private static final Pattern RUST_LEGACY_HASHID_PATTERN = Pattern.compile("h[0-9a-f]{16}");

    public static String demangle(String symbol) {
        String string;
        if (symbol.startsWith("_ZN")) {
            symbol = symbol.substring(3);
        } else if (symbol.startsWith("ZN")) {
            symbol = symbol.substring(2);
        } else if (symbol.startsWith("__ZN")) {
            symbol = symbol.substring(4);
        } else {
            return null;
        }
        if (!symbol.matches("\\A\\p{ASCII}*\\z")) {
            return null;
        }
        ArrayList<String> elements = new ArrayList<String>();
        char[] chars = symbol.toCharArray();
        int i = 0;
        while (chars[i] != 'E') {
            if (chars[i] < '0' || chars[i] > '9') {
                return null;
            }
            int l = 0;
            while (chars[i + l] >= '0' && chars[i + l] <= '9') {
                ++l;
            }
            String lengthString = symbol.substring(i, i + l);
            int length = Integer.parseInt(lengthString);
            String element = symbol.substring(i + l, i + l + length);
            elements.add(element);
            i = i + l + length;
        }
        for (int j = 0; j < elements.size(); ++j) {
            Object element = (String)elements.get(j);
            element = ((String)element).replace("$SP$", "@");
            element = ((String)element).replace("$BP$", "*");
            element = ((String)element).replace("$RF$", "&");
            element = ((String)element).replace("$LT$", "<");
            element = ((String)element).replace("$GT$", ">");
            element = ((String)element).replace("$LP$", "(");
            element = ((String)element).replace("$RP$", ")");
            element = ((String)element).replace("$C$", ",");
            element = ((String)element).replace("..", "::");
            for (int k = 0; k < ((String)element).length(); ++k) {
                String inner;
                if (((String)element).charAt(k) != '$') continue;
                int l = k + 1;
                while (((String)element).charAt(l) != '$') {
                    ++l;
                }
                if (!(inner = ((String)element).substring(k, ++l)).startsWith("$u")) continue;
                int num = Integer.parseInt(((String)element).substring(k + 2, l - 1), 16);
                char newChar = (char)num;
                element = ((String)element).substring(0, k) + newChar + ((String)element).substring(l);
            }
            elements.set(j, (String)element);
        }
        if (elements.size() > 1 && RustDemanglerLegacy.isUID(string = (String)elements.get(elements.size() - 1))) {
            elements.remove(elements.size() - 1);
        }
        return String.join((CharSequence)"::", elements);
    }

    private static boolean isUID(String string) {
        string = string.trim();
        Matcher m = RUST_LEGACY_HASHID_PATTERN.matcher(string);
        return m.matches();
    }
}

