/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.codebrowser.AddressRangeInfo;
import ghidra.app.plugin.core.codebrowser.AddressRangeTableModel;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import resources.Icons;
import resources.MultiIconBuilder;
import resources.QUADRANT;

public class SelectEndpointsAction
extends DockingAction {
    private Program program;
    private AddressRangeTableModel model;
    private Plugin plugin;
    private RangeEndpoint endpoint;

    public SelectEndpointsAction(Plugin plugin, Program program, AddressRangeTableModel model, RangeEndpoint endpoint) {
        super("Select " + endpoint.name(), plugin.getName());
        this.program = program;
        this.model = model;
        this.plugin = plugin;
        this.endpoint = endpoint;
        this.init();
    }

    public boolean isAddToPopup(ActionContext context) {
        return true;
    }

    public boolean isEnabledForContext(ActionContext context) {
        return !this.getSelectedRanges(context).isEmpty();
    }

    public void actionPerformed(ActionContext context) {
        AddressSet selection = new AddressSet();
        for (AddressRangeInfo rangeInfo : this.model.getLastSelectedObjects()) {
            if (this.endpoint.equals((Object)RangeEndpoint.MIN)) {
                selection.add(rangeInfo.min());
                continue;
            }
            selection.add(rangeInfo.max());
        }
        this.plugin.getTool().firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent(this.plugin.getName(), new ProgramSelection((AddressSetView)selection), this.program));
    }

    private void init() {
        ImageIcon icon = null;
        String menuText = null;
        String description = null;
        int height = Icons.MAKE_SELECTION_ICON.getIconHeight() / 2;
        int weight = Icons.MAKE_SELECTION_ICON.getIconWidth() / 2;
        MultiIconBuilder iconBuilder = new MultiIconBuilder(Icons.MAKE_SELECTION_ICON);
        if (this.endpoint.equals((Object)RangeEndpoint.MIN)) {
            iconBuilder.addIcon(Icons.UP_ICON, weight, height, QUADRANT.UL);
            icon = iconBuilder.build();
            menuText = "Select Min Endpoints";
            description = "Makes a Program Selection from the minimum addresses in the selected rows";
        } else {
            iconBuilder.addIcon(Icons.DOWN_ICON, weight, height, QUADRANT.LL);
            icon = iconBuilder.build();
            menuText = "Select Max Endpoints";
            description = "Makes a Program Selection from the maximum addresses in the selected rows";
        }
        this.setPopupMenuData(new MenuData(new String[]{menuText}, (Icon)icon));
        this.setToolBarData(new ToolBarData((Icon)icon));
        this.setDescription(description);
    }

    private List<AddressRangeInfo> getSelectedRanges(ActionContext context) {
        Component component = context.getSourceComponent();
        if (!(component instanceof JTable)) {
            return Collections.emptyList();
        }
        JTable table = (JTable)component;
        TableModel tableModel = table.getModel();
        if (this.model != tableModel) {
            return Collections.emptyList();
        }
        ArrayList<AddressRangeInfo> ranges = new ArrayList<AddressRangeInfo>();
        for (int row : table.getSelectedRows()) {
            ranges.add((AddressRangeInfo)this.model.getRowObject(row));
        }
        return ranges;
    }

    static enum RangeEndpoint {
        MIN,
        MAX;

    }
}

