/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser.hover;

import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.plugin.core.hover.AbstractConfigurableHover;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HTMLUtilities;
import javax.swing.JComponent;

public class LabelListingHover
extends AbstractConfigurableHover
implements ListingHoverService {
    private static final String NAME = "Label Display";
    private static final String DESCRIPTION = "Toggle whether the full symbol name is shown as a tooltip.  This only applies when displaying namespaces.";
    private static final int PRIORITY = 20;

    public LabelListingHover(PluginTool tool) {
        super(tool, 20);
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected String getDescription() {
        return DESCRIPTION;
    }

    @Override
    protected String getOptionsCategory() {
        return "Listing Popups";
    }

    @Override
    public JComponent getHoverComponent(Program program, ProgramLocation programLocation, FieldLocation fieldLocation, Field field) {
        Symbol symbol = this.getLabelSymbol(programLocation);
        if (symbol == null) {
            return null;
        }
        return this.createTooltipComponent(this.getToolTipText(symbol));
    }

    private Symbol getLabelSymbol(ProgramLocation programLocation) {
        if (!this.enabled || programLocation == null) {
            return null;
        }
        if (!(programLocation instanceof LabelFieldLocation)) {
            return null;
        }
        Symbol symbol = ((LabelFieldLocation)programLocation).getSymbol();
        if (symbol == null) {
            return null;
        }
        return symbol;
    }

    private String getToolTipText(Symbol symbol) {
        StringBuilder buf = new StringBuilder("<html>");
        buf.append(HTMLUtilities.friendlyEncodeHTML((String)symbol.getName(true)));
        buf.append("<br>").append("<br>");
        buf.append("Type: ");
        buf.append("&nbsp;").append("&nbsp;").append("&nbsp;").append("&nbsp;");
        buf.append(symbol.getSymbolType());
        buf.append("<br>");
        buf.append("Source: ");
        buf.append(symbol.getSource().getDisplayString());
        buf.append("<br>");
        return buf.toString();
    }
}

