/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.widgets.OptionDialog;
import docking.widgets.button.GRadioButton;
import docking.widgets.label.GDLabel;
import docking.widgets.table.GTable;
import docking.widgets.textfield.GFormattedTextField;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import ghidra.app.plugin.core.compositeeditor.BitFieldPlacementComponent;
import ghidra.app.plugin.core.compositeeditor.CompEditorModel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorModelAdapter;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorPanel;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeViewerModel;
import ghidra.app.plugin.core.compositeeditor.StructureEditorModel;
import ghidra.program.model.data.AlignmentType;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.PackingType;
import ghidra.util.InvalidNameException;
import ghidra.util.Swing;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.DefaultFormatterFactory;
import org.apache.commons.lang3.StringUtils;

public class CompEditorPanel<T extends Composite, M extends CompEditorModel<T>>
extends CompositeEditorPanel<T, M> {
    protected static final Insets LEFT_INSETS = new Insets(2, 3, 1, 0);
    protected static final Insets VERTICAL_INSETS = new Insets(2, 2, 1, 0);
    private GridBagLayout gridBagLayout;
    private JPanel infoPanel;
    private JLabel categoryNameLabel;
    GFormattedTextField nameTextField;
    private GFormattedTextField descriptionTextField;
    private GFormattedTextField sizeTextField;
    private JPanel alignPanel;
    private JRadioButton defaultAlignButton;
    private JRadioButton machineAlignButton;
    private JRadioButton explicitAlignButton;
    private GFormattedTextField explicitAlignTextField;
    private JPanel packingPanel;
    private JCheckBox packingEnablementButton;
    private JRadioButton defaultPackingButton;
    private JRadioButton explicitPackingButton;
    private GFormattedTextField explicitPackingTextField;
    private JLabel actualAlignmentValueLabel;
    private List<Component> focusList;
    private BitFieldPlacementComponent bitViewComponent;
    private boolean updatingSize;

    public CompEditorPanel(M model, CompositeEditorProvider<T, M> provider) {
        super(model, provider);
    }

    @Override
    public void componentDataChanged() {
        this.refreshGUIPackingValue();
        this.refreshGUIMinimumAlignmentValue();
        this.refreshGUIActualAlignmentValue();
        this.setCompositeSize(((CompEditorModel)this.model).getLength());
    }

    @Override
    public void compositeInfoChanged() {
        this.adjustCompositeInfo();
        if (this.bitViewComponent != null && ((CompEditorModel)this.model).showHexNumbers != this.bitViewComponent.isShowOffsetsInHex()) {
            this.bitViewComponent.setShowOffsetsInHex(((CompEditorModel)this.model).showHexNumbers);
        }
    }

    @Override
    protected void adjustCompositeInfo() {
        this.setCompositeName(((CompEditorModel)this.model).getCompositeName());
        this.setDescription(((CompEditorModel)this.model).getDescription());
        Category c = ((CompEditorModel)this.model).getOriginalCategory();
        if (c != null) {
            this.setCategoryName(c.toString());
        }
        this.componentDataChanged();
    }

    @Override
    protected JPanel createBitViewerPanel() {
        this.bitViewComponent = new BitFieldPlacementComponent(((CompEditorModel)this.model).viewComposite, false);
        this.bitViewComponent.setShowOffsetsInHex(((CompEditorModel)this.model).showHexNumbers);
        ((CompEditorModel)this.model).addCompositeViewerModelListener(new CompositeEditorModelAdapter(){

            @Override
            public void selectionChanged() {
                this.update(false);
            }

            @Override
            public void componentDataChanged() {
                this.update(true);
            }

            private void update(boolean dataChanged) {
                Rectangle selectedRectangle;
                int length;
                if (!((CompEditorModel)CompEditorPanel.this.model).isLoaded()) {
                    CompEditorPanel.this.bitViewComponent.setComposite(null);
                    return;
                }
                if (CompEditorPanel.this.bitViewComponent.getComposite() != ((CompEditorModel)CompEditorPanel.this.model).viewComposite) {
                    CompEditorPanel.this.bitViewComponent.setComposite(((CompEditorModel)CompEditorPanel.this.model).viewComposite);
                }
                if ((length = ((CompEditorModel)CompEditorPanel.this.model).viewComposite.getLength()) != CompEditorPanel.this.bitViewComponent.getAllocationByteSize()) {
                    CompEditorPanel.this.bitViewComponent.updateAllocation(length, 0);
                }
                DataTypeComponent dtc = null;
                if (((CompEditorModel)CompEditorPanel.this.model).isSingleComponentRowSelection()) {
                    dtc = ((CompEditorModel)CompEditorPanel.this.model).getComponent(((CompEditorModel)CompEditorPanel.this.model).getSelectedRows()[0]);
                }
                if ((selectedRectangle = CompEditorPanel.this.bitViewComponent.getComponentRectangle(dtc)) != null) {
                    CompEditorPanel.this.bitViewComponent.scrollRectToVisible(selectedRectangle);
                    CompEditorPanel.this.validate();
                }
                if (dtc != null && dtc.getOffset() >= length) {
                    CompEditorPanel.this.bitViewComponent.init(null);
                } else {
                    CompEditorPanel.this.bitViewComponent.init(dtc);
                }
            }
        });
        this.bitViewComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                BitFieldPlacementComponent.BitAttributes attrs = CompEditorPanel.this.bitViewComponent.getBitAttributes(p);
                if (attrs == null) {
                    return;
                }
                DataTypeComponent dtc = attrs.getDataTypeComponent(false);
                if (dtc != null) {
                    ((CompEditorModel)CompEditorPanel.this.model).setSelection(new int[]{dtc.getOrdinal()});
                    CompEditorPanel.this.table.scrollToSelectedRow();
                }
            }
        });
        JPanel bitViewPanel = new JPanel((LayoutManager)new PairLayout(0, 5));
        JPanel labelPanel = new JPanel((LayoutManager)new VerticalLayout(7));
        labelPanel.setBorder(BorderFactory.createEmptyBorder(7, 5, 0, 0));
        JLabel byteOffsetLabel = new JLabel("Byte Offset:", 4);
        labelPanel.add(byteOffsetLabel);
        labelPanel.add(new JLabel("Component Bits:", 4));
        bitViewPanel.add(labelPanel);
        JScrollPane bitViewScrollPane = new JScrollPane(this.bitViewComponent, 21, 30);
        bitViewScrollPane.getViewport().setBackground((Color)GThemeDefaults.Colors.Viewport.UNEDITABLE_BACKGROUND);
        bitViewScrollPane.setBorder(null);
        Dimension bitViewerDefaultSize = new Dimension(800, this.bitViewComponent.getPreferredHeight());
        bitViewScrollPane.setPreferredSize(bitViewerDefaultSize);
        bitViewPanel.add(bitViewScrollPane);
        return bitViewPanel;
    }

    @Override
    protected List<Component> getFocusComponents() {
        if (this.focusList == null) {
            this.focusList = List.of(this.table, this.searchPanel.getTextField(), this.nameTextField, this.descriptionTextField, this.sizeTextField, this.defaultAlignButton, this.packingEnablementButton, this.defaultPackingButton);
        }
        return this.focusList;
    }

    @Override
    protected JPanel createInfoPanel() {
        this.gridBagLayout = new GridBagLayout();
        this.infoPanel = new JPanel(this.gridBagLayout);
        this.setBorder(BEVELED_BORDER);
        this.setupCategory();
        this.setupName();
        this.setupDescription();
        this.setupSize();
        this.setupActualAlignment();
        this.setupMinimumAlignment();
        this.setupPacking();
        this.infoPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        return this.infoPanel;
    }

    private void setupCategory() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GDLabel categoryLabel = new GDLabel("Category:");
        gridBagConstraints.insets = LEFT_INSETS;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.infoPanel.add((Component)categoryLabel, gridBagConstraints);
        this.categoryNameLabel = new JLabel(" ");
        this.categoryNameLabel.setToolTipText("Category of this composite data type.");
        gridBagConstraints.insets = new Insets(2, 4, 1, 2);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        this.infoPanel.add((Component)this.categoryNameLabel, gridBagConstraints);
    }

    private void setupName() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GDLabel nameLabel = new GDLabel("Name:");
        gridBagConstraints.insets = LEFT_INSETS;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.infoPanel.add((Component)nameLabel, gridBagConstraints);
        this.nameTextField = new GFormattedTextField((JFormattedTextField.AbstractFormatterFactory)new DefaultFormatterFactory(), (Object)"");
        this.nameTextField.setToolTipText("Structure Name");
        this.nameTextField.setEditable(true);
        gridBagConstraints.insets = VERTICAL_INSETS;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        this.infoPanel.add((Component)this.nameTextField, gridBagConstraints);
        this.provider.registerHelp(this.nameTextField, "Name");
        this.nameTextField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                ((CompEditorModel)CompEditorPanel.this.model).clearStatus();
                String newName = CompEditorPanel.this.nameTextField.getText().trim();
                if (!DataUtilities.isValidDataTypeName((String)newName)) {
                    if (newName.length() == 0) {
                        ((CompEditorModel)CompEditorPanel.this.model).setStatus("Name is required.");
                    } else {
                        ((CompEditorModel)CompEditorPanel.this.model).setStatus(newName + " is not a valid name.");
                    }
                    return false;
                }
                if (!newName.equals(((CompEditorModel)CompEditorPanel.this.model).getOriginalDataTypeName()) && ((CompEditorModel)CompEditorPanel.this.model).getOriginalDataTypeManager().getDataType(((CompEditorModel)CompEditorPanel.this.model).originalDataTypePath.getCategoryPath(), newName) != null) {
                    ((CompEditorModel)CompEditorPanel.this.model).setStatus("A data type named " + newName + " already exists.");
                    return false;
                }
                CompEditorPanel.this.updateEntryAcceptanceStatus();
                return true;
            }
        });
        this.nameTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    e.consume();
                    CompEditorPanel.this.setStatus("");
                    CompEditorPanel.this.setCompositeName(((CompEditorModel)CompEditorPanel.this.model).getCompositeName());
                }
            }
        });
        this.nameTextField.addTextEntryStatusListener(c -> this.provider.contextChanged());
        this.nameTextField.addActionListener(e -> this.updatedName());
        this.nameTextField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                CompEditorPanel.this.updatedName();
            }
        });
    }

    private void setupDescription() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GDLabel descriptionLabel = new GDLabel("Description:");
        gridBagConstraints.insets = LEFT_INSETS;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.infoPanel.add((Component)descriptionLabel, gridBagConstraints);
        this.descriptionTextField = new GFormattedTextField((JFormattedTextField.AbstractFormatterFactory)new DefaultFormatterFactory(), (Object)"");
        this.descriptionTextField.setToolTipText("Structure Description");
        this.descriptionTextField.setEditable(true);
        gridBagConstraints.insets = VERTICAL_INSETS;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        this.infoPanel.add((Component)this.descriptionTextField, gridBagConstraints);
        this.provider.registerHelp(this.descriptionTextField, "Description");
        this.descriptionTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    e.consume();
                    CompEditorPanel.this.setStatus("");
                    CompEditorPanel.this.setDescription(((CompEditorModel)CompEditorPanel.this.model).getDescription());
                }
            }
        });
        this.descriptionTextField.addTextEntryStatusListener(c -> this.provider.contextChanged());
        this.descriptionTextField.addActionListener(e -> this.updatedDescription());
        this.descriptionTextField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                CompEditorPanel.this.updatedDescription();
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        if (this.alignPanel.isShowing()) {
            return preferredSize;
        }
        Dimension alignmentPanelPreferredSize = this.alignPanel.getPreferredSize();
        preferredSize.width += alignmentPanelPreferredSize.width;
        Dimension packingPanelPreferredSize = this.packingPanel.getPreferredSize();
        preferredSize.width += packingPanelPreferredSize.width;
        return preferredSize;
    }

    private void setupMinimumAlignment() {
        this.setupDefaultAlignButton();
        this.setupExplicitAlignButtonAndTextField();
        this.setupMachineMinAlignButton();
        ButtonGroup minAlignGroup = new ButtonGroup();
        minAlignGroup.add(this.defaultAlignButton);
        minAlignGroup.add(this.explicitAlignButton);
        minAlignGroup.add(this.machineAlignButton);
        this.alignPanel = new JPanel(new GridBagLayout());
        TitledBorder border = BorderFactory.createTitledBorder("align (minimum)");
        this.alignPanel.setBorder(border);
        this.provider.registerHelp(this.alignPanel, "Align");
        String alignmentToolTip = "<html>The <B>align</B> control allows the overall minimum alignment of this<BR>data type to be specified.  The actual computed alignment<BR>may be any multiple of this value.   <font color=\"" + GThemeDefaults.Colors.Palette.BLUE.toHexString() + "\" size=\"-2\">(&lt;F1&gt; for help)</html>";
        this.alignPanel.setToolTipText(alignmentToolTip);
        this.addMinimumAlignmentComponents();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        this.infoPanel.add((Component)this.alignPanel, gridBagConstraints);
        this.infoPanel.invalidate();
        this.refreshGUIMinimumAlignmentValue();
    }

    private void addMinimumAlignmentComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.alignPanel.add((Component)this.defaultAlignButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        this.alignPanel.add((Component)this.explicitAlignButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        this.alignPanel.add((Component)this.explicitAlignTextField, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        this.alignPanel.add((Component)this.machineAlignButton, gridBagConstraints);
    }

    private void setupDefaultAlignButton() {
        this.defaultAlignButton = new GRadioButton("default           ");
        this.defaultAlignButton.setName("Default Alignment");
        String alignmentToolTip = "<html>Sets this data type to use <B>default</B> alignment.<BR>If packing is disabled, the default will be 1 byte.  If packing<BR>is enabled, the alignment is computed based upon the pack<BR>setting and the alignment of each component data type.</html>";
        this.defaultAlignButton.addActionListener(e -> ((CompEditorModel)this.model).setAlignmentType(AlignmentType.DEFAULT, -1));
        this.defaultAlignButton.setToolTipText(alignmentToolTip);
        this.provider.registerHelp(this.defaultAlignButton, "Align");
    }

    private void setupMachineMinAlignButton() {
        DataOrganization dataOrganization = ((CompEditorModel)this.model).viewComposite.getDataOrganization();
        int machineAlignment = dataOrganization.getMachineAlignment();
        this.machineAlignButton = new GRadioButton("machine: " + machineAlignment);
        this.machineAlignButton.setName("Machine Alignment");
        String alignmentToolTip = "<html>Sets this data type to use the <B>machine</B> alignment<BR>as specified by the compiler specification.  If packing is<BR>enabled, the computed alignment of this composite should be<BR>the machine alignment value.</html>";
        this.machineAlignButton.setToolTipText(alignmentToolTip);
        this.machineAlignButton.addActionListener(e -> ((CompEditorModel)this.model).setAlignmentType(AlignmentType.MACHINE, -1));
        this.provider.registerHelp(this.machineAlignButton, "Align");
    }

    private void setupExplicitAlignButtonAndTextField() {
        this.explicitAlignButton = new GRadioButton();
        this.explicitAlignButton.setName("Explicit Alignment");
        this.explicitAlignTextField = new GFormattedTextField((JFormattedTextField.AbstractFormatterFactory)new DefaultFormatterFactory(), (Object)"");
        this.explicitAlignTextField.setName("Explicit Alignment Value");
        this.explicitAlignTextField.setEditable(true);
        String alignmentToolTip = "<html>Sets this data type to use the <B>explicit</B> alignment value<BR>specified.  If packing is enabled, the computed alignment of<BR>this composite may be any multiple of this value.</html>";
        this.explicitAlignButton.setToolTipText(alignmentToolTip);
        this.explicitAlignTextField.setToolTipText(alignmentToolTip);
        this.provider.registerHelp(this.explicitAlignButton, "Align");
        this.provider.registerHelp(this.explicitAlignTextField, "Align");
        this.explicitAlignButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CompEditorPanel.this.explicitAlignTextField.requestFocus();
            }
        });
        this.explicitAlignButton.addActionListener(e -> this.chooseExplicitAlign());
        this.explicitAlignTextField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return CompEditorPanel.this.decodeUnsignedIntEntry((JTextField)CompEditorPanel.this.explicitAlignTextField, "minimum alignment", false) > 0;
            }
        });
        this.explicitAlignTextField.addKeyListener((KeyListener)new UpAndDownKeyListener(this, this.defaultAlignButton, this.machineAlignButton));
        this.explicitAlignTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    e.consume();
                    CompEditorPanel.this.refreshGUIMinimumAlignmentValue();
                }
            }
        });
        this.explicitAlignTextField.addTextEntryStatusListener(c -> this.provider.contextChanged());
        this.explicitAlignTextField.addActionListener(e -> this.adjustExplicitMinimumAlignmentValue());
        this.explicitAlignTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (CompEditorPanel.this.explicitAlignButton.isSelected()) {
                    return;
                }
                CompEditorPanel.this.explicitAlignButton.setSelected(true);
                CompEditorPanel.this.chooseExplicitAlign();
            }

            @Override
            public void focusLost(FocusEvent e) {
                CompEditorPanel.this.adjustExplicitMinimumAlignmentValue();
            }
        });
    }

    private void adjustExplicitMinimumAlignmentValue() {
        if (this.explicitAlignTextField.getTextEntryStatus() != GFormattedTextField.Status.CHANGED) {
            return;
        }
        int minAlignment = this.decodeUnsignedIntEntry((JTextField)this.explicitAlignTextField, "minimum alignment", false);
        if (minAlignment <= 0) {
            return;
        }
        try {
            ((CompEditorModel)this.model).setAlignmentType(AlignmentType.EXPLICIT, minAlignment);
            this.adjustCompositeInfo();
        }
        catch (IllegalArgumentException e1) {
            this.refreshGUIMinimumAlignmentValue();
            String message = "\"" + minAlignment + "\" is not a valid alignment value.";
            this.setStatus(message);
        }
    }

    private void setupActualAlignment() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String actualAlignmentToolTip = "<html>The actual alignment to be used for this data type.<BR>A combination of the pack and alignment settings made to this datatype<BR>combined with alignments of the individual components are used to<BR>to compute the actual alignment of this datatype.</html>";
        JPanel actualAlignmentPanel = new JPanel(new BorderLayout());
        GDLabel actualAlignmentLabel = new GDLabel("Alignment:");
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        actualAlignmentLabel.setToolTipText(actualAlignmentToolTip);
        actualAlignmentPanel.add((Component)actualAlignmentLabel, "East");
        this.infoPanel.add((Component)actualAlignmentPanel, gridBagConstraints);
        this.actualAlignmentValueLabel = new JLabel();
        int actualAlignment = ((CompEditorModel)this.model).getActualAlignment();
        this.actualAlignmentValueLabel.setText(Integer.toString(actualAlignment));
        this.actualAlignmentValueLabel.setToolTipText(actualAlignmentToolTip);
        this.actualAlignmentValueLabel.setBackground(this.getBackground());
        this.actualAlignmentValueLabel.setName("Actual Alignment Value");
        this.provider.registerHelp(this.actualAlignmentValueLabel, "ActualAlignment");
        gridBagConstraints.insets = new Insets(2, 4, 1, 2);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        this.infoPanel.add((Component)this.actualAlignmentValueLabel, gridBagConstraints);
        this.refreshGUIActualAlignmentValue();
    }

    private void setupPacking() {
        this.packingPanel = new JPanel((LayoutManager)new VerticalLayout(0));
        this.packingEnablementButton = new JCheckBox("pack");
        this.packingEnablementButton.setEnabled(true);
        this.packingEnablementButton.setFont(UIManager.getFont("TitledBorder.font"));
        this.packingEnablementButton.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        this.packingPanel.add(this.packingEnablementButton);
        JPanel innerPanel = new JPanel(new GridBagLayout());
        Border titledBorder = UIManager.getBorder("TitledBorder.border");
        innerPanel.setBorder(titledBorder);
        this.packingPanel.add(innerPanel);
        Gui.addThemeListener(e -> {
            if (e.isLookAndFeelChanged()) {
                Border updatedTitledBorder = UIManager.getBorder("TitledBorder.border");
                innerPanel.setBorder(updatedTitledBorder);
            }
        });
        this.setupDefaultPackingButton();
        this.setupExplicitPackingButtonAndTextField();
        this.setupPackingEnablementButton();
        ButtonGroup packingGroup = new ButtonGroup();
        packingGroup.add(this.defaultPackingButton);
        packingGroup.add(this.explicitPackingButton);
        this.provider.registerHelp(this.packingPanel, "Pack");
        this.addPackingComponents(innerPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        this.infoPanel.add((Component)this.packingPanel, gridBagConstraints);
        this.refreshGUIPackingValue();
    }

    private void addPackingComponents(JPanel gridPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridPanel.add((Component)this.defaultPackingButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridPanel.add((Component)this.explicitPackingButton, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridPanel.add((Component)this.explicitPackingTextField, gridBagConstraints);
    }

    private void setupPackingEnablementButton() {
        this.packingEnablementButton.setName("Packing Enablement");
        String packingToolTipText = "<html>Enable packing when details of all components are known (including sizing and alignment).<BR>Disable packing when Reverse Engineering composite.   <font color=\"" + GThemeDefaults.Colors.Palette.BLUE.toHexString() + "\" size=\"-2\">(&lt;F1&gt; for help)</font></html>";
        this.packingEnablementButton.addActionListener(e -> ((CompEditorModel)this.model).setPackingType(this.packingEnablementButton.isSelected() ? PackingType.DEFAULT : PackingType.DISABLED, -1));
        this.packingEnablementButton.setToolTipText(packingToolTipText);
        this.provider.registerHelp(this.packingEnablementButton, "Pack");
    }

    private void setupDefaultPackingButton() {
        this.defaultPackingButton = new GRadioButton("default           ");
        this.defaultPackingButton.setName("Default Packing");
        String packingToolTipText = "<html>Indicates <B>default</B> compiler packing rules should be applied.</html>";
        this.defaultPackingButton.addActionListener(e -> ((CompEditorModel)this.model).setPackingType(PackingType.DEFAULT, -1));
        this.defaultPackingButton.setToolTipText(packingToolTipText);
        this.provider.registerHelp(this.defaultPackingButton, "Pack");
    }

    private void setupExplicitPackingButtonAndTextField() {
        this.explicitPackingButton = new GRadioButton();
        this.explicitPackingButton.setName("Explicit Packing");
        this.explicitPackingTextField = new GFormattedTextField((JFormattedTextField.AbstractFormatterFactory)new DefaultFormatterFactory(), (Object)"");
        this.explicitPackingTextField.setName("Packing Value");
        this.explicitPackingTextField.setEditable(true);
        String packingToolTipText = "<html>Indicates an explicit pack size should be applied.</html>";
        this.explicitPackingButton.setToolTipText(packingToolTipText);
        this.explicitPackingTextField.setToolTipText(packingToolTipText);
        this.provider.registerHelp(this.explicitPackingButton, "Pack");
        this.provider.registerHelp(this.explicitPackingTextField, "Pack");
        this.explicitPackingButton.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CompEditorPanel.this.explicitPackingTextField.requestFocus();
            }
        });
        this.explicitPackingButton.addActionListener(e -> this.chooseByValuePacking());
        this.explicitPackingTextField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return CompEditorPanel.this.decodeUnsignedIntEntry((JTextField)CompEditorPanel.this.explicitPackingTextField, "pack value", false) > 0;
            }
        });
        this.explicitPackingTextField.addKeyListener((KeyListener)new UpAndDownKeyListener(this, this.defaultPackingButton, this.defaultPackingButton));
        this.explicitPackingTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    e.consume();
                    CompEditorPanel.this.refreshGUIPackingValue();
                }
            }
        });
        this.explicitPackingTextField.addTextEntryStatusListener(c -> this.provider.contextChanged());
        this.explicitPackingTextField.addActionListener(e -> this.adjustPackingValue());
        this.explicitPackingTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (CompEditorPanel.this.explicitPackingButton.isSelected()) {
                    return;
                }
                CompEditorPanel.this.explicitPackingButton.setSelected(true);
                CompEditorPanel.this.chooseByValuePacking();
            }

            @Override
            public void focusLost(FocusEvent e) {
                CompEditorPanel.this.adjustPackingValue();
            }
        });
    }

    private void chooseByValuePacking() {
        ((CompEditorModel)this.model).setPackingType(PackingType.EXPLICIT, 1);
        this.explicitPackingTextField.selectAll();
        this.explicitPackingTextField.requestFocus();
    }

    private void adjustPackingValue() {
        if (this.explicitPackingTextField.getTextEntryStatus() != GFormattedTextField.Status.CHANGED) {
            return;
        }
        int explicitPacking = this.decodeUnsignedIntEntry((JTextField)this.explicitPackingTextField, "pack value", false);
        if (explicitPacking <= 0) {
            return;
        }
        ((CompEditorModel)this.model).setPackingType(PackingType.EXPLICIT, explicitPacking);
        this.adjustCompositeInfo();
    }

    public void refreshGUIPackingValue() {
        PackingType packingType = ((CompEditorModel)this.model).getPackingType();
        String packingString = "";
        boolean packingEnabled = packingType != PackingType.DISABLED;
        this.packingEnablementButton.setSelected(packingEnabled);
        this.defaultPackingButton.setEnabled(packingEnabled);
        this.explicitPackingButton.setEnabled(packingEnabled);
        this.explicitPackingTextField.setEnabled(packingEnabled);
        if (packingType == PackingType.DEFAULT) {
            this.defaultPackingButton.setSelected(true);
        } else if (packingType == PackingType.EXPLICIT) {
            int packValue = ((CompEditorModel)this.model).getExplicitPackingValue();
            packingString = ((CompEditorModel)this.model).showHexNumbers ? CompositeViewerModel.getHexString(packValue, true) : Integer.toString(packValue);
            this.explicitPackingButton.setSelected(true);
        }
        this.explicitPackingTextField.setText(packingString);
        this.explicitPackingTextField.setDefaultValue((Object)packingString);
        this.explicitPackingTextField.setIsError(false);
    }

    protected void setupSize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GDLabel sizeLabel = new GDLabel("Size:");
        sizeLabel.setToolTipText("The current size in bytes.");
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.infoPanel.add((Component)sizeLabel, gridBagConstraints);
        this.sizeTextField = new GFormattedTextField((JFormattedTextField.AbstractFormatterFactory)new DefaultFormatterFactory(), (Object)"");
        this.sizeTextField.setName("Total Length");
        this.sizeTextField.setToolTipText("The current size in bytes.");
        this.setSizeEditable(false);
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = VERTICAL_INSETS;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.infoPanel.add((Component)this.sizeTextField, gridBagConstraints);
        this.provider.registerHelp(this.sizeTextField, "Size");
        this.sizeTextField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return CompEditorPanel.this.decodeUnsignedIntEntry((JTextField)CompEditorPanel.this.sizeTextField, "structure size", true) >= 0;
            }
        });
        this.sizeTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    e.consume();
                    CompEditorPanel.this.setCompositeSize(((CompEditorModel)CompEditorPanel.this.model).getLength());
                }
            }
        });
        this.sizeTextField.addTextEntryStatusListener(c -> this.provider.contextChanged());
        this.sizeTextField.addActionListener(e -> this.updatedStructureSize());
        this.sizeTextField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (CompEditorPanel.this.sizeTextField.isEditable()) {
                    CompEditorPanel.this.updatedStructureSize();
                }
            }
        });
    }

    protected void setSizeEditable(boolean editable) {
        this.sizeTextField.setEditable(editable);
        this.sizeTextField.setEnabled(editable);
        if (editable) {
            this.sizeTextField.setBackground(this.descriptionTextField.getBackground());
        } else {
            this.sizeTextField.setBackground(this.getBackground());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatedStructureSize() {
        if (this.updatingSize) {
            return;
        }
        if (!this.sizeTextField.isShowing()) {
            return;
        }
        if (!((CompEditorModel)this.model).isSizeEditable()) {
            return;
        }
        if (this.sizeTextField.getTextEntryStatus() != GFormattedTextField.Status.CHANGED) {
            return;
        }
        int size = this.decodeUnsignedIntEntry((JTextField)this.sizeTextField, "structure size", true);
        if (size < 0) {
            return;
        }
        this.updatingSize = true;
        try {
            if (size < ((CompEditorModel)this.model).getLength()) {
                String question = "The size field was changed to " + size + " bytes.\nDo you really want to truncate " + ((CompEditorModel)this.model).getCompositeName() + "?";
                String title = "Truncate " + ((CompEditorModel)this.model).getTypeName() + " In Editor?";
                int response = OptionDialog.showYesNoDialogWithNoAsDefaultButton((Component)this, (String)title, (String)question);
                if (response != 1) {
                    this.compositeInfoChanged();
                    return;
                }
            }
            ((StructureEditorModel)this.model).setStructureSize(size);
        }
        finally {
            this.updatingSize = false;
        }
        this.compositeInfoChanged();
    }

    private void chooseExplicitAlign() {
        if (((CompEditorModel)this.model).getAlignmentType() != AlignmentType.EXPLICIT) {
            Composite viewComposite = ((CompEditorModel)this.model).viewComposite;
            int defaultValue = 1;
            if (viewComposite.isPackingEnabled()) {
                defaultValue = viewComposite.getDataOrganization().getMachineAlignment();
            }
            ((CompEditorModel)this.model).setAlignmentType(AlignmentType.EXPLICIT, defaultValue);
        }
        this.explicitAlignTextField.selectAll();
        this.explicitAlignTextField.requestFocus();
    }

    private int decodeUnsignedIntEntry(JTextField textField, String type, boolean zeroAllowed) {
        ((CompEditorModel)this.model).clearStatus();
        String valueStr = textField.getText().trim();
        if (StringUtils.isEmpty((CharSequence)valueStr)) {
            ((CompEditorModel)this.model).setStatus("Missing " + type + ".", false);
            return -1;
        }
        try {
            int value = Integer.decode(valueStr);
            if (value < 0) {
                ((CompEditorModel)this.model).setStatus("Negative " + type + " not permitted.", true);
                return -1;
            }
            if (value == 0 && !zeroAllowed) {
                ((CompEditorModel)this.model).setStatus("Zero " + type + " not permitted.", true);
                return -1;
            }
            ((CompEditorModel)this.model).setStatus(null);
            return value;
        }
        catch (NumberFormatException e1) {
            ((CompEditorModel)this.model).setStatus("Invalid " + type + " \"" + valueStr + "\".", true);
            return -1;
        }
    }

    private void updateEntryAcceptanceStatus() {
        Swing.runLater(() -> {
            if (!this.hasInvalidEntry() && this.hasUncomittedEntry()) {
                this.setStatus("Hit <Enter> key in edit field to accept entry");
            }
        });
    }

    @Override
    protected boolean hasUncomittedEntry() {
        return this.nameTextField.getTextEntryStatus() == GFormattedTextField.Status.CHANGED || this.descriptionTextField.getTextEntryStatus() == GFormattedTextField.Status.CHANGED || this.sizeTextField.getTextEntryStatus() == GFormattedTextField.Status.CHANGED || this.explicitAlignTextField.getTextEntryStatus() == GFormattedTextField.Status.CHANGED || this.explicitPackingTextField.getTextEntryStatus() == GFormattedTextField.Status.CHANGED;
    }

    @Override
    protected boolean hasInvalidEntry() {
        return this.nameTextField.getTextEntryStatus() == GFormattedTextField.Status.INVALID || this.descriptionTextField.getTextEntryStatus() == GFormattedTextField.Status.INVALID || this.sizeTextField.getTextEntryStatus() == GFormattedTextField.Status.INVALID || this.explicitAlignTextField.getTextEntryStatus() == GFormattedTextField.Status.INVALID || this.explicitPackingTextField.getTextEntryStatus() == GFormattedTextField.Status.INVALID;
    }

    @Override
    protected void comitEntryChanges() {
        if (this.nameTextField.getTextEntryStatus() == GFormattedTextField.Status.CHANGED) {
            this.updatedName();
        } else if (this.descriptionTextField.getTextEntryStatus() == GFormattedTextField.Status.CHANGED) {
            this.updatedDescription();
        } else if (this.sizeTextField.getTextEntryStatus() == GFormattedTextField.Status.CHANGED) {
            this.updatedStructureSize();
        } else if (this.explicitAlignTextField.getTextEntryStatus() == GFormattedTextField.Status.CHANGED) {
            this.adjustExplicitMinimumAlignmentValue();
        } else if (this.explicitPackingTextField.getTextEntryStatus() == GFormattedTextField.Status.CHANGED) {
            this.adjustPackingValue();
        }
    }

    protected void updatedName() {
        if (!this.nameTextField.isShowing()) {
            return;
        }
        if (this.nameTextField.getTextEntryStatus() != GFormattedTextField.Status.CHANGED) {
            return;
        }
        this.setStatus("");
        String newName = this.nameTextField.getText().trim();
        if (!DataUtilities.isValidDataTypeName((String)newName)) {
            if (newName.length() == 0) {
                ((CompEditorModel)this.model).setStatus("Name is required.");
            } else {
                ((CompEditorModel)this.model).setStatus(newName + " is not a valid name.");
            }
            return;
        }
        String originalDtName = ((CompEditorModel)this.model).getOriginalDataTypeName();
        if (!newName.equals(originalDtName) && newName.length() == 0) {
            this.setCompositeName(originalDtName);
            ((CompEditorModel)this.model).setStatus("Name is required. So original name has been restored.");
            return;
        }
        this.setCompositeName(newName);
        if (!newName.equals(((CompEditorModel)this.model).getCompositeName())) {
            try {
                ((CompEditorModel)this.model).setName(newName);
            }
            catch (DuplicateNameException e) {
                ((CompEditorModel)this.model).setStatus("Can't duplicate name \"" + newName + "\".");
            }
            catch (InvalidNameException e) {
                ((CompEditorModel)this.model).setStatus("\"" + newName + "\" isn't a valid name.");
            }
        }
    }

    protected void updatedDescription() {
        if (!this.descriptionTextField.isShowing()) {
            return;
        }
        if (this.descriptionTextField.getTextEntryStatus() != GFormattedTextField.Status.CHANGED) {
            return;
        }
        this.setStatus("");
        String newValue = this.descriptionTextField.getText().trim();
        if (!newValue.equals(((CompEditorModel)this.model).getDescription())) {
            ((CompEditorModel)this.model).setDescription(newValue);
            this.setDescription(newValue);
        }
    }

    public String getCategoryName() {
        return this.categoryNameLabel.getText();
    }

    public void setCategoryName(String name) {
        this.categoryNameLabel.setText(name);
    }

    private void setCompositeName(String name) {
        this.nameTextField.setText(name);
        this.nameTextField.setDefaultValue((Object)name);
        this.nameTextField.setIsError(false);
    }

    private void setDescription(String description) {
        this.descriptionTextField.setText(description);
        this.descriptionTextField.setDefaultValue((Object)description);
        this.descriptionTextField.setIsError(false);
    }

    public void refreshGUIMinimumAlignmentValue() {
        AlignmentType alignmentType = ((CompEditorModel)this.model).getAlignmentType();
        String minimumAlignmentStr = "";
        if (alignmentType == AlignmentType.DEFAULT) {
            this.defaultAlignButton.setSelected(true);
        } else if (alignmentType == AlignmentType.MACHINE) {
            this.machineAlignButton.setSelected(true);
        } else {
            this.explicitAlignButton.setSelected(true);
            int minimumAlignment = ((CompEditorModel)this.model).getExplicitMinimumAlignment();
            minimumAlignmentStr = ((CompEditorModel)this.model).showHexNumbers ? CompositeViewerModel.getHexString(minimumAlignment, true) : Integer.toString(minimumAlignment);
        }
        this.explicitAlignTextField.setText(minimumAlignmentStr);
        this.explicitAlignTextField.setDefaultValue((Object)minimumAlignmentStr);
        this.explicitAlignTextField.setIsError(false);
    }

    public void refreshGUIActualAlignmentValue() {
        int actualAlignment = ((CompEditorModel)this.model).getActualAlignment();
        String alignmentStr = ((CompEditorModel)this.model).showHexNumbers ? CompositeViewerModel.getHexString(actualAlignment, true) : Integer.toString(actualAlignment);
        this.actualAlignmentValueLabel.setText(alignmentStr);
    }

    public int getCompositeSize() {
        return Integer.decode(this.sizeTextField.getText());
    }

    private void setCompositeSize(int size) {
        boolean sizeIsEditable = ((CompEditorModel)this.model).isSizeEditable();
        if (this.sizeTextField.isEditable() != sizeIsEditable) {
            this.setSizeEditable(sizeIsEditable);
        }
        String sizeStr = ((CompEditorModel)this.model).showHexNumbers ? CompositeViewerModel.getHexString(size, true) : Integer.toString(size);
        this.sizeTextField.setText(sizeStr);
        this.sizeTextField.setDefaultValue((Object)sizeStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dragUnderFeedback(boolean ok, DropTargetDragEvent e) {
        GTable gTable = this.table;
        synchronized (gTable) {
            int dropAction = e.getDropAction();
            boolean actionChanged = false;
            if (dropAction != this.lastDndAction) {
                actionChanged = true;
                this.lastDndAction = dropAction;
            }
            if (this.table.isEditing()) {
                this.table.editingCanceled(null);
            }
            boolean inserting = false;
            if (dropAction == 1) {
                inserting = true;
            }
            this.dndTableCellRenderer.selectRange(inserting);
            this.dndDtiCellRenderer.selectRange(inserting);
            Point p = e.getLocation();
            int row = this.table.rowAtPoint(p);
            boolean setRow = this.dndTableCellRenderer.setRowForFeedback(row);
            boolean setDtiRow = this.dndDtiCellRenderer.setRowForFeedback(row);
            if (actionChanged || setRow || setDtiRow) {
                this.table.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undoDragUnderFeedback() {
        GTable gTable = this.table;
        synchronized (gTable) {
            this.dndTableCellRenderer.setRowForFeedback(-1);
            this.dndDtiCellRenderer.setRowForFeedback(-1);
            this.table.repaint();
        }
    }

    @Override
    public void showUndefinedStateChanged(boolean showUndefinedBytes) {
    }

    private class UpAndDownKeyListener
    extends KeyAdapter {
        private JRadioButton previousComponent;
        private JRadioButton nextComponent;

        UpAndDownKeyListener(CompEditorPanel compEditorPanel, JRadioButton previousComponent, JRadioButton nextComponent) {
            this.previousComponent = previousComponent;
            this.nextComponent = nextComponent;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isConsumed()) {
                return;
            }
            int code = e.getKeyCode();
            if (code == 38) {
                this.previousComponent.requestFocusInWindow();
                Swing.runLater(() -> this.previousComponent.setSelected(true));
                e.consume();
            } else if (code == 40) {
                this.nextComponent.requestFocusInWindow();
                Swing.runLater(() -> this.nextComponent.setSelected(true));
                e.consume();
            }
        }
    }
}

