/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.entropy;

import ghidra.program.model.address.Address;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;

public class EntropyCalculate {
    private MemoryBlock block;
    private int[] entropy;
    private int chunksize;
    private int[] histo;
    private byte[] chunk;
    private double[] logtable;

    public EntropyCalculate(MemoryBlock b, int csize) {
        this.block = b;
        this.chunksize = csize;
        this.doEntropy();
    }

    public int getValue(int offset) {
        if (offset < 0) {
            return -1;
        }
        if ((offset /= this.chunksize) >= this.entropy.length) {
            return -1;
        }
        return this.entropy[offset];
    }

    private void doEntropy() {
        this.histo = new int[256];
        this.chunk = new byte[this.chunksize];
        this.buildLogTable();
        long size = (int)this.block.getSize();
        int numchunks = (int)(size / (long)this.chunksize);
        if (size % (long)this.chunksize != 0L) {
            ++numchunks;
        }
        this.entropy = new int[numchunks];
        long offset = 0L;
        int chunknum = 0;
        while (offset < size) {
            try {
                this.histogramChunk(offset);
            }
            catch (MemoryAccessException e) {
                this.entropy[chunknum] = -1;
            }
            this.quantizeChunk(chunknum);
            offset += (long)this.chunksize;
            ++chunknum;
        }
        this.histo = null;
        this.chunk = null;
        this.logtable = null;
    }

    private void histogramChunk(long offset) throws MemoryAccessException {
        int i;
        Address addr = this.block.getStart().add(offset);
        int len = this.block.getBytes(addr, this.chunk, 0, this.chunksize);
        for (i = 0; i < 256; ++i) {
            this.histo[i] = 0;
        }
        for (i = 0; i < len; ++i) {
            int n = 128 + this.chunk[i];
            this.histo[n] = this.histo[n] + 1;
        }
    }

    private void buildLogTable() {
        this.logtable = new double[this.chunksize + 1];
        double logtwo = Math.log(2.0);
        double chunkfloat = this.chunksize;
        for (int i = 1; i < this.chunksize; ++i) {
            double prob = (double)i / chunkfloat;
            this.logtable[i] = -prob * (Math.log(prob) / logtwo);
        }
        this.logtable[0] = 0.0;
        this.logtable[this.chunksize] = 0.0;
    }

    private void quantizeChunk(int pos) {
        double sum = 0.0;
        for (int i = 0; i < 256; ++i) {
            sum += this.logtable[this.histo[i]];
        }
        int val = (int)Math.floor(sum = sum / 8.0 * 256.0);
        if (val > 255) {
            val = 255;
        }
        this.entropy[pos] = val;
    }
}

