/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import ghidra.app.plugin.core.function.editor.FunctionDataView;
import ghidra.app.plugin.core.function.editor.ParamInfo;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.AutoParameterImpl;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

class FunctionData
extends FunctionDataView {
    public FunctionData(Function function) {
        super(function);
    }

    boolean hasParameterChanges(FunctionDataView originalFunctionData) {
        boolean checkStorage = false;
        if (this.canCustomizeStorage()) {
            checkStorage = true;
        }
        if (!this.returnInfo.getFormalDataType().equals((Object)originalFunctionData.returnInfo.getFormalDataType())) {
            return true;
        }
        if (checkStorage && !this.returnInfo.getStorage().equals((Object)originalFunctionData.returnInfo.getStorage())) {
            return true;
        }
        int paramStartIndex = this.autoParamCount;
        int nonAutoParamCount = this.parameters.size() - paramStartIndex;
        int originalParamStartIndex = originalFunctionData.autoParamCount;
        int originalNonAutoParamCount = originalFunctionData.parameters.size() - originalParamStartIndex;
        if (nonAutoParamCount != originalNonAutoParamCount) {
            return true;
        }
        for (int i = 0; i < nonAutoParamCount; ++i) {
            ParamInfo param = (ParamInfo)this.parameters.get(paramStartIndex + i);
            ParamInfo originalParam = originalFunctionData.parameters.get(originalParamStartIndex + i);
            if (!param.getFormalDataType().equals((Object)originalParam.getFormalDataType())) {
                return true;
            }
            if (checkStorage && !param.getStorage().equals((Object)originalParam.getStorage())) {
                return true;
            }
            if (Objects.equals(param.getName(true), originalParam.getName(true)) || this.function.getParameter(param.getOrdinal()) != null) continue;
            return true;
        }
        return false;
    }

    boolean hasParameterNamesChanged(FunctionDataView originalFunctionData) {
        int paramStartIndex = this.autoParamCount;
        int nonAutoParamCount = this.parameters.size() - paramStartIndex;
        int originalParamStartIndex = originalFunctionData.autoParamCount;
        int originalNonAutoParamCount = originalFunctionData.parameters.size() - originalParamStartIndex;
        if (nonAutoParamCount != originalNonAutoParamCount) {
            return false;
        }
        for (int i = 0; i < nonAutoParamCount; ++i) {
            ParamInfo param = (ParamInfo)this.parameters.get(paramStartIndex + i);
            ParamInfo originalParam = originalFunctionData.parameters.get(originalParamStartIndex + i);
            if (Objects.equals(param.getName(true), originalParam.getName(true))) continue;
            return true;
        }
        return false;
    }

    ParamInfo addNewParameter() {
        ParamInfo param = new ParamInfo(this, null, DataType.DEFAULT, VariableStorage.UNASSIGNED_STORAGE, this.canCustomizeStorage(), this.parameters.size());
        this.parameters.add(param);
        this.fixupOrdinals();
        this.updateParameterAndReturnStorage();
        return param;
    }

    void removeAllParameters() {
        this.parameters.clear();
        this.autoParamCount = 0;
    }

    void removeParameters(List<ParamInfo> paramsToRemove) {
        Iterator it = this.parameters.iterator();
        while (it.hasNext()) {
            ParamInfo p = (ParamInfo)it.next();
            if (!paramsToRemove.contains(p)) continue;
            it.remove();
        }
        this.fixupOrdinals();
        this.updateParameterAndReturnStorage();
    }

    void moveParameterUp(int paramIndex) {
        ParamInfo param = (ParamInfo)this.parameters.remove(paramIndex);
        this.parameters.add(paramIndex - 1, param);
        this.fixupOrdinals();
        this.updateParameterAndReturnStorage();
    }

    void moveParameterDown(int paramIndex) {
        ParamInfo param = (ParamInfo)this.parameters.remove(paramIndex);
        this.parameters.add(paramIndex + 1, param);
        this.fixupOrdinals();
        this.updateParameterAndReturnStorage();
    }

    void setName(String n) {
        this.name = n;
    }

    void setInline(boolean enable) {
        this.isInLine = enable;
    }

    void setHasNoReturn(boolean enable) {
        this.hasNoReturn = enable;
    }

    void clearCallFixup() {
        this.callFixupName = null;
    }

    void setCallFixupName(String cfuName) {
        this.callFixupName = cfuName;
    }

    void setCallingConventionName(String ccName) {
        if (Objects.equals(ccName, this.callingConventionName)) {
            return;
        }
        this.callingConventionName = ccName;
        this.removeExplicitThisParameter();
        this.updateParameterAndReturnStorage();
    }

    void setVarArgs(boolean enable) {
        this.hasVarArgs = enable;
    }

    void updateParameterAndReturnStorage() {
        if (this.allowCustomStorage) {
            this.autoParamCount = 0;
            return;
        }
        PrototypeModel effectiveCallingConvention = this.getEffectiveCallingConvention();
        if (effectiveCallingConvention == null) {
            for (ParamInfo info : this.parameters) {
                info.setStorage(VariableStorage.UNASSIGNED_STORAGE);
            }
            return;
        }
        DataType[] dataTypes = new DataType[this.parameters.size() - this.autoParamCount + 1];
        dataTypes[0] = this.returnInfo.getFormalDataType();
        int index = 1;
        for (int i = this.autoParamCount; i < this.parameters.size(); ++i) {
            dataTypes[index++] = ((ParamInfo)this.parameters.get(i)).getFormalDataType();
        }
        VariableStorage[] paramStorage = effectiveCallingConvention.getStorageLocations(this.getProgram(), dataTypes, true);
        this.returnInfo.setStorage(paramStorage[0]);
        List oldParams = this.parameters;
        int oldAutoCount = this.autoParamCount;
        this.parameters = new ArrayList();
        this.autoParamCount = 0;
        int ordinal = 0;
        for (int i = 1; i < paramStorage.length; ++i) {
            ParamInfo info;
            VariableStorage storage = paramStorage[i];
            if (storage.isAutoStorage()) {
                DataType dt = VariableUtilities.getAutoDataType((Function)this.function, (DataType)this.returnInfo.getFormalDataType(), (VariableStorage)storage);
                try {
                    info = new ParamInfo((FunctionDataView)this, (Parameter)new AutoParameterImpl(dt, ++this.autoParamCount, storage, this.function));
                }
                catch (InvalidInputException e) {
                    throw new AssertException((Throwable)e);
                }
            } else {
                info = (ParamInfo)oldParams.get(oldAutoCount + ordinal);
                info.setStorage(storage);
                ++ordinal;
            }
            this.parameters.add(info);
        }
        this.fixupOrdinals();
    }

    void clearAutoParams() {
        this.autoParamCount = 0;
    }

    void setUseCustomStorage(boolean enable) {
        if (enable == this.allowCustomStorage) {
            return;
        }
        this.allowCustomStorage = enable;
        if (!enable) {
            this.removeExplicitThisParameter();
            DataType returnDt = this.removeExplicitReturnStoragePtrParameter();
            if (returnDt != null) {
                this.returnInfo.setFormalDataType(returnDt);
                this.returnInfo.setStorage(VariableStorage.UNASSIGNED_STORAGE);
            }
            this.updateParameterAndReturnStorage();
        } else {
            this.switchToCustomStorage();
        }
    }

    private void switchToCustomStorage() {
        try {
            VariableStorage returnStorage = this.returnInfo.getStorage();
            DataType returnType = this.returnInfo.getDataType();
            if (returnStorage.isForcedIndirect() && returnStorage.isVoidStorage()) {
                returnType = VoidDataType.dataType;
            }
            this.returnInfo.setFormalDataType(returnType);
            this.returnInfo.setStorage(returnStorage.clone((ProgramArchitecture)this.getProgram()));
            this.autoParamCount = 0;
            for (ParamInfo paramInfo : this.parameters) {
                DataType dt = paramInfo.getDataType();
                VariableStorage storage = paramInfo.getStorage();
                paramInfo.setFormalDataType(dt);
                paramInfo.setStorage(storage.clone((ProgramArchitecture)this.getProgram()));
            }
        }
        catch (InvalidInputException e) {
            throw new AssertException((Throwable)e);
        }
    }

    void removeExplicitThisParameter() {
        int thisIndex;
        if (!this.allowCustomStorage && "__thiscall".equals(this.callingConventionName) && (thisIndex = this.findExplicitThisParameter()) >= 0) {
            this.parameters.remove(thisIndex);
        }
    }

    private DataType removeExplicitReturnStoragePtrParameter() {
        ParamInfo returnStoragePtrParameter;
        DataType dt;
        int index = this.findExplicitReturnStoragePtrParameter();
        if (index >= 0 && (dt = (returnStoragePtrParameter = (ParamInfo)this.parameters.remove(index)).getDataType()) instanceof Pointer) {
            Pointer ptr = (Pointer)dt;
            return ptr.getDataType();
        }
        return null;
    }

    private int findExplicitThisParameter() {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParamInfo p = (ParamInfo)this.parameters.get(i);
            if (p.isAutoParameter() || !"this".equals(p.getName()) || !(p.getDataType() instanceof Pointer)) continue;
            return i;
        }
        return -1;
    }

    private int findExplicitReturnStoragePtrParameter() {
        for (int i = 0; i < this.parameters.size(); ++i) {
            ParamInfo p = (ParamInfo)this.parameters.get(i);
            if (p.isAutoParameter() || !"__return_storage_ptr__".equals(p.getName()) || !(p.getDataType() instanceof Pointer)) continue;
            return i;
        }
        return -1;
    }
}

