/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.overview.entropy;

import generic.theme.GColor;
import ghidra.app.plugin.core.overview.entropy.EntropyChunkSize;
import ghidra.app.plugin.core.overview.entropy.EntropyKnot;
import ghidra.app.plugin.core.overview.entropy.EntropyOverviewColorService;
import ghidra.app.plugin.core.overview.entropy.EntropyRecord;
import ghidra.app.plugin.core.overview.entropy.OverviewPalette;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import java.awt.Color;

public class EntropyOverviewOptionsManager
implements OptionsChangeListener {
    private static final Color UNINITIALIZED_COLOR = new GColor("color.bg.plugin.overview.entropy.uninitialized");
    private static final String OPTIONS_NAME = "Entropy";
    private static final String CHUNKSIZE_STRING = "Chunk size";
    private static final String CHUNKSIZE_DESC_STRING = "Number of bytes per entropy score";
    private static final EntropyChunkSize CHUNKSIZE_DEF = EntropyChunkSize.LARGE;
    private static final String KNOT_COLOR_STRING = "Color to use for highlighting a specific range of entropy values";
    private static final String KNOT_TYPE_STRING = "Type of range to highlight";
    private static final String KNOT1_COLOR_OPTION_NAME = "Range 1 color";
    private static final String KNOT1_TYPE_OPTION_NAME = "Entropy Range 1";
    private static final GColor KNOT1_COLOR = new GColor("color.bg.plugin.overview.entropy.knot.1");
    private static final EntropyKnot KNOT1_DEF_TYPE = EntropyKnot.COMPRESSED;
    private static final String KNOT2_COLOR_OPTION_NAME = "Range 2 color";
    private static final String KNOT2_TYPE_OPTION_NAME = "Entropy Range 2";
    private static final GColor KNOT2_COLOR = new GColor("color.bg.plugin.overview.entropy.knot.2");
    private static final EntropyKnot KNOT2_DEF_TYPE = EntropyKnot.X86;
    private static final String KNOT3_COLOR_OPTION_NAME = "Range 3 color";
    private static final String KNOT3_TYPE_OPTION_NAME = "Entropy Range 3";
    private static final GColor KNOT3_COLOR = new GColor("color.bg.plugin.overview.entropy.knot.3");
    private static final EntropyKnot KNOT3_DEF_TYPE = EntropyKnot.ASCII;
    private static final String KNOT4_COLOR_OPTION_NAME = "Range 4 color";
    private static final String KNOT4_TYPE_OPTION_NAME = "Entropy Range 4";
    private static final GColor KNOT4_COLOR = new GColor("color.bg.plugin.overview.entropy.knot.4");
    private static final EntropyKnot KNOT4_DEF_TYPE = EntropyKnot.UTF16;
    private static final String KNOT5_COLOR_OPTION_NAME = "Range 5 color";
    private static final String KNOT5_TYPE_OPTION_NAME = "Entropy Range 5";
    private static final GColor KNOT5_COLOR = new GColor("color.bg.plugin.overview.entropy.knot.5");
    private static final EntropyKnot KNOT5_DEF_TYPE = EntropyKnot.NONE;
    private static final GColor PALETTE_COLOR_HIGH = new GColor("color.bg.plugin.overview.entropy.palette.base.high");
    private static final GColor PALETTE_COLOR_LOW = new GColor("color.bg.plugin.overview.entropy.palette.base.low");
    private EntropyChunkSize chunksize;
    private EntropyKnot knot1type;
    private EntropyKnot knot2type;
    private EntropyKnot knot3type;
    private EntropyKnot knot4type;
    private EntropyKnot knot5type;
    private OverviewPalette palette = new OverviewPalette(256, UNINITIALIZED_COLOR);
    private EntropyOverviewColorService service;

    public EntropyOverviewOptionsManager(PluginTool tool, EntropyOverviewColorService service) {
        this.service = service;
        ToolOptions options = tool.getOptions(OPTIONS_NAME);
        HelpLocation help = new HelpLocation("OverviewPlugin", "EntropyOverviewBar");
        options.addOptionsChangeListener((OptionsChangeListener)this);
        options.setOptionsHelpLocation(help);
        options.registerOption(CHUNKSIZE_STRING, (Object)CHUNKSIZE_DEF, help, CHUNKSIZE_DESC_STRING);
        options.registerThemeColorBinding(KNOT1_COLOR_OPTION_NAME, KNOT1_COLOR.getId(), help, KNOT_COLOR_STRING);
        options.registerThemeColorBinding(KNOT2_COLOR_OPTION_NAME, KNOT2_COLOR.getId(), help, KNOT_COLOR_STRING);
        options.registerThemeColorBinding(KNOT3_COLOR_OPTION_NAME, KNOT3_COLOR.getId(), help, KNOT_COLOR_STRING);
        options.registerThemeColorBinding(KNOT4_COLOR_OPTION_NAME, KNOT4_COLOR.getId(), help, KNOT_COLOR_STRING);
        options.registerThemeColorBinding(KNOT5_COLOR_OPTION_NAME, KNOT5_COLOR.getId(), help, KNOT_COLOR_STRING);
        options.registerOption(KNOT1_TYPE_OPTION_NAME, (Object)KNOT1_DEF_TYPE, help, KNOT_TYPE_STRING);
        options.registerOption(KNOT2_TYPE_OPTION_NAME, (Object)KNOT2_DEF_TYPE, help, KNOT_TYPE_STRING);
        options.registerOption(KNOT3_TYPE_OPTION_NAME, (Object)KNOT3_DEF_TYPE, help, KNOT_TYPE_STRING);
        options.registerOption(KNOT4_TYPE_OPTION_NAME, (Object)KNOT4_DEF_TYPE, help, KNOT_TYPE_STRING);
        options.registerOption(KNOT5_TYPE_OPTION_NAME, (Object)KNOT5_DEF_TYPE, help, KNOT_TYPE_STRING);
        this.readOptions(options);
        this.updatePalettes();
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        this.readOptions(options);
        this.updatePalettes();
    }

    private void readOptions(ToolOptions options) {
        this.chunksize = (EntropyChunkSize)options.getEnum(CHUNKSIZE_STRING, (Enum)CHUNKSIZE_DEF);
        this.knot1type = (EntropyKnot)options.getEnum(KNOT1_TYPE_OPTION_NAME, (Enum)KNOT1_DEF_TYPE);
        this.knot2type = (EntropyKnot)options.getEnum(KNOT2_TYPE_OPTION_NAME, (Enum)KNOT2_DEF_TYPE);
        this.knot3type = (EntropyKnot)options.getEnum(KNOT3_TYPE_OPTION_NAME, (Enum)KNOT3_DEF_TYPE);
        this.knot4type = (EntropyKnot)options.getEnum(KNOT4_TYPE_OPTION_NAME, (Enum)KNOT4_DEF_TYPE);
        this.knot5type = (EntropyKnot)options.getEnum(KNOT5_TYPE_OPTION_NAME, (Enum)KNOT5_DEF_TYPE);
    }

    private void addPaletteKnot(String name, Color color, double point, double width) {
        int widthint;
        int start;
        int palettewidth = 256;
        int pointint = (int)Math.floor((double)palettewidth / 8.0 * point);
        if (pointint > 255) {
            pointint = 255;
        }
        if ((start = pointint - (widthint = (int)Math.floor((double)palettewidth / 8.0 * width))) < 0) {
            start = 0;
        }
        this.palette.addKnot(name, color, start, pointint);
    }

    private void updatePalettes() {
        this.palette.setBase((Color)PALETTE_COLOR_LOW, (Color)PALETTE_COLOR_HIGH);
        this.addPaletteKnots();
        this.service.paletteChanged();
    }

    private void addPaletteKnots() {
        EntropyRecord rec = this.knot1type.getRecord();
        if (rec != null) {
            this.addPaletteKnot(rec.name, (Color)KNOT1_COLOR, rec.center, rec.width);
        }
        if ((rec = this.knot2type.getRecord()) != null) {
            this.addPaletteKnot(rec.name, (Color)KNOT2_COLOR, rec.center, rec.width);
        }
        if ((rec = this.knot3type.getRecord()) != null) {
            this.addPaletteKnot(rec.name, (Color)KNOT3_COLOR, rec.center, rec.width);
        }
        if ((rec = this.knot4type.getRecord()) != null) {
            this.addPaletteKnot(rec.name, (Color)KNOT4_COLOR, rec.center, rec.width);
        }
        if ((rec = this.knot5type.getRecord()) != null) {
            this.addPaletteKnot(rec.name, (Color)KNOT5_COLOR, rec.center, rec.width);
        }
    }

    public int getChunkSize() {
        return this.chunksize.getChunkSize();
    }

    public OverviewPalette getPalette() {
        return this.palette;
    }
}

