/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.dnd.GClipboard;
import generic.timer.ExpiringSwingTimer;
import ghidra.app.cmd.module.CreateFolderCommand;
import ghidra.app.cmd.module.CreateFragmentCmd;
import ghidra.app.cmd.module.MergeFolderCmd;
import ghidra.app.plugin.core.programtree.PasteManager;
import ghidra.app.plugin.core.programtree.ProgramDnDTree;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.app.plugin.core.programtree.ProgramTreeAction;
import ghidra.app.plugin.core.programtree.ProgramTreeActionContext;
import ghidra.app.plugin.core.programtree.ProgramTreePlugin;
import ghidra.app.plugin.core.programtree.ProgramTreeTransferable;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.NotEmptyException;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.exception.ExceptionUtils;

class ProgramTreeActionManager
implements ClipboardOwner {
    private Clipboard tempClipboard;
    private ProgramNode root;
    private Program program;
    private DockingAction cutAction;
    private DockingAction copyAction;
    private DockingAction pasteAction;
    private DockingAction createFolderAction;
    private DockingAction createFragmentAction;
    private DockingAction mergeAction;
    private DockingAction deleteAction;
    private DockingAction expandAction;
    private DockingAction renameAction;
    private DockingAction collapseAction;
    private DockingAction goToViewAction;
    private DockingAction removeViewAction;
    private DockingAction setViewAction;
    private DockingAction addToViewAction;
    private DockingAction[] actions;
    private PasteManager pasteManager;
    private List<TreePath> viewList;
    private ProgramTreePlugin plugin;
    private boolean isSettingView;

    ProgramTreeActionManager(ProgramTreePlugin plugin) {
        this.plugin = plugin;
        this.tempClipboard = new Clipboard("ProgramTree");
        this.pasteManager = new PasteManager(this);
        this.createActions(plugin.getName());
    }

    void setProgramTreeView(String treeName, ProgramDnDTree tree) {
        if (tree != null) {
            DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
            this.root = (ProgramNode)treeModel.getRoot();
            this.viewList = tree.getViewList();
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        this.clearCutClipboardNodes();
    }

    void setProgram(Program program) {
        this.program = program;
        this.tempClipboard.setContents(null, this);
        if (this.viewList != null) {
            this.viewList.clear();
        }
    }

    String getLastGroupPasted() {
        return this.pasteManager.getLastGroupPasted();
    }

    DockingAction[] getActions() {
        return this.actions;
    }

    private void createActions(String owner) {
        ArrayList<DockingAction> list = new ArrayList<DockingAction>();
        this.goToViewAction = new ProgramTreeAction("Go To start of folder/fragment in View", owner, KeyStroke.getKeyStroke("ENTER")){

            public boolean isEnabledForContext(ActionContext context) {
                if (context instanceof ProgramTreeActionContext) {
                    ProgramTreeActionContext ptac = (ProgramTreeActionContext)context;
                    return ptac.hasSingleNodeSelection() || ptac.hasFullNodeMultiSelection();
                }
                return false;
            }

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.goToView((ProgramTreeActionContext)context);
            }
        };
        this.goToViewAction.setPopupMenuData(new MenuData(new String[]{"Go To in View"}, "aview"));
        list.add(this.goToViewAction);
        this.removeViewAction = new ProgramTreeAction("Remove folder/fragment from View", owner, KeyStroke.getKeyStroke("R")){

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof ProgramTreeActionContext)) {
                    return false;
                }
                ProgramTreeActionContext ptac = (ProgramTreeActionContext)context;
                if (ptac.hasSingleNodeSelection() || ptac.hasFullNodeMultiSelection()) {
                    TreePath[] paths;
                    for (TreePath path : paths = ptac.getSelectionPaths()) {
                        ProgramNode node = (ProgramNode)path.getLastPathComponent();
                        if (!node.isInView()) continue;
                        return true;
                    }
                }
                return false;
            }

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.removeFromView((ProgramTreeActionContext)context);
            }
        };
        this.removeViewAction.setPopupMenuData(new MenuData(new String[]{"Remove from View"}, "aview"));
        list.add(this.removeViewAction);
        this.setViewAction = new ProgramTreeAction("Set View", owner, KeyStroke.getKeyStroke("S")){

            public boolean isEnabledForContext(ActionContext context) {
                if (context instanceof ProgramTreeActionContext) {
                    ProgramTreeActionContext ptac = (ProgramTreeActionContext)context;
                    return ptac.hasSingleNodeSelection() || ptac.hasFullNodeMultiSelection();
                }
                return false;
            }

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.setView((ProgramTreeActionContext)context);
            }
        };
        this.setViewAction.setPopupMenuData(new MenuData(new String[]{"Set View"}, "aview"));
        list.add(this.setViewAction);
        this.addToViewAction = new ProgramTreeAction("Add to View", owner, KeyStroke.getKeyStroke("A")){

            public boolean isEnabledForContext(ActionContext context) {
                if (context instanceof ProgramTreeActionContext) {
                    ProgramTreeActionContext ptac = (ProgramTreeActionContext)context;
                    return ptac.hasSingleNodeSelection() || ptac.hasFullNodeMultiSelection();
                }
                return false;
            }

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.addToView((ProgramTreeActionContext)context);
            }
        };
        this.addToViewAction.setPopupMenuData(new MenuData(new String[]{"Add to View"}, "aview"));
        list.add(this.addToViewAction);
        this.cutAction = new ProgramTreeAction("Cut folder/fragment", owner, null){

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof ProgramTreeActionContext)) {
                    return false;
                }
                ProgramTreeActionContext ptac = (ProgramTreeActionContext)context;
                if (ptac.hasFullNodeMultiSelection()) {
                    return true;
                }
                if (ptac.hasSingleNodeSelection()) {
                    return !ptac.isOnlyRootNodeSelected();
                }
                return false;
            }

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.cut((ProgramTreeActionContext)context);
            }
        };
        this.cutAction.setPopupMenuData(new MenuData(new String[]{"Cut"}, "edit"));
        list.add(this.cutAction);
        this.copyAction = new ProgramTreeAction("Copy folder/fragment", owner, null){

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof ProgramTreeActionContext)) {
                    return false;
                }
                ProgramTreeActionContext ptac = (ProgramTreeActionContext)context;
                if (ptac.hasFullNodeMultiSelection()) {
                    return true;
                }
                if (ptac.hasSingleNodeSelection()) {
                    return !ptac.isOnlyRootNodeSelected();
                }
                return false;
            }

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.copy((ProgramTreeActionContext)context);
            }
        };
        this.copyAction.setPopupMenuData(new MenuData(new String[]{"Copy"}, "edit"));
        list.add(this.copyAction);
        this.pasteAction = new ProgramTreeAction("Paste folder/fragment", owner, null, 0){

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof ProgramTreeActionContext)) {
                    return false;
                }
                ProgramTreeActionContext ptac = (ProgramTreeActionContext)context;
                ProgramNode node = ptac.getSingleSelectedNode();
                return node != null && ProgramTreeActionManager.this.isPasteOk(node);
            }

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionContext ptac = (ProgramTreeActionContext)context;
                ProgramNode node = ptac.getSingleSelectedNode();
                ProgramDnDTree tree = ptac.getTree();
                ProgramTreeActionManager.this.pasteManager.paste(tree, node);
            }
        };
        this.pasteAction.setPopupMenuData(new MenuData(new String[]{"Paste"}, "edit"));
        list.add(this.pasteAction);
        this.createFolderAction = new ProgramTreeAction("Create Folder", owner, null, 0){

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof ProgramTreeActionContext)) {
                    return false;
                }
                ProgramTreeActionContext ptac = (ProgramTreeActionContext)context;
                if (!ptac.hasSingleNodeSelection()) {
                    return false;
                }
                if (ptac.isOnlyRootNodeSelected()) {
                    return true;
                }
                ProgramNode node = ptac.getSingleSelectedNode();
                return !node.isFragment();
            }

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.createFolder((ProgramTreeActionContext)context);
            }
        };
        this.createFolderAction.setPopupMenuData(new MenuData(new String[]{"Create Folder"}, "createGroup"));
        list.add(this.createFolderAction);
        this.createFragmentAction = new ProgramTreeAction("Create Fragment", owner, null, 0){

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof ProgramTreeActionContext)) {
                    return false;
                }
                ProgramTreeActionContext ptac = (ProgramTreeActionContext)context;
                if (!ptac.hasSingleNodeSelection()) {
                    return false;
                }
                if (ptac.isOnlyRootNodeSelected()) {
                    return true;
                }
                ProgramNode node = ptac.getSingleSelectedNode();
                return !node.isFragment();
            }

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.createFragment((ProgramTreeActionContext)context);
            }
        };
        this.createFragmentAction.setPopupMenuData(new MenuData(new String[]{"Create Fragment"}, "createGroup"));
        list.add(this.createFragmentAction);
        this.mergeAction = new ProgramTreeAction("Merge folder/fragment with Parent", owner, null, 0){

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof ProgramTreeActionContext)) {
                    return false;
                }
                ProgramTreeActionContext ptac = (ProgramTreeActionContext)context;
                if (ptac.hasSingleNodeSelection()) {
                    ProgramNode node = ptac.getSingleSelectedNode();
                    if (ptac.isOnlyRootNodeSelected() || node.isFragment()) {
                        return false;
                    }
                }
                return ProgramTreeActionManager.this.isMergeEnabled(ptac);
            }

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.merge((ProgramTreeActionContext)context);
            }
        };
        this.mergeAction.setPopupMenuData(new MenuData(new String[]{"Merge with Parent"}, "merge"));
        list.add(this.mergeAction);
        this.deleteAction = new ProgramTreeAction("Delete folder/fragment", owner, null){

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof ProgramTreeActionContext)) {
                    return false;
                }
                ProgramTreeActionContext ptac = (ProgramTreeActionContext)context;
                return ProgramTreeActionManager.this.isDeleteEnabled(ptac);
            }

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.delete((ProgramTreeActionContext)context);
            }
        };
        this.deleteAction.setPopupMenuData(new MenuData(new String[]{"Delete"}, "delete"));
        this.deleteAction.setKeyBindingData(new KeyBindingData(127, 0));
        list.add(this.deleteAction);
        this.renameAction = new ProgramTreeAction(this, "Rename folder/fragment", owner, null, 0){

            public boolean isEnabledForContext(ActionContext context) {
                if (context instanceof ProgramTreeActionContext) {
                    ProgramTreeActionContext ptac = (ProgramTreeActionContext)context;
                    return ptac.hasSingleNodeSelection();
                }
                return false;
            }

            public void actionPerformed(ActionContext context) {
                ProgramDnDTree tree = ((ProgramTreeActionContext)context).getTree();
                tree.rename();
            }
        };
        this.renameAction.setPopupMenuData(new MenuData(new String[]{"Rename"}, "delete"));
        list.add(this.renameAction);
        this.expandAction = new ProgramTreeAction("Expand All folders/fragments", owner, null, 0){

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof ProgramTreeActionContext)) {
                    return false;
                }
                ProgramTreeActionContext ptac = (ProgramTreeActionContext)context;
                if (!ptac.hasSingleNodeSelection()) {
                    return false;
                }
                if (ptac.isOnlyRootNodeSelected()) {
                    return !ProgramTreeActionManager.this.allPathsExpanded(ptac);
                }
                ProgramNode node = ptac.getSingleSelectedNode();
                if (node.isFragment()) {
                    return false;
                }
                return !ProgramTreeActionManager.this.allPathsExpanded(ptac);
            }

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.expand((ProgramTreeActionContext)context);
            }
        };
        this.expandAction.setPopupMenuData(new MenuData(new String[]{"Expand All"}, "expand"));
        list.add(this.expandAction);
        this.collapseAction = new ProgramTreeAction("Collapse All folders/fragments", owner, null, 0){

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof ProgramTreeActionContext)) {
                    return false;
                }
                ProgramTreeActionContext ptac = (ProgramTreeActionContext)context;
                if (!ptac.hasSingleNodeSelection()) {
                    return false;
                }
                if (ptac.isOnlyRootNodeSelected()) {
                    return !ProgramTreeActionManager.this.allPathsCollapsed(ptac);
                }
                ProgramNode node = ptac.getSingleSelectedNode();
                if (node.isFragment()) {
                    return false;
                }
                return !ProgramTreeActionManager.this.allPathsCollapsed(ptac);
            }

            public void actionPerformed(ActionContext context) {
                ProgramTreeActionManager.this.collapse((ProgramTreeActionContext)context);
            }
        };
        this.collapseAction.setPopupMenuData(new MenuData(new String[]{"Collapse All"}, "expand"));
        list.add(this.collapseAction);
        this.actions = new DockingAction[list.size()];
        this.actions = list.toArray(this.actions);
    }

    void removeFromClipboard(ProgramDnDTree tree, ProgramNode node) {
        try {
            List<ProgramNode> list = this.getProgramNodeListFromClipboard();
            int listSize = 0;
            if (list != null) {
                listSize = list.size();
                list.remove(node);
            }
            this.clearCut(node);
            if (listSize == 0) {
                this.tempClipboard.setContents(null, this);
            }
        }
        catch (UnsupportedFlavorException e) {
            Msg.showError((Object)this, null, (String)("Cut from Clipboard " + this.tempClipboard.getName() + " Failed"), (Object)"Data flavor in clipboard is not supported.", (Throwable)e);
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, (String)("Cut from Clipboard " + this.tempClipboard.getName() + " Failed"), (Object)"Data is no longer available for paste operation", (Throwable)e);
        }
        catch (Exception e) {
            String message = ExceptionUtils.getMessage((Throwable)e);
            Msg.showError((Object)this, null, (String)("Cut from Clipboard " + this.tempClipboard.getName() + " Failed"), (Object)message, (Throwable)e);
        }
    }

    void clearCut(ProgramNode node) {
        node.setDeleted(false);
        this.plugin.repaintProvider();
    }

    boolean clipboardContains(ProgramNode node) {
        try {
            List<ProgramNode> list = this.getProgramNodeListFromClipboard();
            if (list == null) {
                return false;
            }
            return list.contains(node);
        }
        catch (UnsupportedFlavorException e) {
            throw new AssertException("Data flavor in clipboard is not supported.");
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, (String)"Clipboard Check Failed", (Object)"Data is no longer available for paste operation", (Throwable)e);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"Unexpected exception checking clipboard", (Throwable)e);
        }
        return false;
    }

    private List<ProgramNode> getProgramNodeListFromClipboard() throws UnsupportedFlavorException, IOException {
        List<ProgramNode> nodeList = Collections.emptyList();
        Transferable t = this.tempClipboard.getContents(this);
        if (t == null) {
            return nodeList;
        }
        if (!t.isDataFlavorSupported(ProgramTreeTransferable.localTreeNodeFlavor)) {
            return nodeList;
        }
        List list = (List)t.getTransferData(ProgramTreeTransferable.localTreeNodeFlavor);
        return list;
    }

    void cutClipboardNodes(ProgramDnDTree tree) {
        List<ProgramNode> list = this.getNodesFromClipboard();
        for (ProgramNode node : list) {
            if (tree.getModel().getRoot() != node.getRoot()) break;
            ProgramModule parentModule = node.getParentModule();
            Group group = node.getGroup();
            try {
                parentModule.removeChild(group.getName());
            }
            catch (NotEmptyException e) {
                this.clearCut(node);
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
        this.clearSystemClipboard();
        this.tempClipboard.setContents(null, this);
    }

    void clearCutClipboardNodes() {
        List<ProgramNode> list = this.getNodesFromClipboard();
        for (ProgramNode node : list) {
            node.setDeleted(false);
        }
        this.plugin.repaintProvider();
        this.tempClipboard.setContents(null, this);
    }

    private List<ProgramNode> getNodesFromClipboard() {
        try {
            List<ProgramNode> list = this.getProgramNodeListFromClipboard();
            if (list != null) {
                return list;
            }
        }
        catch (UnsupportedFlavorException e) {
            throw new AssertException("Data flavor in clipboard is not supported.");
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"Unexpected exception checking clipboard", (Throwable)e);
        }
        return List.of();
    }

    void clearSystemClipboard() {
        try {
            Clipboard systemClipboard = GClipboard.getSystemClipboard();
            if (!systemClipboard.isDataFlavorAvailable(ProgramTreeTransferable.localTreeNodeFlavor)) {
                return;
            }
            Object data = systemClipboard.getData(ProgramTreeTransferable.localTreeNodeFlavor);
            if (data == null) {
                return;
            }
            this.doClearSystemClipboard(systemClipboard);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doClearSystemClipboard(Clipboard systemClipboard) {
        ProgramTreeTransferable dummyContents = new ProgramTreeTransferable(new ProgramNode[0]);
        systemClipboard.setContents(dummyContents, (clipboard, contents) -> {});
    }

    boolean isReplacingView() {
        return this.isSettingView;
    }

    private void addToView(ProgramTreeActionContext context) {
        TreePath[] paths;
        ProgramDnDTree tree = context.getTree();
        for (TreePath path : paths = context.getSelectionPaths()) {
            this.updateViewList(tree, path);
        }
        tree.fireTreeViewChanged();
    }

    private void goToView(ProgramTreeActionContext context) {
        this.addToView(context);
        ProgramNode node = context.getLeadSelectedNode();
        ProgramFragment f = node.getFragment();
        Address addr = null;
        if (f != null && !f.isEmpty()) {
            addr = f.getMinAddress();
        } else if (f == null) {
            ProgramModule module = node.getModule();
            addr = module.getFirstAddress();
        }
        if (addr != null) {
            ProgramDnDTree tree = context.getTree();
            tree.goTo(addr);
        }
    }

    private void removeFromView(ProgramTreeActionContext context) {
        ProgramDnDTree tree = context.getTree();
        TreePath[] paths = context.getSelectionPaths();
        if (paths.length == 1) {
            TreePath path = paths[0];
            if (this.viewList.contains(path)) {
                tree.removeFromView(path);
            } else {
                ProgramNode node = (ProgramNode)path.getLastPathComponent();
                this.removeChildFromView(tree, node);
            }
        } else {
            for (TreePath path : paths) {
                tree.removeFromView(path);
            }
        }
        tree.fireTreeViewChanged();
    }

    private void removeChildFromView(ProgramDnDTree tree, ProgramNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            ProgramNode child = (ProgramNode)node.getChildAt(i);
            if (child.getAllowsChildren()) {
                this.removeChildFromView(tree, child);
                continue;
            }
            TreePath path = child.getTreePath();
            if (!this.viewList.contains(path)) continue;
            tree.removeFromView(path);
        }
    }

    private void setView(ProgramTreeActionContext context) {
        this.isSettingView = true;
        try {
            ProgramDnDTree tree = context.getTree();
            tree.setViewPaths(context.getSelectionPaths());
        }
        finally {
            this.isSettingView = false;
        }
    }

    private void cut(ProgramTreeActionContext context) {
        this.clearCutClipboardNodes();
        TreePath[] paths = context.getSelectionPaths();
        if (paths.length == 0) {
            return;
        }
        this.setClipboardContents(GClipboard.getSystemClipboard(), paths);
        this.setClipboardContents(this.tempClipboard, paths);
        this.setNodesDeleted(paths);
    }

    private void copy(ProgramTreeActionContext context) {
        this.clearCutClipboardNodes();
        TreePath[] paths = context.getSelectionPaths();
        if (paths.length == 0) {
            return;
        }
        this.setClipboardContents(GClipboard.getSystemClipboard(), paths);
    }

    private void setNodesDeleted(TreePath[] paths) {
        for (TreePath element : paths) {
            ProgramNode node = (ProgramNode)element.getLastPathComponent();
            node.setDeleted(true);
        }
        this.plugin.repaintProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(ProgramTreeActionContext context) {
        ProgramDnDTree tree = context.getTree();
        int transactionID = tree.startTransaction("Delete");
        if (transactionID < 0) {
            return;
        }
        boolean success = false;
        try {
            ProgramNode programNode = this.root;
            synchronized (programNode) {
                TreePath[] paths = context.getSelectionPaths();
                success = this.delete(tree, paths);
            }
        }
        finally {
            tree.endTransaction(transactionID, success);
        }
    }

    private boolean delete(ProgramDnDTree tree, TreePath[] paths) {
        boolean changesMade = false;
        StringBuilder sb = new StringBuilder();
        for (TreePath element : paths) {
            ProgramNode node = (ProgramNode)element.getLastPathComponent();
            if (!tree.removeGroup(node, sb)) continue;
            changesMade = true;
        }
        if (sb.length() > 0) {
            sb.insert(0, "Failed to delete the following:\n");
            Msg.showWarn(this.getClass(), null, (String)"Delete Failed", (Object)sb.toString());
        }
        return changesMade;
    }

    void expand(ProgramTreeActionContext context) {
        ProgramDnDTree tree = context.getTree();
        tree.expandNode(context.getSingleSelectedNode());
        this.plugin.contextChanged();
    }

    private void collapse(ProgramTreeActionContext context) {
        ProgramDnDTree tree = context.getTree();
        this.collapseNode(tree, context.getSingleSelectedNode());
        this.plugin.contextChanged();
    }

    private void collapseNode(ProgramDnDTree tree, ProgramNode node) {
        int nchild = node.getChildCount();
        for (int i = 0; i < nchild; ++i) {
            ProgramNode child = (ProgramNode)node.getChildAt(i);
            if (child.equals(node) || child.isLeaf()) continue;
            this.collapseNode(tree, child);
        }
        tree.collapsePath(node.getTreePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge(ProgramTreeActionContext context) {
        ProgramNode programNode = this.root;
        synchronized (programNode) {
            TreePath[] paths;
            CompoundCmd cmd = new CompoundCmd("Merge with Parent");
            ProgramDnDTree tree = context.getTree();
            String treeName = tree.getTreeName();
            for (TreePath path : paths = context.getSelectionPaths()) {
                ProgramNode node = (ProgramNode)path.getLastPathComponent();
                tree.removeSelectionPath(path);
                ProgramNode parentNode = (ProgramNode)node.getParent();
                if (!node.isModule() || parentNode == null) continue;
                cmd.add((Command)new MergeFolderCmd(treeName, node.getName(), parentNode.getName()));
            }
            PluginTool tool = this.plugin.getTool();
            if (!tool.execute((Command)cmd, (DomainObject)this.program)) {
                tool.setStatusInfo(cmd.getStatusMsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFragment(ProgramTreeActionContext context) {
        ProgramNode programNode = this.root;
        synchronized (programNode) {
            String errMsg = null;
            Program program = this.program;
            synchronized (program) {
                ProgramDnDTree tree = context.getTree();
                String name = tree.getNewFragmentName();
                String treeName = tree.getTreeName();
                ProgramNode node = context.getSingleSelectedNode();
                CreateFragmentCmd cmd = new CreateFragmentCmd(treeName, name, node.getName());
                if (tree.getTool().execute((Command)cmd, (DomainObject)this.program)) {
                    ProgramFragment f = this.program.getListing().getFragment(treeName, name);
                    this.initiateCellEditor(tree, node, (Group)f);
                } else {
                    errMsg = cmd.getStatusMsg();
                }
            }
            if (errMsg != null) {
                Msg.showError((Object)this, null, (String)"Create Fragment Failed", (Object)errMsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFolder(ProgramTreeActionContext context) {
        String errorMessage = null;
        ProgramNode programNode = this.root;
        synchronized (programNode) {
            Program program = this.program;
            synchronized (program) {
                ProgramNode node = context.getSingleSelectedNode();
                node.visit();
                ProgramDnDTree tree = context.getTree();
                String name = tree.getNewFolderName();
                String treeName = tree.getTreeName();
                CreateFolderCommand cmd = new CreateFolderCommand(treeName, name, node.getName());
                if (tree.getTool().execute((Command)cmd, (DomainObject)this.program)) {
                    ProgramModule m = this.program.getListing().getModule(treeName, name);
                    this.initiateCellEditor(tree, node, (Group)m);
                } else {
                    errorMessage = cmd.getStatusMsg();
                }
            }
        }
        if (errorMessage != null) {
            Msg.showError((Object)this, null, (String)"Create Folder Failed", (Object)errorMessage);
        }
    }

    private void getModelNode(ProgramNode parent, Group group, Consumer<ProgramNode> consumer) {
        int expireMs = 3000;
        Supplier<ProgramNode> supplier = () -> {
            int nchild = parent.getChildCount();
            for (int i = 0; i < nchild; ++i) {
                ProgramNode child = (ProgramNode)parent.getChildAt(i);
                if (child.getGroup() != group) continue;
                return child;
            }
            return null;
        };
        ExpiringSwingTimer.get(supplier, (int)expireMs, consumer);
    }

    private void initiateCellEditor(ProgramDnDTree tree, ProgramNode parent, Group group) {
        if (!parent.wasVisited()) {
            tree.visitNode(parent);
        }
        this.getModelNode(parent, group, c -> {
            tree.setEditable(true);
            tree.startEditingAtPath(c.getTreePath());
        });
    }

    private void setClipboardContents(Clipboard clipboard, TreePath[] paths) {
        ProgramNode[] nodes = new ProgramNode[paths.length];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = (ProgramNode)paths[i].getLastPathComponent();
        }
        ProgramTreeTransferable contents = new ProgramTreeTransferable(nodes);
        clipboard.setContents(contents, this);
    }

    private boolean allPathsExpanded(ProgramTreeActionContext context) {
        if (!context.hasSingleNodeSelection()) {
            return false;
        }
        ProgramDnDTree tree = context.getTree();
        TreePath[] paths = context.getSelectionPaths();
        TreePath path = paths[0];
        return this.allPathsExpanded(tree, path);
    }

    private boolean allPathsExpanded(ProgramDnDTree tree, TreePath path) {
        ProgramNode node = (ProgramNode)path.getLastPathComponent();
        if (node.isLeaf()) {
            return true;
        }
        if (tree.isCollapsed(path)) {
            return false;
        }
        boolean allLeaves = true;
        int nchild = node.getChildCount();
        for (int i = 0; i < nchild; ++i) {
            ProgramNode child = (ProgramNode)node.getChildAt(i);
            if (child.isLeaf()) continue;
            allLeaves = false;
            if (!tree.isExpanded(child.getTreePath())) {
                return false;
            }
            if (this.allPathsExpanded(tree, child.getTreePath())) continue;
            return false;
        }
        if (allLeaves) {
            return tree.isExpanded(node.getTreePath());
        }
        return true;
    }

    private boolean allPathsCollapsed(ProgramTreeActionContext context) {
        if (!context.hasSingleNodeSelection()) {
            return false;
        }
        ProgramDnDTree tree = context.getTree();
        TreePath[] paths = context.getSelectionPaths();
        TreePath path = paths[0];
        return this.allPathsCollapsed(tree, path);
    }

    private boolean allPathsCollapsed(ProgramDnDTree tree, TreePath path) {
        ProgramNode node = (ProgramNode)path.getLastPathComponent();
        if (tree.isExpanded(path)) {
            return false;
        }
        boolean allLeaves = true;
        int nchild = node.getChildCount();
        for (int i = 0; i < nchild; ++i) {
            ProgramNode child = (ProgramNode)node.getChildAt(i);
            if (child.isLeaf()) continue;
            allLeaves = false;
            if (!tree.isCollapsed(child.getTreePath())) {
                return false;
            }
            if (this.allPathsCollapsed(tree, child.getTreePath())) continue;
            return false;
        }
        if (allLeaves) {
            return tree.isCollapsed(node.getTreePath());
        }
        return true;
    }

    private boolean isPasteOk(ProgramNode destNode) {
        boolean isCutOperation = false;
        Clipboard systemClipboard = GClipboard.getSystemClipboard();
        if (!systemClipboard.isDataFlavorAvailable(ProgramTreeTransferable.localTreeNodeFlavor)) {
            return false;
        }
        Transferable temp = this.tempClipboard.getContents(this);
        isCutOperation = temp != null;
        try {
            List list = (List)systemClipboard.getData(ProgramTreeTransferable.localTreeNodeFlavor);
            if (list == null) {
                return false;
            }
            boolean pasteEnabled = false;
            for (ProgramNode pasteNode : list) {
                boolean pasteAllowed = this.pasteManager.isPasteAllowed(destNode, pasteNode, isCutOperation);
                if (isCutOperation && !pasteAllowed) {
                    return false;
                }
                if (!isCutOperation && pasteAllowed) {
                    return true;
                }
                pasteEnabled |= pasteAllowed;
            }
            return pasteEnabled;
        }
        catch (UnsupportedFlavorException e) {
            throw new AssertException("Data flavor in clipboard is not supported.");
        }
        catch (IOException e) {
            Msg.showError((Object)this, null, (String)"Cut from Clipboard Failed", (Object)"Data is no longer available for paste operation", (Throwable)e);
        }
        catch (Exception e) {
            String message = ExceptionUtils.getMessage((Throwable)e);
            Msg.showError((Object)this, null, (String)"Check Clipboard Failed", (Object)message, (Throwable)e);
        }
        return false;
    }

    private void updateViewList(ProgramDnDTree tree, TreePath path) {
        ProgramNode node = (ProgramNode)path.getLastPathComponent();
        if (!tree.hasAncestorsInView(node) && !this.viewList.contains(path)) {
            for (int i = 0; i < this.viewList.size(); ++i) {
                TreePath viewPath = this.viewList.get(i);
                if (!path.isDescendant(viewPath)) continue;
                tree.removeFromView(viewPath);
                --i;
            }
            tree.addToView(path);
        }
    }

    private boolean isDeleteEnabled(ProgramTreeActionContext context) {
        TreePath[] paths = context.getSelectionPaths();
        if (paths == null) {
            return false;
        }
        for (TreePath element : paths) {
            ProgramModule m;
            ProgramFragment f;
            ProgramNode node = (ProgramNode)element.getLastPathComponent();
            if (!(node.isFragment() ? (f = node.getFragment()).isEmpty() || !f.isEmpty() && node.getFragment().getNumParents() > 1 : (m = node.getModule()).getNumChildren() == 0 || m.getNumParents() > 1)) continue;
            return true;
        }
        return false;
    }

    private boolean isMergeEnabled(ProgramTreeActionContext context) {
        TreePath[] paths = context.getSelectionPaths();
        if (paths == null) {
            return false;
        }
        for (TreePath element : paths) {
            ProgramNode node = (ProgramNode)element.getLastPathComponent();
            if (!node.isModule()) continue;
            return true;
        }
        return false;
    }
}

