/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GBooleanCellRenderer;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.cmd.function.DeleteFunctionCmd;
import ghidra.app.cmd.label.DeleteLabelCmd;
import ghidra.app.cmd.label.RenameLabelCmd;
import ghidra.app.plugin.core.symtable.DeletedSymbolRowObject;
import ghidra.app.plugin.core.symtable.NewSymbolFilter;
import ghidra.app.plugin.core.symtable.SymbolFilter;
import ghidra.app.plugin.core.symtable.SymbolRenderer;
import ghidra.app.plugin.core.symtable.SymbolRowObject;
import ghidra.app.util.template.TemplateSimplifier;
import ghidra.docking.settings.Settings;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.LabelHistory;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.AbstractWrapperTypeColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.table.field.AbstractProgramLocationTableColumn;
import ghidra.util.table.field.AddressBasedLocation;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractSymbolTableModel
extends AddressBasedTableModel<SymbolRowObject> {
    private static final Comparator<SymbolRowObject> NAME_COL_COMPARATOR = (s1, s2) -> s1.toString().compareToIgnoreCase(s2.toString());
    public static final int LABEL_COL = 0;
    public static final int LOCATION_COL = 1;
    public static final int TYPE_COL = 2;
    public static final int DATA_TYPE_COL = 3;
    public static final int NAMESPACE_COL = 4;
    public static final int SOURCE_COL = 5;
    public static final int REFS_COL = 6;
    private PluginTool tool;
    protected SymbolTable symbolTable;
    protected ReferenceManager refMgr;
    protected SymbolRowObject lastSymbol;
    protected SymbolFilter filter;
    protected SymbolRenderer symbolRenderer = new SymbolRenderer();

    AbstractSymbolTableModel(PluginTool tool) {
        super("Symbols", (ServiceProvider)tool, null, null);
        this.tool = tool;
        this.filter = new NewSymbolFilter();
    }

    @Override
    protected TableColumnDescriptor<SymbolRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new NameTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new LocationTableColumn(), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new SymbolTypeTableColumn(this));
        descriptor.addHiddenColumn((DynamicTableColumn)new DataTypeTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new NamespaceTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new SourceTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new ReferenceCountTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new OffcutReferenceCountTableColumn(this));
        descriptor.addHiddenColumn((DynamicTableColumn)new PinnedTableColumn(this));
        descriptor.addHiddenColumn((DynamicTableColumn)new UserTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new OriginalNameColumn(this));
        descriptor.addHiddenColumn((DynamicTableColumn)new SimplifiedNameColumn(this));
        return descriptor;
    }

    void setFilter(SymbolFilter filter) {
        this.filter = filter;
        this.reload();
    }

    Symbol getSymbol(long symbolID) {
        if (this.symbolTable != null) {
            return this.symbolTable.getSymbol(symbolID);
        }
        return null;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.symbolTable = null;
        this.refMgr = null;
        this.lastSymbol = null;
    }

    void reload(Program prog) {
        this.cancelAllUpdates();
        this.lastSymbol = null;
        if (prog != null) {
            this.setProgram(prog);
            this.symbolTable = prog.getSymbolTable();
            this.refMgr = prog.getReferenceManager();
            this.reload();
        } else {
            this.setProgram(null);
            this.symbolTable = null;
            this.refMgr = null;
        }
    }

    public int getKeyCount() {
        if (this.symbolTable != null) {
            int cnt = this.symbolTable.getNumSymbols();
            if (this.filter.acceptsDefaultLabelSymbols()) {
                cnt += this.refMgr.getReferenceDestinationCount();
            }
            return cnt;
        }
        return 0;
    }

    public boolean isSortable(int columnIndex) {
        return true;
    }

    public boolean isCellEditable(int key, int columnIndex) {
        return columnIndex == 0;
    }

    public void setValueAt(Object aValue, int row, int columnIndex) {
        if (this.symbolTable == null || aValue == null) {
            return;
        }
        if (row < 0 || row >= this.filteredData.size()) {
            return;
        }
        Symbol symbol = ((SymbolRowObject)this.filteredData.get(row)).getSymbol();
        if (symbol == null || symbol.isDeleted()) {
            return;
        }
        if (columnIndex != 0) {
            return;
        }
        String newName = aValue.toString();
        if (symbol.getName().equals(newName)) {
            return;
        }
        RenameLabelCmd cmd = new RenameLabelCmd(symbol, newName, SourceType.USER_DEFINED);
        if (!this.tool.execute((Command)cmd, (DomainObject)this.getProgram())) {
            Msg.showError(this.getClass(), null, (String)"Error Renaming Symbol", (Object)cmd.getStatusMsg());
        }
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int column) {
        Symbol s = (Symbol)this.getValueAt(row, 0);
        if (s == null || s.isDeleted()) {
            return null;
        }
        return s.getProgramLocation();
    }

    public ProgramLocation getProgramLocation(int row) {
        return (ProgramLocation)this.getValueAt(row, 1);
    }

    @Override
    public ProgramSelection getProgramSelection(int[] rows) {
        AddressSet set = new AddressSet();
        for (int element : rows) {
            AddressBasedLocation symbolLocation = this.getSymbolLocation(((SymbolRowObject)this.getRowObject(element)).getSymbol());
            if (!symbolLocation.isMemoryLocation()) continue;
            set.add(symbolLocation.getAddress());
        }
        return new ProgramSelection((AddressSetView)set);
    }

    public void reload() {
        this.lastSymbol = null;
        super.reload();
    }

    void symbolAdded(Symbol s) {
        if (this.filter.accepts(s, this.getProgram())) {
            this.lastSymbol = new SymbolRowObject(s);
            this.addObject(this.lastSymbol);
        }
    }

    void symbolRemoved(long symbolId) {
        DeletedSymbolRowObject deletedSymbol = new DeletedSymbolRowObject(this.program, symbolId);
        if (deletedSymbol.equals(this.lastSymbol)) {
            this.lastSymbol = null;
        }
        this.removeObject(deletedSymbol);
    }

    void symbolChanged(Symbol s) {
        if (this.filter.accepts(s, this.getProgram())) {
            this.updateObject(new SymbolRowObject(s));
        } else {
            this.removeObject(new SymbolRowObject(s));
        }
    }

    void delete(List<Symbol> rowObjects) {
        if (rowObjects == null || rowObjects.isEmpty()) {
            return;
        }
        this.tool.setStatusInfo("");
        LinkedList<Symbol> deleteList = new LinkedList<Symbol>();
        CompoundCmd cmd = new CompoundCmd("Delete symbol(s)");
        for (Symbol symbol : rowObjects) {
            if (symbol.isDynamic()) continue;
            deleteList.add(symbol);
            String label = symbol.getName();
            Address address = symbol.getAddress();
            if (symbol.getSymbolType() == SymbolType.FUNCTION) {
                Function function = (Function)symbol.getObject();
                boolean ignoreMissingFunction = function.isThunk();
                cmd.add((Command)new DeleteFunctionCmd(address, ignoreMissingFunction));
                if (symbol.getSource() == SourceType.DEFAULT) continue;
                cmd.add((Command)new DeleteLabelCmd(address, label, symbol.getParentNamespace()));
                continue;
            }
            cmd.add((Command)new DeleteLabelCmd(address, label, symbol.getParentNamespace()));
        }
        if (cmd.size() == 0) {
            return;
        }
        if (this.tool.execute((Command)cmd, (DomainObject)this.getProgram())) {
            for (Symbol s : deleteList) {
                this.removeObject(new SymbolRowObject(s));
            }
            this.updateNow();
        } else {
            this.tool.setStatusInfo(cmd.getStatusMsg());
            this.reload();
        }
    }

    public SymbolFilter getFilter() {
        return this.filter;
    }

    @Override
    public Address getAddress(int row) {
        SymbolRowObject rowObject = (SymbolRowObject)this.getRowObject(row);
        if (rowObject == null) {
            return null;
        }
        Symbol symbol = rowObject.getSymbol();
        if (symbol == null || symbol.isDeleted()) {
            return null;
        }
        return symbol.getAddress();
    }

    private AddressBasedLocation getSymbolLocation(Symbol s) {
        if (s == null) {
            return new AddressBasedLocation();
        }
        SymbolType type = s.getSymbolType();
        if (type == SymbolType.PARAMETER || type == SymbolType.LOCAL_VAR) {
            Variable object = (Variable)s.getObject();
            if (object == null) {
                return null;
            }
            return new VariableSymbolLocation(this, object);
        }
        return new AddressBasedLocation(this.program, s.getAddress());
    }

    protected Comparator<SymbolRowObject> createSortComparator(int columnIndex) {
        DynamicTableColumn column = this.getColumn(columnIndex);
        if (column instanceof NameTableColumn) {
            return NAME_COL_COMPARATOR;
        }
        return super.createSortComparator(columnIndex);
    }

    public SymbolRenderer getSymbolRenderer() {
        return this.symbolRenderer;
    }

    private class NameTableColumn
    extends AbstractProgramBasedDynamicTableColumn<SymbolRowObject, Symbol> {
        private NameTableColumn(AbstractSymbolTableModel abstractSymbolTableModel) {
        }

        public String getColumnName() {
            return "Name";
        }

        public Symbol getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            return rowObject.getSymbol();
        }
    }

    private class LocationTableColumn
    extends AbstractProgramLocationTableColumn<SymbolRowObject, AddressBasedLocation> {
        private LocationTableColumn() {
        }

        public String getColumnName() {
            return "Location";
        }

        public AddressBasedLocation getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            Symbol symbol = rowObject.getSymbol();
            return AbstractSymbolTableModel.this.getSymbolLocation(symbol);
        }

        @Override
        public ProgramLocation getProgramLocation(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) {
            Symbol symbol = rowObject.getSymbol();
            if (symbol == null || symbol.isDeleted()) {
                return null;
            }
            return symbol.getProgramLocation();
        }
    }

    private class SymbolTypeTableColumn
    extends AbstractProgramBasedDynamicTableColumn<SymbolRowObject, String> {
        private SymbolTypeTableColumn(AbstractSymbolTableModel abstractSymbolTableModel) {
        }

        public String getColumnName() {
            return "Type";
        }

        public String getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            Symbol symbol = rowObject.getSymbol();
            if (symbol == null || symbol.isDeleted()) {
                return null;
            }
            return SymbolUtilities.getSymbolTypeDisplayName((Symbol)symbol);
        }
    }

    private class DataTypeTableColumn
    extends AbstractProgramBasedDynamicTableColumn<SymbolRowObject, String> {
        private DataTypeTableColumn(AbstractSymbolTableModel abstractSymbolTableModel) {
        }

        public String getColumnName() {
            return "Data Type";
        }

        public String getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            Symbol symbol = rowObject.getSymbol();
            if (symbol == null || symbol.isDeleted()) {
                return null;
            }
            DataType dt = null;
            Object obj = symbol.getObject();
            if (obj instanceof Data) {
                dt = ((Data)obj).getDataType();
            } else if (obj instanceof Function) {
                dt = ((Function)obj).getReturnType();
            } else if (obj instanceof Variable) {
                dt = ((Variable)obj).getDataType();
            } else if (obj instanceof ExternalLocation) {
                dt = ((ExternalLocation)obj).getDataType();
            }
            if (dt != null) {
                return dt.getDisplayName();
            }
            return "";
        }
    }

    private class NamespaceTableColumn
    extends AbstractProgramBasedDynamicTableColumn<SymbolRowObject, String> {
        private NamespaceTableColumn(AbstractSymbolTableModel abstractSymbolTableModel) {
        }

        public String getColumnName() {
            return "Namespace";
        }

        public String getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            Symbol symbol = rowObject.getSymbol();
            if (symbol == null || symbol.isDeleted()) {
                return null;
            }
            return symbol.getParentNamespace().getName(true);
        }
    }

    private class SourceTableColumn
    extends AbstractProgramBasedDynamicTableColumn<SymbolRowObject, SourceType> {
        private GColumnRenderer<SourceType> renderer = new AbstractGColumnRenderer<SourceType>(){

            protected String getText(Object value) {
                if (value == null) {
                    return "";
                }
                return ((SourceType)value).getDisplayString();
            }

            public String getFilterString(SourceType t, Settings settings) {
                return this.getText(t);
            }
        };

        private SourceTableColumn(AbstractSymbolTableModel abstractSymbolTableModel) {
        }

        public String getColumnName() {
            return "Source";
        }

        public GColumnRenderer<SourceType> getColumnRenderer() {
            return this.renderer;
        }

        public SourceType getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            Symbol symbol = rowObject.getSymbol();
            if (symbol == null || symbol.isDeleted()) {
                return null;
            }
            return symbol.getSource();
        }
    }

    private class ReferenceCountTableColumn
    extends AbstractProgramBasedDynamicTableColumn<SymbolRowObject, Integer> {
        private ReferenceCountRenderer renderer = new ReferenceCountRenderer();

        private ReferenceCountTableColumn(AbstractSymbolTableModel abstractSymbolTableModel) {
        }

        public String getColumnName() {
            return "Reference Count";
        }

        public Integer getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            Symbol symbol = rowObject.getSymbol();
            if (symbol == null || symbol.isDeleted()) {
                return null;
            }
            return symbol.getReferenceCount();
        }

        public GColumnRenderer<Integer> getColumnRenderer() {
            return this.renderer;
        }

        private class ReferenceCountRenderer
        extends GTableCellRenderer
        implements AbstractWrapperTypeColumnRenderer<Integer> {
            private ReferenceCountRenderer() {
            }
        }
    }

    private class OffcutReferenceCountTableColumn
    extends AbstractProgramBasedDynamicTableColumn<SymbolRowObject, Integer> {
        private OffcutReferenceCountRenderer renderer = new OffcutReferenceCountRenderer();

        private OffcutReferenceCountTableColumn(AbstractSymbolTableModel abstractSymbolTableModel) {
        }

        public String getColumnName() {
            return "Offcut Ref Count";
        }

        public Integer getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            CodeUnit codeUnit;
            Symbol symbol = rowObject.getSymbol();
            if (symbol == null || symbol.isDeleted()) {
                return null;
            }
            Address address = symbol.getAddress();
            int count = 0;
            if (address.isMemoryAddress() && (codeUnit = p.getListing().getCodeUnitContaining(address)) != null) {
                AddressSet set = new AddressSet(codeUnit.getMinAddress(), codeUnit.getMaxAddress());
                set.deleteRange(address, address);
                ReferenceManager referenceManager = p.getReferenceManager();
                AddressIterator it = referenceManager.getReferenceDestinationIterator((AddressSetView)set, true);
                while (it.hasNext()) {
                    it.next();
                    ++count;
                }
            }
            return count;
        }

        public GColumnRenderer<Integer> getColumnRenderer() {
            return this.renderer;
        }

        private class OffcutReferenceCountRenderer
        extends GTableCellRenderer
        implements AbstractWrapperTypeColumnRenderer<Integer> {
            private OffcutReferenceCountRenderer() {
            }
        }
    }

    private class PinnedTableColumn
    extends AbstractProgramBasedDynamicTableColumn<SymbolRowObject, Boolean> {
        private PinnedRenderer renderer = new PinnedRenderer();

        private PinnedTableColumn(AbstractSymbolTableModel abstractSymbolTableModel) {
        }

        public String getColumnName() {
            return "Pinned";
        }

        public Boolean getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            Symbol symbol = rowObject.getSymbol();
            if (symbol == null || symbol.isDeleted()) {
                return null;
            }
            return symbol.isPinned();
        }

        public GColumnRenderer<Boolean> getColumnRenderer() {
            return this.renderer;
        }

        private class PinnedRenderer
        extends GBooleanCellRenderer
        implements AbstractWrapperTypeColumnRenderer<Boolean> {
            private PinnedRenderer() {
            }
        }
    }

    private class UserTableColumn
    extends AbstractProgramBasedDynamicTableColumn<SymbolRowObject, String> {
        private UserTableColumn() {
        }

        public String getColumnName() {
            return "User";
        }

        public String getColumnDescription() {
            return "The user that created or last edited this symbol.";
        }

        public String getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            Symbol symbol = rowObject.getSymbol();
            if (symbol == null || symbol.isDeleted()) {
                return null;
            }
            SourceType source = symbol.getSource();
            if (source != SourceType.USER_DEFINED) {
                return null;
            }
            Address address = symbol.getAddress();
            LabelHistory[] labelHistory = AbstractSymbolTableModel.this.symbolTable.getLabelHistory(address);
            if (labelHistory.length > 0) {
                return labelHistory[0].getUserName();
            }
            return null;
        }
    }

    class OriginalNameColumn
    extends AbstractProgramBasedDynamicTableColumn<SymbolRowObject, String> {
        OriginalNameColumn(AbstractSymbolTableModel this$0) {
        }

        public String getColumnName() {
            return "Original Imported Name";
        }

        public String getColumnDescription() {
            return "The original (pre-demangled) import name (External Symbols Only)";
        }

        public String getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            Symbol symbol = rowObject.getSymbol();
            if (symbol == null || symbol.isDeleted()) {
                return null;
            }
            if (!symbol.isExternal()) {
                return null;
            }
            SymbolType symbolType = symbol.getSymbolType();
            if (symbolType != SymbolType.FUNCTION && symbolType != SymbolType.LABEL) {
                return null;
            }
            ExternalManager externalManager = p.getExternalManager();
            ExternalLocation externalLocation = externalManager.getExternalLocation(symbol);
            if (externalLocation != null) {
                return externalLocation.getOriginalImportedName();
            }
            return null;
        }
    }

    private class SimplifiedNameColumn
    extends AbstractProgramBasedDynamicTableColumn<SymbolRowObject, String> {
        private TemplateSimplifier simplifier = new TemplateSimplifier();

        private SimplifiedNameColumn(AbstractSymbolTableModel abstractSymbolTableModel) {
        }

        public String getColumnName() {
            return "Simplified Name";
        }

        public String getColumnDescription() {
            return "The symbol name with less complicated template arguments";
        }

        public String getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            Symbol symbol = rowObject.getSymbol();
            if (symbol == null || symbol.isDeleted()) {
                return null;
            }
            String name = symbol.getName();
            return this.simplifier.simplify(name);
        }
    }

    private class VariableSymbolLocation
    extends AddressBasedLocation {
        VariableSymbolLocation(AbstractSymbolTableModel abstractSymbolTableModel, Variable variable) {
            super(variable.getSymbol().getAddress(), variable.getVariableStorage().toString());
        }
    }
}

