/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import java.util.Objects;

public class SymbolRowObject
implements Comparable<SymbolRowObject> {
    private final long id;
    private final Program program;

    public SymbolRowObject(Symbol s) {
        this.id = s.getID();
        this.program = Objects.requireNonNull(s.getProgram());
    }

    protected SymbolRowObject(Program program, long symbolId) {
        this.id = symbolId;
        this.program = Objects.requireNonNull(program);
    }

    public long getID() {
        return this.id;
    }

    public Symbol getSymbol() {
        return this.program != null ? this.program.getSymbolTable().getSymbol(this.id) : null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SymbolRowObject)) {
            return false;
        }
        SymbolRowObject other = (SymbolRowObject)obj;
        return this.id == other.id && this.program == other.program;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public String toString() {
        Symbol s = this.getSymbol();
        return s != null ? s.getName() : "<DELETED>";
    }

    @Override
    public int compareTo(SymbolRowObject other) {
        return Long.compare(this.id, other.id);
    }
}

