/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.terminal;

import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextField;
import docking.widgets.fieldpanel.internal.FieldBackgroundColorManager;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.support.DefaultRowColLocation;
import docking.widgets.fieldpanel.support.Highlight;
import docking.widgets.fieldpanel.support.RowColLocation;
import ghidra.app.plugin.core.terminal.TerminalTextFieldElement;
import ghidra.app.plugin.core.terminal.vt.AnsiColorResolver;
import ghidra.app.plugin.core.terminal.vt.VtLine;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;

public class TerminalTextField
implements TextField {
    protected final int startX;
    protected final TerminalTextFieldElement element;
    protected final int em;
    protected boolean isPrimary;

    public static TerminalTextField create(VtLine line, FontMetrics metrics, float fontSizeAdjustment, AnsiColorResolver colors) {
        return new TerminalTextField(0, new TerminalTextFieldElement(line, metrics, fontSizeAdjustment, colors), metrics);
    }

    protected TerminalTextField(int startX, TerminalTextFieldElement element, FontMetrics metrics) {
        this.startX = startX;
        this.element = element;
        this.em = metrics.charWidth('M');
    }

    public void paint(JComponent c, Graphics g, PaintContext context, Rectangle clip, FieldBackgroundColorManager colorManager, RowColLocation cursorLoc, int rowHeight) {
        if (context.isPrinting()) {
            this.print(g, context);
        } else {
            this.paintSelection(g, colorManager, 0, rowHeight);
            this.paintText(c, g, context);
            this.paintCursor(g, context.getCursorColor(), cursorLoc);
        }
    }

    protected void print(Graphics g, PaintContext context) {
        this.element.paint(null, g, this.startX, 0);
    }

    protected void paintText(JComponent c, Graphics g, PaintContext context) {
        this.element.paint(c, g, this.startX, 0);
    }

    protected void paintSelection(Graphics g, FieldBackgroundColorManager colorManager, int row, int rowHeight) {
        List selections = colorManager.getSelectionHighlights(row);
        if (selections.isEmpty()) {
            return;
        }
        int textLength = this.element.length();
        int endTextPos = this.findX(textLength);
        for (Highlight highlight : selections) {
            g.setColor(highlight.getColor());
            int startCol = highlight.getStart();
            int endCol = highlight.getEnd();
            int x1 = this.findX(startCol);
            int x2 = endCol < this.element.length() ? this.findX(endCol) : endTextPos;
            g.fillRect(this.startX + x1, -this.getHeightAbove(), x2 - x1, this.getHeight());
        }
    }

    protected void paintCursor(Graphics g, Color cursorColor, RowColLocation cursorLoc) {
        if (cursorLoc != null) {
            g.setColor(cursorColor);
            int x = this.startX + this.findX(cursorLoc.col());
            g.drawRect(x, -this.getHeightAbove(), this.em - 1, this.getHeight() - 1);
        }
    }

    protected int findX(int col) {
        return this.em * col;
    }

    public int getWidth() {
        return this.element.getStringWidth();
    }

    public int getPreferredWidth() {
        return this.element.getStringWidth();
    }

    public int getHeight() {
        return this.element.getHeightAbove() + this.element.getHeightBelow();
    }

    public int getHeightAbove() {
        return this.element.getHeightAbove();
    }

    public int getHeightBelow() {
        return this.element.getHeightBelow();
    }

    public int getStartX() {
        return this.startX;
    }

    public boolean contains(int x, int y) {
        return x >= this.startX && x < this.startX + this.getWidth() && y >= -this.element.getHeightAbove() && y < this.element.getHeightBelow();
    }

    public int getNumDataRows() {
        return 1;
    }

    public int getNumRows() {
        return 1;
    }

    public int getNumCols(int row) {
        return this.element.getNumCols();
    }

    public int getX(int row, int col) {
        return this.startX + this.findX(col);
    }

    public int getY(int row) {
        return -this.getHeightAbove();
    }

    public int getRow(int y) {
        return 0;
    }

    public int getCol(int row, int x) {
        int relX = Math.max(0, x - this.startX);
        return this.element.getMaxCharactersForWidth(relX);
    }

    public boolean isValid(int row, int col) {
        return row == 0 && 0 <= col && col < this.getNumCols(0);
    }

    public Rectangle getCursorBounds(int row, int col) {
        if (row != 0) {
            return null;
        }
        int x = this.findX(col) + this.startX;
        return new Rectangle(x, -this.getHeightAbove(), this.em, this.getHeight());
    }

    public int getScrollableUnitIncrement(int topOfScreen, int direction, int max) {
        if (topOfScreen < -this.getHeightAbove() || topOfScreen > this.getHeightBelow()) {
            return max;
        }
        if (direction > 0) {
            return this.getHeightBelow() - topOfScreen;
        }
        return -this.getHeightAbove() - topOfScreen;
    }

    public void setPrimary(boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public void rowHeightChanged(int heightAbove, int heightBelow) {
    }

    public String getText() {
        return this.element.getText();
    }

    public String getTextWithLineSeparators() {
        return this.element.getText();
    }

    public RowColLocation textOffsetToScreenLocation(int textOffset) {
        return new RowColLocation(0, Math.min(textOffset, this.element.length()));
    }

    public int screenLocationToTextOffset(int row, int col) {
        return Math.min(this.element.length(), col);
    }

    public RowColLocation screenToDataLocation(int screenRow, int screenColumn) {
        return this.element.getDataLocationForCharacterIndex(screenColumn);
    }

    public RowColLocation dataToScreenLocation(int dataRow, int dataColumn) {
        int column = this.element.getCharacterIndexForDataLocation(dataRow, dataColumn);
        if (column < 0) {
            return new DefaultRowColLocation(0, this.element.length());
        }
        return new RowColLocation(0, column);
    }

    public boolean isClipped() {
        return false;
    }

    public FieldElement getFieldElement(int screenRow, int screenColumn) {
        return this.element.getFieldElement(screenColumn);
    }
}

